/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.cloud;

import java.util.Optional;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.cloud.ServiceRegistry;
import org.apache.camel.impl.cloud.ServiceRegistrySelectors;
import org.apache.camel.util.ObjectHelper;

public final class ServiceRegistryHelper {
    private ServiceRegistryHelper() {
    }

    public static Optional<ServiceRegistry> lookupService(CamelContext context) {
        return ServiceRegistryHelper.lookupService(context, ServiceRegistrySelectors.DEFAULT_SELECTOR);
    }

    public static Optional<ServiceRegistry> lookupService(CamelContext context, ServiceRegistry.Selector selector) {
        ObjectHelper.notNull(context, "Camel Context");
        ObjectHelper.notNull(selector, "ServiceRegistry selector");
        Set<ServiceRegistry> services = context.hasServices(ServiceRegistry.class);
        if (ObjectHelper.isNotEmpty(services)) {
            return selector.select(services);
        }
        return Optional.empty();
    }

    public static ServiceRegistry mandatoryLookupService(CamelContext context) {
        return ServiceRegistryHelper.lookupService(context).orElseThrow(() -> new IllegalStateException("ServiceRegistry service not found"));
    }

    public static ServiceRegistry mandatoryLookupService(CamelContext context, ServiceRegistry.Selector selector) {
        return ServiceRegistryHelper.lookupService(context, selector).orElseThrow(() -> new IllegalStateException("ServiceRegistry service not found"));
    }
}

