/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.NamedNode;
import org.apache.camel.impl.event.DefaultEventFactory;
import org.apache.camel.spi.CamelEvent;
import org.apache.camel.spi.EventFactory;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.spi.ManagementAgent;
import org.apache.camel.spi.ManagementObjectNameStrategy;
import org.apache.camel.spi.ManagementObjectStrategy;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.support.OrderedComparator;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.ObjectHelper;

public class DefaultManagementStrategy
extends ServiceSupport
implements ManagementStrategy,
CamelContextAware {
    private final List<EventNotifier> eventNotifiers = new CopyOnWriteArrayList<EventNotifier>();
    private final List<EventNotifier> startedEventNotifiers = new CopyOnWriteArrayList<EventNotifier>();
    private EventFactory eventFactory = new DefaultEventFactory();
    private ManagementObjectNameStrategy managementObjectNameStrategy;
    private ManagementObjectStrategy managementObjectStrategy;
    private ManagementAgent managementAgent;
    private CamelContext camelContext;

    public DefaultManagementStrategy() {
    }

    public DefaultManagementStrategy(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public DefaultManagementStrategy(CamelContext camelContext, ManagementAgent managementAgent) {
        this.camelContext = camelContext;
        this.managementAgent = managementAgent;
    }

    public List<EventNotifier> getEventNotifiers() {
        return this.eventNotifiers;
    }

    public List<EventNotifier> getStartedEventNotifiers() {
        return this.startedEventNotifiers;
    }

    public void addEventNotifier(EventNotifier eventNotifier) {
        this.eventNotifiers.add(eventNotifier);
        this.eventNotifiers.sort((Comparator<EventNotifier>)OrderedComparator.get());
        if (this.isStarted()) {
            this.startedEventNotifiers.add(eventNotifier);
            this.startedEventNotifiers.sort((Comparator<EventNotifier>)OrderedComparator.get());
        }
        if (this.getCamelContext() != null) {
            CamelContextAware.trySetCamelContext((Object)eventNotifier, (CamelContext)this.getCamelContext());
            if (!eventNotifier.isIgnoreExchangeEvents()) {
                this.getCamelContext().getCamelContextExtension().setEventNotificationApplicable(true);
            }
        }
    }

    public boolean removeEventNotifier(EventNotifier eventNotifier) {
        this.startedEventNotifiers.remove(eventNotifier);
        return this.eventNotifiers.remove(eventNotifier);
    }

    public EventFactory getEventFactory() {
        return this.eventFactory;
    }

    public void setEventFactory(EventFactory eventFactory) {
        this.eventFactory = eventFactory;
    }

    public ManagementObjectNameStrategy getManagementObjectNameStrategy() {
        return this.managementObjectNameStrategy;
    }

    public void setManagementObjectNameStrategy(ManagementObjectNameStrategy managementObjectNameStrategy) {
        this.managementObjectNameStrategy = managementObjectNameStrategy;
    }

    public ManagementObjectStrategy getManagementObjectStrategy() {
        return this.managementObjectStrategy;
    }

    public void setManagementObjectStrategy(ManagementObjectStrategy managementObjectStrategy) {
        this.managementObjectStrategy = managementObjectStrategy;
    }

    public ManagementAgent getManagementAgent() {
        return this.managementAgent;
    }

    public void setManagementAgent(ManagementAgent managementAgent) {
        this.managementAgent = managementAgent;
    }

    public boolean manageProcessor(NamedNode definition) {
        return false;
    }

    public void manageObject(Object managedObject) throws Exception {
    }

    public void unmanageObject(Object managedObject) throws Exception {
    }

    public boolean isManaged(Object managedObject) {
        return false;
    }

    public boolean isManagedName(Object name) {
        return false;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public void notify(CamelEvent event) throws Exception {
        if (!this.eventNotifiers.isEmpty()) {
            for (EventNotifier notifier : this.eventNotifiers) {
                if (!notifier.isEnabled(event)) continue;
                notifier.notify(event);
            }
        }
    }

    protected void doInit() throws Exception {
        ObjectHelper.notNull((Object)this.getCamelContext(), (String)"CamelContext", (Object)((Object)this));
        if (!this.getEventNotifiers().isEmpty()) {
            this.getCamelContext().getCamelContextExtension().setEventNotificationApplicable(true);
        }
        for (EventNotifier notifier : this.eventNotifiers) {
            CamelContextAware.trySetCamelContext((Object)notifier, (CamelContext)this.camelContext);
        }
        ServiceHelper.initService((Object[])new Object[]{this.eventNotifiers, this.managementAgent});
        if (this.managementObjectStrategy == null) {
            this.managementObjectStrategy = this.createManagementObjectStrategy();
        }
        CamelContextAware.trySetCamelContext((Object)this.managementObjectStrategy, (CamelContext)this.getCamelContext());
        if (this.managementObjectNameStrategy == null) {
            this.managementObjectNameStrategy = this.createManagementObjectNameStrategy();
        }
        CamelContextAware.trySetCamelContext((Object)this.managementObjectNameStrategy, (CamelContext)this.getCamelContext());
        ServiceHelper.initService((Object[])new Object[]{this.managementObjectStrategy, this.managementObjectNameStrategy});
    }

    protected void doStart() throws Exception {
        ServiceHelper.startService((Object[])new Object[]{this.eventNotifiers, this.managementAgent, this.managementObjectStrategy, this.managementObjectNameStrategy});
        this.startedEventNotifiers.addAll(this.eventNotifiers);
    }

    protected void doStop() throws Exception {
        this.startedEventNotifiers.clear();
        ServiceHelper.stopService((Object[])new Object[]{this.managementObjectNameStrategy, this.managementObjectStrategy, this.managementAgent, this.eventNotifiers});
    }

    protected ManagementObjectNameStrategy createManagementObjectNameStrategy(String domain) {
        return null;
    }

    protected ManagementObjectStrategy createManagementObjectStrategy() {
        return null;
    }

    protected ManagementObjectNameStrategy createManagementObjectNameStrategy() {
        String domain = this.managementAgent != null ? this.managementAgent.getMBeanObjectDomainName() : null;
        return this.createManagementObjectNameStrategy(domain);
    }
}

