/* Generated by camel build tools - do NOT edit this file! */
/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.component.dsl;

import javax.annotation.processing.Generated;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.pqc.PQCComponent;

/**
 * Post Quantum Cryptography Signature and Verification component.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.ComponentDslMojo")
public interface PqcComponentBuilderFactory {

    /**
     * PQC Algorithms (camel-pqc)
     * Post Quantum Cryptography Signature and Verification component.
     * 
     * Category: security
     * Since: 4.12
     * Maven coordinates: org.apache.camel:camel-pqc
     * 
     * @return the dsl builder
     */
    static PqcComponentBuilder pqc() {
        return new PqcComponentBuilderImpl();
    }

    /**
     * Builder for the PQC Algorithms component.
     */
    interface PqcComponentBuilder extends ComponentBuilder<PQCComponent> {
    
        /**
         * Component configuration.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.pqc.PQCConfiguration&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param configuration the value to set
         * @return the dsl builder
         */
        default PqcComponentBuilder configuration(org.apache.camel.component.pqc.PQCConfiguration configuration) {
            doSetProperty("configuration", configuration);
            return this;
        }
    
        
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default PqcComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    
        /**
         * The operation to perform.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.pqc.PQCOperations&lt;/code&gt;
         * type.
         * 
         * Group: producer
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default PqcComponentBuilder operation(org.apache.camel.component.pqc.PQCOperations operation) {
            doSetProperty("operation", operation);
            return this;
        }
    
        
        /**
         * Whether autowiring is enabled. This is used for automatic autowiring
         * options (the option must be marked as autowired) by looking up in the
         * registry to find if there is a single instance of matching type,
         * which then gets configured on the component. This can be used for
         * automatic configuring JDBC data sources, JMS connection factories,
         * AWS Clients, etc.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param autowiredEnabled the value to set
         * @return the dsl builder
         */
        default PqcComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }
    
        /**
         * In case there is no keyGenerator, we specify an algorithm to build
         * the KeyGenerator.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param keyEncapsulationAlgorithm the value to set
         * @return the dsl builder
         */
        default PqcComponentBuilder keyEncapsulationAlgorithm(java.lang.String keyEncapsulationAlgorithm) {
            doSetProperty("keyEncapsulationAlgorithm", keyEncapsulationAlgorithm);
            return this;
        }
    
        /**
         * The Key Generator to be used in encapsulation and extraction.
         * 
         * The option is a: &lt;code&gt;javax.crypto.KeyGenerator&lt;/code&gt;
         * type.
         * 
         * Group: advanced
         * 
         * @param keyGenerator the value to set
         * @return the dsl builder
         */
        default PqcComponentBuilder keyGenerator(javax.crypto.KeyGenerator keyGenerator) {
            doSetProperty("keyGenerator", keyGenerator);
            return this;
        }
    
        /**
         * The KeyPair to be used.
         * 
         * The option is a: &lt;code&gt;java.security.KeyPair&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param keyPair the value to set
         * @return the dsl builder
         */
        default PqcComponentBuilder keyPair(java.security.KeyPair keyPair) {
            doSetProperty("keyPair", keyPair);
            return this;
        }
    
        /**
         * A KeyPair alias to use in combination with KeyStore parameter.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param keyPairAlias the value to set
         * @return the dsl builder
         */
        default PqcComponentBuilder keyPairAlias(java.lang.String keyPairAlias) {
            doSetProperty("keyPairAlias", keyPairAlias);
            return this;
        }
    
        /**
         * A KeyStore where we could get Cryptographic material.
         * 
         * The option is a: &lt;code&gt;java.security.KeyStore&lt;/code&gt;
         * type.
         * 
         * Group: advanced
         * 
         * @param keyStore the value to set
         * @return the dsl builder
         */
        default PqcComponentBuilder keyStore(java.security.KeyStore keyStore) {
            doSetProperty("keyStore", keyStore);
            return this;
        }
    
        /**
         * The KeyStore password to use in combination with KeyStore Parameter.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param keyStorePassword the value to set
         * @return the dsl builder
         */
        default PqcComponentBuilder keyStorePassword(java.lang.String keyStorePassword) {
            doSetProperty("keyStorePassword", keyStorePassword);
            return this;
        }
    
        /**
         * In case there is no signer, we specify an algorithm to build the
         * KeyPair or the Signer.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param signatureAlgorithm the value to set
         * @return the dsl builder
         */
        default PqcComponentBuilder signatureAlgorithm(java.lang.String signatureAlgorithm) {
            doSetProperty("signatureAlgorithm", signatureAlgorithm);
            return this;
        }
    
        /**
         * The Signer to be used.
         * 
         * The option is a: &lt;code&gt;java.security.Signature&lt;/code&gt;
         * type.
         * 
         * Group: advanced
         * 
         * @param signer the value to set
         * @return the dsl builder
         */
        default PqcComponentBuilder signer(java.security.Signature signer) {
            doSetProperty("signer", signer);
            return this;
        }
    
        
        /**
         * In the context of extractSecretKeyFromEncapsulation operation, this
         * option define if we want to have the key set as header.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param storeExtractedSecretKeyAsHeader the value to set
         * @return the dsl builder
         */
        default PqcComponentBuilder storeExtractedSecretKeyAsHeader(boolean storeExtractedSecretKeyAsHeader) {
            doSetProperty("storeExtractedSecretKeyAsHeader", storeExtractedSecretKeyAsHeader);
            return this;
        }
    
        /**
         * In case we are using KEM operations, we need a Symmetric algorithm to
         * be defined for the flow to work.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param symmetricKeyAlgorithm the value to set
         * @return the dsl builder
         */
        default PqcComponentBuilder symmetricKeyAlgorithm(java.lang.String symmetricKeyAlgorithm) {
            doSetProperty("symmetricKeyAlgorithm", symmetricKeyAlgorithm);
            return this;
        }
    
        
        /**
         * The required length of the symmetric key used.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 128
         * Group: advanced
         * 
         * @param symmetricKeyLength the value to set
         * @return the dsl builder
         */
        default PqcComponentBuilder symmetricKeyLength(int symmetricKeyLength) {
            doSetProperty("symmetricKeyLength", symmetricKeyLength);
            return this;
        }
    
        
        /**
         * Used for enabling or disabling all consumer based health checks from
         * this component.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: health
         * 
         * @param healthCheckConsumerEnabled the value to set
         * @return the dsl builder
         */
        default PqcComponentBuilder healthCheckConsumerEnabled(boolean healthCheckConsumerEnabled) {
            doSetProperty("healthCheckConsumerEnabled", healthCheckConsumerEnabled);
            return this;
        }
    
        
        /**
         * Used for enabling or disabling all producer based health checks from
         * this component. Notice: Camel has by default disabled all producer
         * based health-checks. You can turn on producer checks globally by
         * setting camel.health.producersEnabled=true.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: health
         * 
         * @param healthCheckProducerEnabled the value to set
         * @return the dsl builder
         */
        default PqcComponentBuilder healthCheckProducerEnabled(boolean healthCheckProducerEnabled) {
            doSetProperty("healthCheckProducerEnabled", healthCheckProducerEnabled);
            return this;
        }
    }

    class PqcComponentBuilderImpl
            extends AbstractComponentBuilder<PQCComponent>
            implements PqcComponentBuilder {
        @Override
        protected PQCComponent buildConcreteComponent() {
            return new PQCComponent();
        }
        private org.apache.camel.component.pqc.PQCConfiguration getOrCreateConfiguration(PQCComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new org.apache.camel.component.pqc.PQCConfiguration());
            }
            return component.getConfiguration();
        }
        @Override
        protected boolean setPropertyOnComponent(
                Component component,
                String name,
                Object value) {
            switch (name) {
            case "configuration": ((PQCComponent) component).setConfiguration((org.apache.camel.component.pqc.PQCConfiguration) value); return true;
            case "lazyStartProducer": ((PQCComponent) component).setLazyStartProducer((boolean) value); return true;
            case "operation": getOrCreateConfiguration((PQCComponent) component).setOperation((org.apache.camel.component.pqc.PQCOperations) value); return true;
            case "autowiredEnabled": ((PQCComponent) component).setAutowiredEnabled((boolean) value); return true;
            case "keyEncapsulationAlgorithm": getOrCreateConfiguration((PQCComponent) component).setKeyEncapsulationAlgorithm((java.lang.String) value); return true;
            case "keyGenerator": getOrCreateConfiguration((PQCComponent) component).setKeyGenerator((javax.crypto.KeyGenerator) value); return true;
            case "keyPair": getOrCreateConfiguration((PQCComponent) component).setKeyPair((java.security.KeyPair) value); return true;
            case "keyPairAlias": getOrCreateConfiguration((PQCComponent) component).setKeyPairAlias((java.lang.String) value); return true;
            case "keyStore": getOrCreateConfiguration((PQCComponent) component).setKeyStore((java.security.KeyStore) value); return true;
            case "keyStorePassword": getOrCreateConfiguration((PQCComponent) component).setKeyStorePassword((java.lang.String) value); return true;
            case "signatureAlgorithm": getOrCreateConfiguration((PQCComponent) component).setSignatureAlgorithm((java.lang.String) value); return true;
            case "signer": getOrCreateConfiguration((PQCComponent) component).setSigner((java.security.Signature) value); return true;
            case "storeExtractedSecretKeyAsHeader": getOrCreateConfiguration((PQCComponent) component).setStoreExtractedSecretKeyAsHeader((boolean) value); return true;
            case "symmetricKeyAlgorithm": getOrCreateConfiguration((PQCComponent) component).setSymmetricKeyAlgorithm((java.lang.String) value); return true;
            case "symmetricKeyLength": getOrCreateConfiguration((PQCComponent) component).setSymmetricKeyLength((int) value); return true;
            case "healthCheckConsumerEnabled": ((PQCComponent) component).setHealthCheckConsumerEnabled((boolean) value); return true;
            case "healthCheckProducerEnabled": ((PQCComponent) component).setHealthCheckProducerEnabled((boolean) value); return true;
            default: return false;
            }
        }
    }
}