/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import net.openhft.chronicle.bytes.BytesInternal;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.RandomCommon;
import net.openhft.chronicle.bytes.RandomDataInput;
import net.openhft.chronicle.bytes.StreamingDataOutput;
import net.openhft.chronicle.core.Maths;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface RandomDataOutput<R extends RandomDataOutput<R>>
extends RandomCommon {
    @NotNull
    default public R writeByte(long offset, int i) throws BufferOverflowException, IllegalArgumentException {
        return this.writeByte(offset, Maths.toInt8((long)i));
    }

    @NotNull
    default public R writeUnsignedByte(long offset, int i) throws BufferOverflowException, IllegalArgumentException {
        return this.writeByte(offset, (byte)Maths.toUInt8((long)i));
    }

    @NotNull
    default public R writeBoolean(long offset, boolean flag) throws BufferOverflowException {
        try {
            return this.writeByte(offset, flag ? 89 : 78);
        }
        catch (IllegalArgumentException e) {
            throw new AssertionError((Object)e);
        }
    }

    @NotNull
    default public R writeUnsignedShort(long offset, int i) throws BufferOverflowException, IllegalArgumentException {
        return this.writeShort(offset, (short)Maths.toUInt16((long)i));
    }

    @NotNull
    default public R writeUnsignedInt(long offset, long i) throws BufferOverflowException, IllegalArgumentException {
        return this.writeInt(offset, (int)Maths.toUInt32((long)i));
    }

    @NotNull
    public R writeByte(long var1, byte var3) throws BufferOverflowException;

    @NotNull
    public R writeShort(long var1, short var3) throws BufferOverflowException;

    @NotNull
    default public R writeInt24(long offset, int i) throws BufferOverflowException {
        this.writeShort(offset, (short)i);
        return this.writeByte(offset + 2L, (byte)(i >> 16));
    }

    @NotNull
    public R writeInt(long var1, int var3) throws BufferOverflowException;

    @NotNull
    public R writeOrderedInt(long var1, int var3) throws BufferOverflowException;

    @NotNull
    default public R writeOrderedFloat(long offset, float f) throws BufferOverflowException {
        return this.writeOrderedInt(offset, Float.floatToRawIntBits(f));
    }

    @NotNull
    public R writeLong(long var1, long var3) throws BufferOverflowException, IllegalStateException;

    @NotNull
    public R writeOrderedLong(long var1, long var3) throws BufferOverflowException;

    @NotNull
    default public R writeOrderedDouble(long offset, double d) throws BufferOverflowException {
        return this.writeOrderedLong(offset, Double.doubleToRawLongBits(d));
    }

    @NotNull
    public R writeFloat(long var1, float var3) throws BufferOverflowException;

    @NotNull
    public R writeDouble(long var1, double var3) throws BufferOverflowException;

    @NotNull
    public R writeVolatileByte(long var1, byte var3) throws BufferOverflowException;

    @NotNull
    public R writeVolatileShort(long var1, short var3) throws BufferOverflowException;

    @NotNull
    public R writeVolatileInt(long var1, int var3) throws BufferOverflowException;

    @NotNull
    public R writeVolatileLong(long var1, long var3) throws BufferOverflowException;

    @NotNull
    default public R writeVolatileFloat(long offset, float f) throws BufferOverflowException {
        return this.writeVolatileInt(offset, Float.floatToRawIntBits(f));
    }

    @NotNull
    default public R writeVolatileDouble(long offset, double d) throws BufferOverflowException {
        return this.writeVolatileLong(offset, Double.doubleToRawLongBits(d));
    }

    @NotNull
    default public R write(long offsetInRDO, @NotNull byte[] bytes) throws BufferOverflowException {
        return this.write(offsetInRDO, bytes, 0, bytes.length);
    }

    @NotNull
    public R write(long var1, byte[] var3, int var4, int var5) throws BufferOverflowException;

    public void write(long var1, ByteBuffer var3, int var4, int var5) throws BufferOverflowException;

    @NotNull
    default public R write(long offsetInRDO, @NotNull BytesStore bytes) throws BufferOverflowException {
        try {
            return this.write(offsetInRDO, bytes, bytes.readPosition(), bytes.readRemaining());
        }
        catch (BufferUnderflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    @NotNull
    public R write(long var1, RandomDataInput var3, long var4, long var6) throws BufferOverflowException, BufferUnderflowException;

    @NotNull
    public R zeroOut(long var1, long var3);

    @NotNull
    default public R append(long offset, long value, int digits) throws BufferOverflowException {
        BytesInternal.append(this, offset, value, digits);
        return (R)this;
    }

    @NotNull
    default public R append(long offset, double value, int decimalPlaces, int digits) throws BufferOverflowException {
        double d2;
        if (decimalPlaces < 20 && (d2 = value * (double)Maths.tens((int)decimalPlaces)) <= 9.223372036854776E18 && d2 >= -9.223372036854776E18) {
            BytesInternal.appendDecimal(this, Math.round(d2), offset, decimalPlaces, digits);
            return (R)this;
        }
        BytesInternal.append((StreamingDataOutput)((Object)this), value);
        return (R)this;
    }

    public void nativeWrite(long var1, long var3, long var5) throws BufferOverflowException;

    default public long writeUtf8(long offset, @Nullable CharSequence cs) throws BufferOverflowException {
        return BytesInternal.writeUtf8(this, offset, cs);
    }

    default public long writeUtf8Limited(long offset, @Nullable CharSequence cs, int maxUtf8Len) throws BufferOverflowException {
        return BytesInternal.writeUtf8(this, offset, cs, maxUtf8Len);
    }
}

