/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.analytics;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

public final class DataGenerationUtils {
    private DataGenerationUtils() {
        throw new IllegalStateException(String.valueOf(this.getClass()) + " is static utility class and shall not be instantiated");
    }

    public static Dataset<Row> generateCourseData(SparkSession spark, int rowCount) {
        return DataGenerationUtils.generateCourseData(spark, rowCount, false, null, null);
    }

    public static Dataset<Row> generateCourseData(SparkSession spark, int rowCount, boolean udfData) {
        return DataGenerationUtils.generateCourseData(spark, rowCount, udfData, null, null);
    }

    public static Dataset<Row> generateCourseData(SparkSession spark, int rowCount, boolean udfData, Integer ttl, Long timestamp) {
        SQLContext sql = spark.sqlContext();
        StructType schema = new StructType().add("id", DataTypes.IntegerType, false).add("course", DataTypes.StringType, false).add("marks", DataTypes.IntegerType, false);
        if (udfData) {
            StructType udfType = new StructType().add("TimE", DataTypes.IntegerType, false).add("limit", DataTypes.IntegerType, false);
            schema = schema.add("User_Defined_Type", (DataType)udfType);
        }
        if (ttl != null) {
            schema = schema.add("ttl", DataTypes.IntegerType, false);
        }
        if (timestamp != null) {
            schema = schema.add("timestamp", DataTypes.LongType, false);
        }
        List rows = IntStream.range(0, rowCount).mapToObj(recordNum -> {
            String course = "course" + recordNum;
            ArrayList<Serializable> values = new ArrayList<Serializable>(Arrays.asList(recordNum, course, recordNum));
            if (udfData) {
                values.add((Serializable)RowFactory.create((Object[])new Object[]{recordNum, recordNum}));
            }
            if (ttl != null) {
                values.add(ttl);
            }
            if (timestamp != null) {
                values.add(timestamp);
            }
            return RowFactory.create((Object[])values.toArray());
        }).collect(Collectors.toList());
        return sql.createDataFrame(rows, schema);
    }

    public static Dataset<Row> generateCourseData(SparkSession spark, Integer ttl, Long timestamp, int rowCount) {
        SQLContext sql = spark.sqlContext();
        StructType schema = new StructType().add("id", DataTypes.IntegerType, false).add("course", DataTypes.StringType, false).add("marks", DataTypes.IntegerType, false);
        if (ttl != null) {
            schema = schema.add("ttl", DataTypes.IntegerType, false);
        }
        if (timestamp != null) {
            schema = schema.add("timestamp", DataTypes.LongType, false);
        }
        List rows = IntStream.range(0, rowCount).mapToObj(recordNum -> {
            String courseNameString = "course" + recordNum;
            int courseNameStringLen = courseNameString.length();
            int courseNameMultiplier = 1000 / courseNameStringLen;
            String courseName = DataGenerationUtils.dupString(courseNameString, courseNameMultiplier);
            List<Object> baseValues = Arrays.asList(recordNum, courseName, recordNum);
            ArrayList<Object> values = new ArrayList<Object>(baseValues);
            if (ttl != null) {
                values.add(ttl);
            }
            if (timestamp != null) {
                values.add(timestamp);
            }
            return RowFactory.create((Object[])values.toArray());
        }).collect(Collectors.toList());
        return sql.createDataFrame(rows, schema);
    }

    public static Dataset<Row> generateUdtData(SparkSession spark, int rowCount, Predicate<Integer> nullUdtFieldValuePredicate) {
        SQLContext sql = spark.sqlContext();
        StructType udtType = DataTypes.createStructType((StructField[])new StructField[]{new StructField("f1", DataTypes.StringType, true, Metadata.empty()), new StructField("f2", DataTypes.IntegerType, true, Metadata.empty())});
        StructType schema = new StructType().add("id", DataTypes.IntegerType, false).add("udtfield", (DataType)udtType, true);
        List rows = IntStream.range(0, rowCount).mapToObj(id -> {
            String course = "course" + id;
            Row udt = RowFactory.create((Object[])new Object[]{course, nullUdtFieldValuePredicate.test(id) ? null : Integer.valueOf(id)});
            Object[] values = new Object[]{id, udt};
            return RowFactory.create((Object[])values);
        }).collect(Collectors.toList());
        return sql.createDataFrame(rows, schema);
    }

    public static Dataset<Row> generateNestedUdtData(SparkSession spark, int rowCount, Predicate<Integer> nullUdtFieldValuePredicate) {
        SQLContext sql = spark.sqlContext();
        StructType udtType = DataTypes.createStructType((StructField[])new StructField[]{new StructField("f1", DataTypes.StringType, true, Metadata.empty()), new StructField("f2", DataTypes.IntegerType, true, Metadata.empty())});
        StructType nestedType = DataTypes.createStructType((StructField[])new StructField[]{new StructField("n1", DataTypes.IntegerType, true, Metadata.empty()), new StructField("n2", (DataType)udtType, true, Metadata.empty())});
        StructType schema = new StructType().add("id", DataTypes.IntegerType, false).add("nested", (DataType)nestedType, true);
        List rows = IntStream.range(0, rowCount).mapToObj(id -> {
            String course = "course" + id;
            Row outerUdt = RowFactory.create((Object[])new Object[]{id, nullUdtFieldValuePredicate.test(id) ? null : RowFactory.create((Object[])new Object[]{course, id})});
            Object[] values = new Object[]{id, outerUdt};
            return RowFactory.create((Object[])values);
        }).collect(Collectors.toList());
        return sql.createDataFrame(rows, schema);
    }

    private static String dupString(String string, Integer times) {
        byte[] stringBytes = string.getBytes();
        ByteBuffer buffer = ByteBuffer.allocate(stringBytes.length * times);
        for (int time = 0; time < times; ++time) {
            buffer.put(stringBytes);
        }
        return new String(buffer.array(), StandardCharsets.UTF_8);
    }
}

