/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cdc;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import org.apache.cassandra.bridge.CassandraVersion;
import org.apache.cassandra.bridge.CdcBridgeFactory;
import org.apache.cassandra.cdc.api.KeyspaceTypeKey;
import org.apache.cassandra.spark.data.CassandraTypes;
import org.apache.cassandra.spark.data.CqlField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(TypeCache.class);
    protected volatile Cache<KeyspaceTypeKey, CqlField.CqlType> cqlTypeCache = null;
    private static final int CACHE_CAPACITY = 1000;
    private static final ConcurrentHashMap<CassandraVersion, TypeCache> VERSION_TYPE_CACHE = new ConcurrentHashMap(2);
    private final Supplier<CassandraTypes> cassandraTypesSupplier;

    protected TypeCache(Supplier<CassandraTypes> cassandraTypesSupplier) {
        this.cassandraTypesSupplier = cassandraTypesSupplier;
    }

    public CqlField.CqlType getType(String keyspace, String typeString) {
        CqlField.CqlType result;
        this.maybeInit();
        KeyspaceTypeKey key = KeyspaceTypeKey.of((String)keyspace, (String)typeString);
        try {
            result = (CqlField.CqlType)this.cqlTypeCache.get((Object)key, () -> this.getTypes().parseType(keyspace, typeString));
        }
        catch (CacheLoader.InvalidCacheLoadException | ExecutionException e) {
            LOGGER.warn("Unable to get the CQL type from cache.", e);
            result = this.getTypes().parseType(typeString);
            if (result == null) {
                throw new RuntimeException("Unable to parse type: " + typeString);
            }
            this.cqlTypeCache.put((Object)key, (Object)result);
        }
        return result;
    }

    public CassandraTypes getTypes() {
        return this.cassandraTypesSupplier.get();
    }

    public static TypeCache get(CassandraVersion version) {
        return VERSION_TYPE_CACHE.compute(version, (key, previous) -> new TypeCache(() -> CdcBridgeFactory.get(key).cassandraTypes()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeInit() {
        if (this.cqlTypeCache != null) {
            return;
        }
        TypeCache typeCache = this;
        synchronized (typeCache) {
            if (this.cqlTypeCache != null) {
                return;
            }
            this.cqlTypeCache = CacheBuilder.newBuilder().initialCapacity(500).maximumSize(1000L).removalListener(notification -> LOGGER.info("Type is evicted from cache. type='{}'", notification.getKey())).build();
        }
    }
}

