/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import o.a.c.sidecar.client.shaded.common.data.RestoreJobSecrets;
import o.a.c.sidecar.client.shaded.common.data.RestoreJobStatus;
import o.a.c.sidecar.client.shaded.common.request.data.CreateRestoreJobRequestPayload;
import o.a.c.sidecar.client.shaded.common.request.data.UpdateRestoreJobRequestPayload;
import org.apache.cassandra.spark.bulkwriter.AbstractBulkWriterContext;
import org.apache.cassandra.spark.bulkwriter.BroadcastableClusterInfo;
import org.apache.cassandra.spark.bulkwriter.BroadcastableClusterInfoGroup;
import org.apache.cassandra.spark.bulkwriter.BroadcastableJobInfo;
import org.apache.cassandra.spark.bulkwriter.BroadcastableSchemaInfo;
import org.apache.cassandra.spark.bulkwriter.BroadcastableTableSchema;
import org.apache.cassandra.spark.bulkwriter.BulkWriteValidator;
import org.apache.cassandra.spark.bulkwriter.BulkWriterConfig;
import org.apache.cassandra.spark.bulkwriter.BulkWriterContext;
import org.apache.cassandra.spark.bulkwriter.CancelJobEvent;
import org.apache.cassandra.spark.bulkwriter.ClusterInfo;
import org.apache.cassandra.spark.bulkwriter.DecoratedKey;
import org.apache.cassandra.spark.bulkwriter.IBroadcastableClusterInfo;
import org.apache.cassandra.spark.bulkwriter.JobInfo;
import org.apache.cassandra.spark.bulkwriter.RecordWriter;
import org.apache.cassandra.spark.bulkwriter.RingInstance;
import org.apache.cassandra.spark.bulkwriter.SimpleTaskScheduler;
import org.apache.cassandra.spark.bulkwriter.StreamError;
import org.apache.cassandra.spark.bulkwriter.StreamResult;
import org.apache.cassandra.spark.bulkwriter.Tokenizer;
import org.apache.cassandra.spark.bulkwriter.TransportContext;
import org.apache.cassandra.spark.bulkwriter.WriteResult;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.CloudStorageDataTransferApi;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.CloudStorageStreamResult;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.ImportCompletionCoordinator;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.ImportCoordinator;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.coordinated.CassandraClusterInfoGroup;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.coordinated.CoordinatedCloudStorageDataTransferApi;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.coordinated.CoordinatedImportCoordinator;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.coordinated.CoordinatedWriteConf;
import org.apache.cassandra.spark.bulkwriter.token.ConsistencyLevel;
import org.apache.cassandra.spark.bulkwriter.token.MultiClusterReplicaAwareFailureHandler;
import org.apache.cassandra.spark.exception.SidecarApiCallException;
import org.apache.cassandra.spark.exception.UnsupportedAnalyticsOperationException;
import org.apache.cassandra.spark.transports.storage.extensions.StorageTransportConfiguration;
import org.apache.cassandra.spark.transports.storage.extensions.StorageTransportExtension;
import org.apache.cassandra.spark.transports.storage.extensions.StorageTransportHandler;
import org.apache.spark.Partitioner;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.sources.InsertableRelation;
import org.apache.spark.sql.types.StructType;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;
import scala.collection.JavaConverters;
import scala.collection.Seq;
import scala.util.control.NonFatal$;

public class CassandraBulkSourceRelation
extends BaseRelation
implements InsertableRelation {
    private static final Logger LOGGER = LoggerFactory.getLogger(CassandraBulkSourceRelation.class);
    private final BulkWriterContext writerContext;
    private final SQLContext sqlContext;
    private final JavaSparkContext sparkContext;
    private final Broadcast<BulkWriterConfig> broadcastConfig;
    private final BulkWriteValidator writeValidator;
    private final SimpleTaskScheduler simpleTaskScheduler;
    private ImportCoordinator importCoordinator = null;
    private long startTimeNanos;

    public CassandraBulkSourceRelation(BulkWriterContext writerContext, SQLContext sqlContext) {
        this.writerContext = writerContext;
        this.sqlContext = sqlContext;
        this.sparkContext = JavaSparkContext.fromSparkContext((SparkContext)sqlContext.sparkContext());
        BulkWriterConfig config = CassandraBulkSourceRelation.extractConfig(writerContext, this.sparkContext.defaultParallelism());
        this.broadcastConfig = this.sparkContext.broadcast((Object)config);
        MultiClusterReplicaAwareFailureHandler<RingInstance> failureHandler = new MultiClusterReplicaAwareFailureHandler<RingInstance>(writerContext.cluster().getPartitioner());
        this.writeValidator = new BulkWriteValidator(writerContext, failureHandler);
        this.simpleTaskScheduler = new SimpleTaskScheduler();
    }

    private static BulkWriterConfig extractConfig(BulkWriterContext context, int sparkDefaultParallelism) {
        if (context instanceof AbstractBulkWriterContext) {
            IBroadcastableClusterInfo broadcastableClusterInfo;
            AbstractBulkWriterContext abstractContext = (AbstractBulkWriterContext)context;
            ClusterInfo originalClusterInfo = abstractContext.cluster();
            if (originalClusterInfo instanceof CassandraClusterInfoGroup) {
                CassandraClusterInfoGroup multiCluster = (CassandraClusterInfoGroup)originalClusterInfo;
                broadcastableClusterInfo = BroadcastableClusterInfoGroup.from(multiCluster, abstractContext.bulkSparkConf());
            } else {
                broadcastableClusterInfo = BroadcastableClusterInfo.from(originalClusterInfo, abstractContext.bulkSparkConf());
            }
            BroadcastableJobInfo broadcastableJobInfo = BroadcastableJobInfo.from(abstractContext.job(), abstractContext.bulkSparkConf());
            BroadcastableSchemaInfo broadcastableSchemaInfo = BroadcastableSchemaInfo.from(abstractContext.schema());
            return new BulkWriterConfig(abstractContext.bulkSparkConf(), sparkDefaultParallelism, broadcastableJobInfo, broadcastableClusterInfo, broadcastableSchemaInfo, abstractContext.lowestCassandraVersion());
        }
        throw new IllegalArgumentException("Cannot extract config from context type: " + context.getClass().getName());
    }

    @NotNull
    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    @NotNull
    public StructType schema() {
        LOGGER.warn("This instance is used as writer, a schema is not supported");
        return new StructType();
    }

    public long sizeInBytes() {
        LOGGER.warn("This instance is used as writer, sizeInBytes is not supported");
        return 0L;
    }

    public void insert(@NotNull Dataset<Row> data, boolean overwrite) {
        this.validateJob(overwrite);
        this.startTimeNanos = System.nanoTime();
        this.maybeScheduleTimeout();
        this.maybeEnableTransportExtension();
        BroadcastableTableSchema broadcastableTableSchema = ((BulkWriterConfig)this.broadcastConfig.value()).getBroadcastableSchemaInfo().getBroadcastableTableSchema();
        boolean isMurmur3Partitioner = this.writerContext.cluster().getPartitioner() == org.apache.cassandra.spark.data.partitioner.Partitioner.Murmur3Partitioner;
        Tokenizer tokenizer = new Tokenizer(broadcastableTableSchema, isMurmur3Partitioner);
        JavaPairRDD sortedRDD = data.toJavaRDD().map(Row::toSeq).map((Function & Serializable)seq -> ((List)JavaConverters.seqAsJavaListConverter((Seq)seq).asJava()).toArray()).map(broadcastableTableSchema::normalize).keyBy(tokenizer::getDecoratedKey).repartitionAndSortWithinPartitions((Partitioner)this.writerContext.job().getTokenPartitioner());
        this.persist((JavaPairRDD<DecoratedKey, Object[]>)sortedRDD, data.columns());
    }

    private void validateJob(boolean overwrite) {
        if (overwrite) {
            throw new UnsupportedAnalyticsOperationException("Overwriting existing data needs TRUNCATE on Cassandra, which is not supported");
        }
        this.writerContext.cluster().checkBulkWriterIsEnabledOrThrow();
    }

    public void cancelJob(@NotNull CancelJobEvent cancelJobEvent) {
        if (cancelJobEvent.exception != null) {
            LOGGER.error("An unrecoverable error occurred during {} stage of import while validating the current cluster state; cancelling job", (Object)this.writeValidator.getPhase(), (Object)cancelJobEvent.exception);
        } else {
            LOGGER.error("Job was canceled due to '{}' during {} stage of import; please rerun import once topology changes are complete", (Object)cancelJobEvent.reason, (Object)this.writeValidator.getPhase());
        }
        try {
            this.onCloudStorageTransport(ctx -> this.abortRestoreJob((TransportContext.CloudStorageTransportContext)ctx, cancelJobEvent.exception));
        }
        finally {
            this.sparkContext.cancelJobGroup(this.writerContext.job().getId());
        }
    }

    private void persist(@NotNull JavaPairRDD<DecoratedKey, Object[]> sortedRDD, String[] columnNames) {
        this.onDirectTransport(ctx -> this.writeValidator.setPhase("UploadAndCommit"));
        this.onCloudStorageTransport(ctx -> {
            this.writeValidator.setPhase("UploadToCloudStorage");
            ctx.transportExtensionImplementation().onTransportStart(this.elapsedTimeMillis());
        });
        try {
            List writeResults = sortedRDD.mapPartitions(CassandraBulkSourceRelation.writeRowsInPartition(this.broadcastConfig, columnNames)).collect();
            this.unpersist();
            List streamResults = writeResults.stream().map(WriteResult::streamResults).flatMap(Collection::stream).collect(Collectors.toList());
            long rowCount = streamResults.stream().mapToLong(res -> res.rowCount).sum();
            long totalBytesWritten = streamResults.stream().mapToLong(res -> res.bytesWritten).sum();
            boolean hasClusterTopologyChanged = writeResults.stream().anyMatch(WriteResult::isClusterResizeDetected);
            this.onCloudStorageTransport(context -> this.waitForImportCompletion((TransportContext.CloudStorageTransportContext)context, rowCount, totalBytesWritten, hasClusterTopologyChanged, streamResults));
            LOGGER.info("Bulk writer job complete. rowCount={} totalBytes={} hasClusterTopologyChanged={}", new Object[]{rowCount, totalBytesWritten, hasClusterTopologyChanged});
            this.publishSuccessfulJobStats(rowCount, totalBytesWritten, hasClusterTopologyChanged);
        }
        catch (Throwable throwable) {
            this.publishFailureJobStats(throwable.getMessage());
            LOGGER.error("Bulk Write Failed.", throwable);
            RuntimeException failure = new RuntimeException("Bulk Write to Cassandra has failed", throwable);
            try {
                this.onCloudStorageTransport(ctx -> this.abortRestoreJob((TransportContext.CloudStorageTransportContext)ctx, throwable));
            }
            catch (Exception rte) {
                failure.addSuppressed(rte);
            }
            throw failure;
        }
        finally {
            try {
                this.simpleTaskScheduler.close();
                this.writerContext.shutdown();
                this.sqlContext().sparkContext().clearJobGroup();
            }
            catch (Exception ignored) {
                LOGGER.warn("Ignored exception during spark job shutdown.", (Throwable)ignored);
            }
            this.unpersist();
        }
    }

    private void waitForImportCompletion(TransportContext.CloudStorageTransportContext context, long rowCount, long totalBytesWritten, boolean hasClusterTopologyChanged, List<StreamResult> streamResults) {
        LOGGER.info("Waiting for Cassandra to complete import slices. rowCount={} totalBytes={} hasClusterTopologyChanged={}", new Object[]{rowCount, totalBytesWritten, hasClusterTopologyChanged});
        List<StreamError> allErrors = streamResults.stream().flatMap(r -> r.failures.stream()).collect(Collectors.toList());
        if (this.writerContext.job().isCoordinatedWriteEnabled()) {
            if (!allErrors.isEmpty()) {
                throw new IllegalStateException("Stream errors are unexpected when coordinated-write is enabled. streamErrors=" + String.valueOf(allErrors));
            }
        } else {
            this.writeValidator.updateFailureHandler(allErrors);
        }
        List<CloudStorageStreamResult> resultsAsCloudStorageStreamResults = streamResults.stream().map(CloudStorageStreamResult.class::cast).collect(Collectors.toList());
        int objectCount = resultsAsCloudStorageStreamResults.stream().mapToInt(res -> res.objectCount).sum();
        long elapsedInMillis = this.elapsedTimeMillis();
        LOGGER.info("Notifying extension all objects and rows have been persisted. objectCount={} rowCount={} timeElapsedInMillis={}", new Object[]{objectCount, rowCount, elapsedInMillis});
        context.transportExtensionImplementation().onAllObjectsPersisted(objectCount, rowCount, this.elapsedTimeMillis());
        if (this.writerContext.job().isCoordinatedWriteEnabled()) {
            this.setSliceCountForRestoreJob(context, objectCount);
        }
        this.awaitImportCompletion(context, resultsAsCloudStorageStreamResults);
        this.markRestoreJobAsSucceeded(context);
    }

    private void awaitImportCompletion(TransportContext.CloudStorageTransportContext context, List<CloudStorageStreamResult> resultsAsCloudStorageStreamResults) {
        if (!this.writerContext.job().isCoordinatedWriteEnabled()) {
            this.importCoordinator = ImportCompletionCoordinator.of(this.startTimeNanos, this.writerContext, context.dataTransferApi(), this.writeValidator, resultsAsCloudStorageStreamResults, context.transportExtensionImplementation(), this::cancelJob);
        }
        Objects.requireNonNull(this.importCoordinator, "importCoordinator is not initialized");
        this.importCoordinator.await();
    }

    private void publishSuccessfulJobStats(final long rowCount, final long totalBytesWritten, final boolean hasClusterTopologyChanged) {
        this.writerContext.jobStats().publish((Map)new HashMap<String, String>(){
            {
                this.put("jobId", CassandraBulkSourceRelation.this.writerContext.job().getId().toString());
                this.put("transportInfo", CassandraBulkSourceRelation.this.writerContext.job().transportInfo().toString());
                this.put("rowsWritten", Long.toString(rowCount));
                this.put("bytesWritten", Long.toString(totalBytesWritten));
                this.put("jobStatus", "Succeeded");
                this.put("clusterResizeDetected", String.valueOf(hasClusterTopologyChanged));
                this.put("jobElapsedTimeMillis", Long.toString(CassandraBulkSourceRelation.this.elapsedTimeMillis()));
            }
        });
    }

    private void publishFailureJobStats(final String reason) {
        this.writerContext.jobStats().publish((Map)new HashMap<String, String>(){
            {
                this.put("jobId", CassandraBulkSourceRelation.this.writerContext.job().getId().toString());
                this.put("transportInfo", CassandraBulkSourceRelation.this.writerContext.job().transportInfo().toString());
                this.put("jobStatus", "Failed");
                this.put("failureReason", reason);
                this.put("jobElapsedTimeMillis", Long.toString(CassandraBulkSourceRelation.this.elapsedTimeMillis()));
            }
        });
    }

    private static FlatMapFunction<Iterator<Tuple2<DecoratedKey, Object[]>>, WriteResult> writeRowsInPartition(Broadcast<BulkWriterConfig> config, String[] columnNames) {
        return (FlatMapFunction & Serializable)iterator -> Collections.singleton(new RecordWriter((BulkWriterConfig)config.getValue(), columnNames).write((Iterator<Tuple2<DecoratedKey, Object[]>>)iterator)).iterator();
    }

    protected void unpersist() {
        try {
            LOGGER.info("Unpersisting broadcast config");
            this.broadcastConfig.unpersist(false);
        }
        catch (Throwable throwable) {
            if (NonFatal$.MODULE$.apply(throwable)) {
                LOGGER.error("Uncaught exception in thread {} attempting to unpersist broadcast variable", (Object)Thread.currentThread().getName(), (Object)throwable);
            }
            throw throwable;
        }
    }

    private void maybeEnableTransportExtension() {
        this.onCloudStorageTransport(ctx -> {
            JobInfo job = this.writerContext.job();
            StorageTransportHandler storageTransportHandler = new StorageTransportHandler((TransportContext.CloudStorageTransportContext)ctx, job, this::cancelJob);
            StorageTransportExtension impl = ctx.transportExtensionImplementation();
            impl.setCredentialChangeListener(storageTransportHandler);
            impl.setObjectFailureListener(storageTransportHandler);
            if (job.isCoordinatedWriteEnabled()) {
                CloudStorageDataTransferApi dataTransferApi = ctx.dataTransferApi();
                Preconditions.checkState((boolean)(dataTransferApi instanceof CoordinatedCloudStorageDataTransferApi), (Object)"CoordinatedCloudStorageDataTransferApi is required for coordinated write");
                CoordinatedCloudStorageDataTransferApi api = (CoordinatedCloudStorageDataTransferApi)dataTransferApi;
                CoordinatedImportCoordinator coordinator = CoordinatedImportCoordinator.of(this.startTimeNanos, job, api, impl);
                this.importCoordinator = coordinator;
                impl.setCoordinationSignalListener(coordinator);
                this.createRestoreJobsOnAllClusters((TransportContext.CloudStorageTransportContext)ctx, job.coordinatedWriteConf(), api);
            } else {
                this.createRestoreJob((TransportContext.CloudStorageTransportContext)ctx);
            }
            this.simpleTaskScheduler.schedulePeriodic("Extend lease", Duration.ofMinutes(1L), () -> this.extendLeaseForJob((TransportContext.CloudStorageTransportContext)ctx));
        });
    }

    private void extendLeaseForJob(TransportContext.CloudStorageTransportContext ctx) {
        UpdateRestoreJobRequestPayload payload = UpdateRestoreJobRequestPayload.builder().withExpireAtInMillis(Long.valueOf(this.updatedLeaseTime())).build();
        try {
            ctx.dataTransferApi().updateRestoreJob(payload);
        }
        catch (SidecarApiCallException e) {
            LOGGER.warn("Failed to update expireAt for job", (Throwable)e);
        }
    }

    private long updatedLeaseTime() {
        return System.currentTimeMillis() + TimeUnit.MINUTES.toMillis(this.writerContext.job().jobKeepAliveMinutes());
    }

    private long elapsedTimeMillis() {
        long now = System.nanoTime();
        return TimeUnit.NANOSECONDS.toMillis(now - this.startTimeNanos);
    }

    void onCloudStorageTransport(Consumer<TransportContext.CloudStorageTransportContext> consumer) {
        TransportContext transportContext = this.writerContext.transportContext();
        if (transportContext instanceof TransportContext.CloudStorageTransportContext) {
            consumer.accept((TransportContext.CloudStorageTransportContext)transportContext);
        }
    }

    void onDirectTransport(Consumer<TransportContext.DirectDataBulkWriterContext> consumer) {
        TransportContext transportContext = this.writerContext.transportContext();
        if (transportContext instanceof TransportContext.DirectDataBulkWriterContext) {
            consumer.accept((TransportContext.DirectDataBulkWriterContext)transportContext);
        }
    }

    private void createRestoreJob(TransportContext.CloudStorageTransportContext context) {
        StorageTransportConfiguration conf = context.transportConfiguration();
        RestoreJobSecrets secrets = conf.getStorageCredentialPair(null).toRestoreJobSecrets();
        JobInfo job = this.writerContext.job();
        CreateRestoreJobRequestPayload payload = this.createJobPayloadBuilder(job, secrets).build();
        context.dataTransferApi().createRestoreJob(payload);
    }

    private void createRestoreJobsOnAllClusters(TransportContext.CloudStorageTransportContext context, CoordinatedWriteConf coordinatedWriteConf, CoordinatedCloudStorageDataTransferApi dataTransferApi) {
        StorageTransportConfiguration conf = context.transportConfiguration();
        JobInfo job = this.writerContext.job();
        ConsistencyLevel cl = job.getConsistencyLevel();
        dataTransferApi.forEach((clusterId, api) -> {
            RestoreJobSecrets secrets = conf.getStorageCredentialPair((String)clusterId).toRestoreJobSecrets();
            CoordinatedWriteConf.ClusterConf cluster = coordinatedWriteConf.cluster((String)clusterId);
            String localDc = cluster.resolveLocalDc(cl);
            CreateRestoreJobRequestPayload payload = this.createJobPayloadBuilder(job, secrets, (String)clusterId).consistencyLevel(this.toSidecarConsistencyLevel(cl), localDc).restoreToLocalDatacenterOnly(cluster.writeToLocalDcOnly()).build();
            api.createRestoreJob(payload);
        });
    }

    private CreateRestoreJobRequestPayload.Builder createJobPayloadBuilder(JobInfo job, RestoreJobSecrets secrets) {
        return this.createJobPayloadBuilder(job, secrets, null);
    }

    private CreateRestoreJobRequestPayload.Builder createJobPayloadBuilder(JobInfo job, RestoreJobSecrets secrets, String clusterId) {
        CreateRestoreJobRequestPayload.Builder builder = CreateRestoreJobRequestPayload.builder((RestoreJobSecrets)secrets, (long)this.updatedLeaseTime());
        builder.jobAgent("cassandra-analytics").jobId(job.getRestoreJobId(clusterId)).updateImportOptions(importOptions -> importOptions.verifySSTables(true).extendedVerify(false));
        return builder;
    }

    private o.a.c.sidecar.client.shaded.common.data.ConsistencyLevel toSidecarConsistencyLevel(ConsistencyLevel cl) {
        return o.a.c.sidecar.client.shaded.common.data.ConsistencyLevel.fromString((String)cl.toString());
    }

    private void setSliceCountForRestoreJob(TransportContext.CloudStorageTransportContext context, long sliceCount) {
        UpdateRestoreJobRequestPayload requestPayload = UpdateRestoreJobRequestPayload.builder().withSliceCount(Long.valueOf(sliceCount)).build();
        try {
            LOGGER.info("Setting slice count for the restore job. sliceCount={}", (Object)sliceCount);
            context.dataTransferApi().updateRestoreJob(requestPayload);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to set slice count for the restore job.", (Throwable)e);
        }
    }

    private void markRestoreJobAsSucceeded(TransportContext.CloudStorageTransportContext context) {
        UpdateRestoreJobRequestPayload requestPayload = UpdateRestoreJobRequestPayload.builder().withStatus(RestoreJobStatus.SUCCEEDED).build();
        try {
            LOGGER.info("Marking the restore job as succeeded.");
            context.transportExtensionImplementation().onJobSucceeded(this.elapsedTimeMillis());
            context.dataTransferApi().updateRestoreJob(requestPayload);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to mark the restore job as succeeded.", (Throwable)e);
        }
    }

    private void abortRestoreJob(TransportContext.CloudStorageTransportContext context, Throwable cause) {
        context.transportExtensionImplementation().onJobFailed(this.elapsedTimeMillis(), cause);
        context.dataTransferApi().abortRestoreJob();
    }

    private void maybeScheduleTimeout() {
        long timeoutSeconds = this.writerContext.job().jobTimeoutSeconds();
        if (timeoutSeconds != -1L) {
            LOGGER.info("Scheduled job timeout. timeoutSeconds={}", (Object)timeoutSeconds);
            this.simpleTaskScheduler.schedule("Job timeout", Duration.ofSeconds(timeoutSeconds), () -> {
                if (this.importCoordinator == null || !this.importCoordinator.succeeded()) {
                    this.cancelJob(new CancelJobEvent("Job times out after " + timeoutSeconds + " seconds"));
                }
            });
        }
    }
}

