/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.gms;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.gms.EndpointState;
import org.apache.cassandra.gms.GossipDigestAck2;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.locator.InetAddressAndPort;

class GossipDigestAck2Serializer
implements IVersionedSerializer<GossipDigestAck2> {
    GossipDigestAck2Serializer() {
    }

    @Override
    public void serialize(GossipDigestAck2 ack2, DataOutputPlus out, int version) throws IOException {
        out.writeInt(ack2.epStateMap.size());
        for (Map.Entry<InetAddressAndPort, EndpointState> entry : ack2.epStateMap.entrySet()) {
            InetAddressAndPort ep = entry.getKey();
            InetAddressAndPort.Serializer.inetAddressAndPortSerializer.serialize(ep, out, version);
            EndpointState.serializer.serialize(entry.getValue(), out, version);
        }
    }

    @Override
    public GossipDigestAck2 deserialize(DataInputPlus in, int version) throws IOException {
        int size = in.readInt();
        HashMap<InetAddressAndPort, EndpointState> epStateMap = new HashMap<InetAddressAndPort, EndpointState>(size);
        for (int i = 0; i < size; ++i) {
            InetAddressAndPort ep = InetAddressAndPort.Serializer.inetAddressAndPortSerializer.deserialize(in, version);
            EndpointState epState = (EndpointState)EndpointState.serializer.deserialize(in, version);
            epStateMap.put(ep, epState);
        }
        return new GossipDigestAck2(epStateMap);
    }

    @Override
    public long serializedSize(GossipDigestAck2 ack2, int version) {
        long size = TypeSizes.sizeof(ack2.epStateMap.size());
        for (Map.Entry<InetAddressAndPort, EndpointState> entry : ack2.epStateMap.entrySet()) {
            size += InetAddressAndPort.Serializer.inetAddressAndPortSerializer.serializedSize(entry.getKey(), version) + EndpointState.serializer.serializedSize(entry.getValue(), version);
        }
        return size;
    }
}

