/*
 * Decompiled with CFR 0.152.
 */
package o.a.c.sidecar.client.shaded.client;

import java.nio.ByteBuffer;

public interface StreamBuffer {
    public void copyBytes(int var1, ByteBuffer var2, int var3);

    public void copyBytes(int var1, byte[] var2, int var3, int var4);

    public byte getByte(int var1);

    public int readableBytes();

    public void release();

    public static ByteArrayWrapper wrap(byte[] bytes) {
        return new ByteArrayWrapper(bytes);
    }

    public static class ByteArrayWrapper
    implements StreamBuffer {
        private final byte[] bytes;

        private ByteArrayWrapper(byte[] bytes) {
            this.bytes = bytes;
        }

        @Override
        public void copyBytes(int sourceOffset, ByteBuffer destination, int length) {
            destination.put(this.bytes, sourceOffset, length);
            destination.flip();
        }

        @Override
        public void copyBytes(int sourceOffset, byte[] destination, int destinationIndex, int length) {
            System.arraycopy(this.bytes, sourceOffset, destination, destinationIndex, length);
        }

        @Override
        public byte getByte(int index) {
            return this.bytes[index];
        }

        @Override
        public int readableBytes() {
            return this.bytes.length;
        }

        @Override
        public void release() {
        }
    }
}

