/*
 * Decompiled with CFR 0.152.
 */
package o.a.c.sidecar.client.shaded.io.vertx.ext.auth.authorization.impl;

import java.util.Objects;
import o.a.c.sidecar.client.shaded.io.vertx.ext.auth.User;
import o.a.c.sidecar.client.shaded.io.vertx.ext.auth.authorization.Authorization;
import o.a.c.sidecar.client.shaded.io.vertx.ext.auth.authorization.AuthorizationContext;
import o.a.c.sidecar.client.shaded.io.vertx.ext.auth.authorization.PermissionBasedAuthorization;
import o.a.c.sidecar.client.shaded.io.vertx.ext.auth.authorization.WildcardPermissionBasedAuthorization;
import o.a.c.sidecar.client.shaded.io.vertx.ext.auth.authorization.impl.VariableAwareExpression;
import o.a.c.sidecar.client.shaded.io.vertx.ext.auth.authorization.impl.WildcardExpression;

public class WildcardPermissionBasedAuthorizationImpl
implements WildcardPermissionBasedAuthorization {
    private final String permission;
    private VariableAwareExpression resource;
    private final WildcardExpression wildcardPermission;

    public WildcardPermissionBasedAuthorizationImpl(String permission) {
        this.permission = Objects.requireNonNull(permission);
        this.wildcardPermission = new WildcardExpression(permission);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof WildcardPermissionBasedAuthorizationImpl)) {
            return false;
        }
        WildcardPermissionBasedAuthorizationImpl other = (WildcardPermissionBasedAuthorizationImpl)obj;
        return Objects.equals(this.permission, other.permission) && Objects.equals(this.resource, other.resource);
    }

    @Override
    public String getPermission() {
        return this.permission;
    }

    public int hashCode() {
        return Objects.hash(this.permission, this.resource);
    }

    @Override
    public boolean match(AuthorizationContext context) {
        Objects.requireNonNull(context);
        User user = context.user();
        if (user != null) {
            WildcardPermissionBasedAuthorization resolvedAuthorization = this.getResolvedAuthorization(context);
            for (String providerId : user.authorizations().getProviderIds()) {
                for (Authorization authorization : user.authorizations().get(providerId)) {
                    if (!authorization.verify(resolvedAuthorization)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean verify(Authorization otherAuthorization) {
        PermissionBasedAuthorization otherPermission;
        if (otherAuthorization instanceof WildcardPermissionBasedAuthorizationImpl) {
            WildcardPermissionBasedAuthorizationImpl otherWildcardPermission = (WildcardPermissionBasedAuthorizationImpl)otherAuthorization;
            if (this.wildcardPermission.implies(otherWildcardPermission.wildcardPermission)) {
                if (this.getResource() == null) {
                    return true;
                }
                return this.getResource().equals(otherWildcardPermission.getResource());
            }
        } else if (otherAuthorization instanceof PermissionBasedAuthorization && this.wildcardPermission.implies((otherPermission = (PermissionBasedAuthorization)otherAuthorization).getPermission())) {
            if (this.getResource() == null) {
                return true;
            }
            return this.getResource().equals(otherPermission.getResource());
        }
        return false;
    }

    private WildcardPermissionBasedAuthorization getResolvedAuthorization(AuthorizationContext context) {
        if (this.resource == null || !this.resource.hasVariable()) {
            return this;
        }
        return WildcardPermissionBasedAuthorization.create(this.permission).setResource(this.resource.resolve(context));
    }

    @Override
    public String getResource() {
        return this.resource != null ? this.resource.getValue() : null;
    }

    @Override
    public WildcardPermissionBasedAuthorization setResource(String resource) {
        this.resource = new VariableAwareExpression(Objects.requireNonNull(resource));
        return this;
    }
}

