/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter.cloudstorage;

import java.io.IOException;
import java.math.BigInteger;
import java.net.URISyntaxException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.cassandra.bridge.CassandraBridge;
import org.apache.cassandra.bridge.SSTableSummary;
import org.apache.cassandra.spark.bulkwriter.DigestAlgorithms;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.SSTableCollector;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.SSTableLister;
import org.apache.cassandra.spark.common.Digest;
import org.apache.cassandra.spark.data.FileSystemSSTable;
import org.apache.cassandra.spark.data.QualifiedTableName;
import org.apache.cassandra.spark.data.SSTable;
import org.apache.cassandra.spark.utils.DigestAlgorithm;
import org.apache.cassandra.spark.utils.TemporaryDirectory;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class SSTableListerTest {
    private Path outputDir;

    SSTableListerTest() {
    }

    @Test
    void testOutput() throws URISyntaxException {
        SSTableLister sstableLister = this.setupSSTableLister();
        sstableLister.includeDirectory(this.outputDir);
        sstableLister.includeFileDigests(SSTableListerTest.calculateFileDigests(this.outputDir));
        ArrayList<SSTableCollector.SSTableFilesAndRange> sstables = new ArrayList<SSTableCollector.SSTableFilesAndRange>();
        Assertions.assertThat((long)sstableLister.totalSize()).isEqualTo(10196L);
        while (!sstableLister.isEmpty()) {
            sstables.add(sstableLister.consumeOne());
        }
        Assertions.assertThat(sstables).hasSize(2);
        Set ssTablePrefixes = sstables.stream().map(sstable -> sstable.summary.sstableId).collect(Collectors.toSet());
        Assertions.assertThat(ssTablePrefixes).contains((Object[])new String[]{"na-1-big-"});
        Assertions.assertThat(ssTablePrefixes).contains((Object[])new String[]{"na-2-big-"});
        Set range1Files = ((SSTableCollector.SSTableFilesAndRange)sstables.get((int)0)).files;
        Set range2Files = ((SSTableCollector.SSTableFilesAndRange)sstables.get((int)1)).files;
        Assertions.assertThat((Collection)range1Files).contains((Object[])new Path[]{this.outputDir.resolve("na-1-big-Data.db")});
        Assertions.assertThat((Collection)range1Files).contains((Object[])new Path[]{this.outputDir.resolve("na-1-big-Index.db")});
        Assertions.assertThat((Collection)range1Files).contains((Object[])new Path[]{this.outputDir.resolve("na-1-big-Summary.db")});
        Assertions.assertThat((Collection)range1Files).contains((Object[])new Path[]{this.outputDir.resolve("na-1-big-Statistics.db")});
        Assertions.assertThat((Collection)range1Files).contains((Object[])new Path[]{this.outputDir.resolve("na-1-big-TOC.txt")});
        Assertions.assertThat((Collection)range2Files).contains((Object[])new Path[]{this.outputDir.resolve("na-2-big-Data.db")});
        Assertions.assertThat((Collection)range2Files).contains((Object[])new Path[]{this.outputDir.resolve("na-2-big-Index.db")});
        Assertions.assertThat((Collection)range2Files).contains((Object[])new Path[]{this.outputDir.resolve("na-2-big-Summary.db")});
        Assertions.assertThat((Collection)range2Files).contains((Object[])new Path[]{this.outputDir.resolve("na-2-big-Statistics.db")});
        Assertions.assertThat((Collection)range2Files).contains((Object[])new Path[]{this.outputDir.resolve("na-2-big-TOC.txt")});
        for (SSTableCollector.SSTableFilesAndRange sstable2 : sstables) {
            for (Path file : sstable2.files) {
                ((MapAssert)Assertions.assertThat((Map)sstableLister.fileDigests(Collections.singleton(file))).as("Digest for file should exist. file: " + String.valueOf(file), new Object[0])).isNotNull();
            }
        }
    }

    @Test
    void testEmptyDir() throws IOException {
        try (TemporaryDirectory tempDir = new TemporaryDirectory();){
            CassandraBridge bridge = (CassandraBridge)Mockito.mock(CassandraBridge.class);
            SSTableLister ssTableLister = new SSTableLister(new QualifiedTableName("ks", "table1"), bridge);
            ssTableLister.includeDirectory(tempDir.path());
            Assertions.assertThat((Object)ssTableLister.peek()).isNull();
            Assertions.assertThat((Object)ssTableLister.consumeOne()).isNull();
            Assertions.assertThat((boolean)ssTableLister.isEmpty()).isTrue();
        }
    }

    @Test
    void testIncludeSSTable() throws Exception {
        SSTableLister sstableLister = this.setupSSTableLister();
        ArrayList sstableComponents = new ArrayList();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.outputDir, "na-1-big-*");){
            stream.forEach(sstableComponents::add);
        }
        sstableLister.includeSSTable(sstableComponents);
        ArrayList<SSTableCollector.SSTableFilesAndRange> sstables = new ArrayList<SSTableCollector.SSTableFilesAndRange>();
        Assertions.assertThat((boolean)sstableLister.isEmpty()).isFalse();
        Assertions.assertThat((long)sstableLister.totalSize()).isEqualTo(5098L);
        while (!sstableLister.isEmpty()) {
            sstables.add(sstableLister.consumeOne());
        }
        Assertions.assertThat((long)sstableLister.totalSize()).isEqualTo(0L);
        Assertions.assertThat(sstables).hasSize(1);
        Set range1Files = ((SSTableCollector.SSTableFilesAndRange)sstables.get((int)0)).files;
        Assertions.assertThat((Collection)range1Files).contains((Object[])new Path[]{this.outputDir.resolve("na-1-big-Data.db")});
        Assertions.assertThat((Collection)range1Files).contains((Object[])new Path[]{this.outputDir.resolve("na-1-big-Index.db")});
        Assertions.assertThat((Collection)range1Files).contains((Object[])new Path[]{this.outputDir.resolve("na-1-big-Summary.db")});
        Assertions.assertThat((Collection)range1Files).contains((Object[])new Path[]{this.outputDir.resolve("na-1-big-Statistics.db")});
        Assertions.assertThat((Collection)range1Files).contains((Object[])new Path[]{this.outputDir.resolve("na-1-big-TOC.txt")});
        sstableLister.includeDirectory(this.outputDir);
        Assertions.assertThat((boolean)sstableLister.isEmpty()).isFalse();
        Assertions.assertThat((long)sstableLister.totalSize()).isEqualTo(5098L);
        int producedSSTables = 0;
        while (!sstableLister.isEmpty()) {
            ++producedSSTables;
            sstables.add(sstableLister.consumeOne());
        }
        Assertions.assertThat((int)producedSSTables).isEqualTo(1);
        Assertions.assertThat((long)sstableLister.totalSize()).isEqualTo(0L);
        Assertions.assertThat(sstables).hasSize(2);
        Set range2Files = ((SSTableCollector.SSTableFilesAndRange)sstables.get((int)1)).files;
        Assertions.assertThat((Collection)range2Files).contains((Object[])new Path[]{this.outputDir.resolve("na-2-big-Data.db")});
        Assertions.assertThat((Collection)range2Files).contains((Object[])new Path[]{this.outputDir.resolve("na-2-big-Index.db")});
        Assertions.assertThat((Collection)range2Files).contains((Object[])new Path[]{this.outputDir.resolve("na-2-big-Summary.db")});
        Assertions.assertThat((Collection)range2Files).contains((Object[])new Path[]{this.outputDir.resolve("na-2-big-Statistics.db")});
        Assertions.assertThat((Collection)range2Files).contains((Object[])new Path[]{this.outputDir.resolve("na-2-big-TOC.txt")});
    }

    private SSTableLister setupSSTableLister() throws URISyntaxException {
        this.outputDir = Paths.get(this.getClass().getResource("/data/ks/table1-ea3b3e6b-0d78-4913-89f2-15fcf98711d0").toURI());
        CassandraBridge bridge = (CassandraBridge)Mockito.mock(CassandraBridge.class);
        SSTableSummary summary1 = new SSTableSummary(BigInteger.valueOf(1L), BigInteger.valueOf(3L), "na-1-big-");
        SSTableSummary summary2 = new SSTableSummary(BigInteger.valueOf(3L), BigInteger.valueOf(6L), "na-2-big-");
        FileSystemSSTable ssTable1 = new FileSystemSSTable(this.outputDir.resolve("na-1-big-Data.db"), false, null);
        FileSystemSSTable ssTable2 = new FileSystemSSTable(this.outputDir.resolve("na-2-big-Data.db"), false, null);
        Mockito.when((Object)bridge.getSSTableSummary("ks", "table1", (SSTable)ssTable1)).thenReturn((Object)summary1);
        Mockito.when((Object)bridge.getSSTableSummary("ks", "table1", (SSTable)ssTable2)).thenReturn((Object)summary2);
        return new SSTableLister(new QualifiedTableName("ks", "table1"), bridge);
    }

    static Map<Path, Digest> calculateFileDigests(Path dir) {
        DigestAlgorithm digester = (DigestAlgorithm)DigestAlgorithms.XXHASH32.get();
        HashMap<Path, Digest> result = new HashMap<Path, Digest>();
        try (Stream<Path> files = Files.walk(dir, new FileVisitOption[0]);){
            Iterator it = files.iterator();
            while (it.hasNext()) {
                Path file = (Path)it.next();
                if (!Files.isRegularFile(file, new LinkOption[0])) continue;
                result.put(file, digester.calculateFileDigest(file));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result;
    }
}

