/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.utils.streaming;

import java.time.Duration;
import org.apache.cassandra.spark.data.FileType;
import org.apache.cassandra.spark.utils.streaming.CassandraFile;
import org.apache.cassandra.spark.utils.streaming.StreamConsumer;
import org.jetbrains.annotations.Nullable;

public interface CassandraFileSource<T extends CassandraFile>
extends AutoCloseable {
    public static final long DEFAULT_MAX_BUFFER_SIZE = 0x600004L;
    public static final long DEFAULT_CHUNK_BUFFER_SIZE = 0x3FFFFCL;

    public void request(long var1, long var3, StreamConsumer var5);

    public T cassandraFile();

    public FileType fileType();

    public long size();

    default public long maxBufferSize() {
        return 0x600004L;
    }

    default public long chunkBufferSize() {
        return 0x3FFFFCL;
    }

    default public long headerChunkSize() {
        return this.chunkBufferSize();
    }

    @Nullable
    default public Duration timeout() {
        return null;
    }

    @Override
    default public void close() throws Exception {
    }
}

