/*
 * Decompiled with CFR 0.152.
 */
package o.a.c.sidecar.client.shaded.io.vertx.core.http.impl;

import java.nio.charset.Charset;
import o.a.c.sidecar.client.shaded.io.vertx.core.AsyncResult;
import o.a.c.sidecar.client.shaded.io.vertx.core.Future;
import o.a.c.sidecar.client.shaded.io.vertx.core.Handler;
import o.a.c.sidecar.client.shaded.io.vertx.core.buffer.Buffer;
import o.a.c.sidecar.client.shaded.io.vertx.core.file.AsyncFile;
import o.a.c.sidecar.client.shaded.io.vertx.core.file.FileSystem;
import o.a.c.sidecar.client.shaded.io.vertx.core.file.OpenOptions;
import o.a.c.sidecar.client.shaded.io.vertx.core.http.HttpServerFileUpload;
import o.a.c.sidecar.client.shaded.io.vertx.core.impl.ContextInternal;
import o.a.c.sidecar.client.shaded.io.vertx.core.streams.Pipe;
import o.a.c.sidecar.client.shaded.io.vertx.core.streams.ReadStream;
import o.a.c.sidecar.client.shaded.io.vertx.core.streams.WriteStream;

class HttpServerFileUploadImpl
implements HttpServerFileUpload {
    private final ReadStream<Buffer> stream;
    private final ContextInternal context;
    private final String name;
    private final String filename;
    private final String contentType;
    private final String contentTransferEncoding;
    private final Charset charset;
    private Handler<Buffer> dataHandler;
    private Handler<Void> endHandler;
    private Handler<Throwable> exceptionHandler;
    private long size;
    private boolean lazyCalculateSize;
    private AsyncFile file;
    private Pipe<Buffer> pipe;
    private boolean cancelled;

    HttpServerFileUploadImpl(ContextInternal context, ReadStream<Buffer> stream, String name, String filename, String contentType, String contentTransferEncoding, Charset charset, long size) {
        this.context = context;
        this.stream = stream;
        this.name = name;
        this.filename = filename;
        this.contentType = contentType;
        this.contentTransferEncoding = contentTransferEncoding;
        this.charset = charset;
        this.size = size;
        this.lazyCalculateSize = size == 0L;
        stream.handler(this::handleData);
        stream.exceptionHandler(this::handleException);
        stream.endHandler((Void v) -> this.handleEnd());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleData(Buffer data) {
        Handler<Buffer> handler;
        HttpServerFileUploadImpl httpServerFileUploadImpl = this;
        synchronized (httpServerFileUploadImpl) {
            handler = this.dataHandler;
            if (this.lazyCalculateSize) {
                this.size += (long)data.length();
            }
        }
        if (handler != null) {
            this.context.dispatch(data, handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleException(Throwable cause) {
        Handler<Throwable> handler;
        HttpServerFileUploadImpl httpServerFileUploadImpl = this;
        synchronized (httpServerFileUploadImpl) {
            handler = this.exceptionHandler;
        }
        if (handler != null) {
            this.context.dispatch(cause, handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleEnd() {
        Handler<Void> handler;
        HttpServerFileUploadImpl httpServerFileUploadImpl = this;
        synchronized (httpServerFileUploadImpl) {
            this.lazyCalculateSize = false;
            handler = this.endHandler;
        }
        if (handler != null) {
            this.context.dispatch(handler);
        }
    }

    @Override
    public String filename() {
        return this.filename;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String contentType() {
        return this.contentType;
    }

    @Override
    public String contentTransferEncoding() {
        return this.contentTransferEncoding;
    }

    @Override
    public String charset() {
        return this.charset.toString();
    }

    @Override
    public synchronized long size() {
        return this.size;
    }

    @Override
    public synchronized HttpServerFileUpload handler(Handler<Buffer> handler) {
        this.dataHandler = handler;
        return this;
    }

    @Override
    public HttpServerFileUpload pause() {
        this.stream.pause();
        return this;
    }

    @Override
    public HttpServerFileUpload fetch(long amount) {
        this.stream.fetch(amount);
        return this;
    }

    @Override
    public HttpServerFileUpload resume() {
        this.stream.resume();
        return this;
    }

    @Override
    public synchronized HttpServerFileUpload exceptionHandler(Handler<Throwable> exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
        return this;
    }

    @Override
    public synchronized HttpServerFileUpload endHandler(Handler<Void> handler) {
        this.endHandler = handler;
        return this;
    }

    @Override
    public void streamToFileSystem(String filename, Handler<AsyncResult<Void>> handler) {
        Future<Void> fut = this.streamToFileSystem(filename);
        if (handler != null) {
            fut.onComplete(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<Void> streamToFileSystem(String filename) {
        HttpServerFileUploadImpl httpServerFileUploadImpl = this;
        synchronized (httpServerFileUploadImpl) {
            if (this.pipe != null) {
                return this.context.failedFuture("Already streaming");
            }
            this.pipe = this.pipe().endOnComplete(true);
        }
        FileSystem fs = this.context.owner().fileSystem();
        Future<AsyncFile> fut = fs.open(filename, new OpenOptions());
        fut.onFailure(err -> this.pipe.close());
        return fut.compose(f -> {
            Future<Void> to = this.pipe.to((WriteStream<Buffer>)f);
            return to.compose(v -> {
                HttpServerFileUploadImpl httpServerFileUploadImpl = this;
                synchronized (httpServerFileUploadImpl) {
                    if (!this.cancelled) {
                        this.file = f;
                        return this.context.succeededFuture();
                    }
                    fs.delete(filename);
                    return this.context.failedFuture("Streaming aborted");
                }
            }, err -> {
                fs.delete(filename);
                return this.context.failedFuture((Throwable)err);
            });
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancelStreamToFileSystem() {
        HttpServerFileUploadImpl httpServerFileUploadImpl = this;
        synchronized (httpServerFileUploadImpl) {
            if (this.pipe == null) {
                throw new IllegalStateException("Not a streaming upload");
            }
            if (this.file != null) {
                return false;
            }
            this.cancelled = true;
        }
        this.pipe.close();
        return true;
    }

    @Override
    public synchronized boolean isSizeAvailable() {
        return !this.lazyCalculateSize;
    }

    @Override
    public synchronized AsyncFile file() {
        return this.file;
    }
}

