/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.data.converter.types;

import java.math.BigDecimal;
import org.apache.cassandra.bridge.BigNumberConfig;
import org.apache.cassandra.spark.data.converter.types.DecimalFeatures;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Decimal;
import org.jetbrains.annotations.NotNull;

public class SparkDecimal
implements DecimalFeatures {
    public static final SparkDecimal INSTANCE = new SparkDecimal();

    private SparkDecimal() {
    }

    @Override
    public DataType dataType(BigNumberConfig bigNumberConfig) {
        return DataTypes.createDecimalType((int)bigNumberConfig.bigDecimalPrecision(), (int)bigNumberConfig.bigDecimalScale());
    }

    @Override
    public Object toSparkSqlType(@NotNull Object value, boolean isFrozen) {
        return Decimal.apply((BigDecimal)((BigDecimal)value));
    }

    @Override
    public Object nativeSparkSqlRowValue(GenericInternalRow row, int position) {
        return row.getDecimal(position, BigNumberConfig.DEFAULT.bigIntegerPrecision(), BigNumberConfig.DEFAULT.bigIntegerScale());
    }

    @Override
    public Object nativeSparkSqlRowValue(Row row, int position) {
        return row.getDecimal(position);
    }

    @Override
    public Object toTestRowType(Object value) {
        if (value instanceof BigDecimal) {
            return value;
        }
        return ((Decimal)value).toJavaBigDecimal();
    }
}

