/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.client.request;

import java.util.List;
import org.apache.cassandra.sidecar.client.RequestContext;
import org.apache.cassandra.sidecar.client.request.RequestTestParameters;
import org.apache.cassandra.sidecar.common.response.ListSnapshotFilesResponse;
import org.assertj.core.api.Assertions;

public class ListSnapshotFilesRequestTestParameters
implements RequestTestParameters<ListSnapshotFilesResponse> {
    @Override
    public RequestContext.Builder specificRequest(RequestContext.Builder requestContextBuilder) {
        return requestContextBuilder.listSnapshotFilesRequest("keyspace1", "standard1", "2023.04.10");
    }

    @Override
    public String okResponseBody() {
        return "{\"snapshotFilesInfo\":[{\"size\":80,\"host\":\"localhost2\",\"port\":9043,\"dataDirIndex\":0,\"snapshotName\":\"2023.04.10\",\"keySpaceName\":\"keyspace1\",\"tableName\":\"standard1-bc1a8c20d7f111eda9b8056729c856e9\",\"fileName\":\"nb-1-big-TOC.txt\"},{\"size\":10,\"host\":\"localhost2\",\"port\":9043,\"dataDirIndex\":0,\"snapshotName\":\"2023.04.10\",\"keySpaceName\":\"keyspace1\",\"tableName\":\"standard1-bc1a8c20d7f111eda9b8056729c856e9\",\"fileName\":\"nb-1-big-Digest.crc32\"},{\"size\":424,\"host\":\"localhost2\",\"port\":9043,\"dataDirIndex\":0,\"snapshotName\":\"2023.04.10\",\"keySpaceName\":\"keyspace1\",\"tableName\":\"standard1-bc1a8c20d7f111eda9b8056729c856e9\",\"fileName\":\"nb-1-big-CRC.db\"},{\"size\":5222,\"host\":\"localhost2\",\"port\":9043,\"dataDirIndex\":0,\"snapshotName\":\"2023.04.10\",\"keySpaceName\":\"keyspace1\",\"tableName\":\"standard1-bc1a8c20d7f111eda9b8056729c856e9\",\"fileName\":\"nb-1-big-Summary.db\"},{\"size\":500769,\"host\":\"localhost2\",\"port\":9043,\"dataDirIndex\":0,\"snapshotName\":\"2023.04.10\",\"keySpaceName\":\"keyspace1\",\"tableName\":\"standard1-bc1a8c20d7f111eda9b8056729c856e9\",\"fileName\":\"nb-1-big-Index.db\"},{\"size\":31,\"host\":\"localhost2\",\"port\":9043,\"dataDirIndex\":0,\"snapshotName\":\"2023.04.10\",\"keySpaceName\":\"keyspace1\",\"tableName\":\"standard1-bc1a8c20d7f111eda9b8056729c856e9\",\"fileName\":\"manifest.json\"},{\"size\":6870000,\"host\":\"localhost2\",\"port\":9043,\"dataDirIndex\":0,\"snapshotName\":\"2023.04.10\",\"keySpaceName\":\"keyspace1\",\"tableName\":\"standard1-bc1a8c20d7f111eda9b8056729c856e9\",\"fileName\":\"nb-1-big-Data.db\"},{\"size\":864,\"host\":\"localhost2\",\"port\":9043,\"dataDirIndex\":0,\"snapshotName\":\"2023.04.10\",\"keySpaceName\":\"keyspace1\",\"tableName\":\"standard1-bc1a8c20d7f111eda9b8056729c856e9\",\"fileName\":\"schema.cql\"},{\"size\":37512,\"host\":\"localhost2\",\"port\":9043,\"dataDirIndex\":0,\"snapshotName\":\"2023.04.10\",\"keySpaceName\":\"keyspace1\",\"tableName\":\"standard1-bc1a8c20d7f111eda9b8056729c856e9\",\"fileName\":\"nb-1-big-Filter.db\"},{\"size\":10353,\"host\":\"localhost2\",\"port\":9043,\"dataDirIndex\":0,\"snapshotName\":\"2023.04.10\",\"keySpaceName\":\"keyspace1\",\"tableName\":\"standard1-bc1a8c20d7f111eda9b8056729c856e9\",\"fileName\":\"nb-1-big-Statistics.db\"}]}";
    }

    @Override
    public String expectedEndpointPath() {
        return "/api/v1/keyspaces/:keyspace/tables/:table/snapshots/:snapshot".replaceAll(":keyspace", "keyspace1").replaceAll(":table", "standard1").replaceAll(":snapshot", "2023.04.10");
    }

    @Override
    public void validateResponse(ListSnapshotFilesResponse response) {
        Assertions.assertThat((Object)response).isNotNull();
        Assertions.assertThat((List)response.snapshotFilesInfo()).hasSize(10);
        Assertions.assertThat((String)((ListSnapshotFilesResponse.FileInfo)response.snapshotFilesInfo().get((int)0)).fileName).isEqualTo("nb-1-big-TOC.txt");
        Assertions.assertThat((long)((ListSnapshotFilesResponse.FileInfo)response.snapshotFilesInfo().get((int)0)).size).isEqualTo(80L);
        Assertions.assertThat((String)((ListSnapshotFilesResponse.FileInfo)response.snapshotFilesInfo().get((int)1)).fileName).isEqualTo("nb-1-big-Digest.crc32");
        Assertions.assertThat((long)((ListSnapshotFilesResponse.FileInfo)response.snapshotFilesInfo().get((int)1)).size).isEqualTo(10L);
        Assertions.assertThat((String)((ListSnapshotFilesResponse.FileInfo)response.snapshotFilesInfo().get((int)2)).fileName).isEqualTo("nb-1-big-CRC.db");
        Assertions.assertThat((long)((ListSnapshotFilesResponse.FileInfo)response.snapshotFilesInfo().get((int)2)).size).isEqualTo(424L);
        Assertions.assertThat((String)((ListSnapshotFilesResponse.FileInfo)response.snapshotFilesInfo().get((int)3)).fileName).isEqualTo("nb-1-big-Summary.db");
        Assertions.assertThat((long)((ListSnapshotFilesResponse.FileInfo)response.snapshotFilesInfo().get((int)3)).size).isEqualTo(5222L);
        Assertions.assertThat((String)((ListSnapshotFilesResponse.FileInfo)response.snapshotFilesInfo().get((int)4)).fileName).isEqualTo("nb-1-big-Index.db");
        Assertions.assertThat((long)((ListSnapshotFilesResponse.FileInfo)response.snapshotFilesInfo().get((int)4)).size).isEqualTo(500769L);
        Assertions.assertThat((String)((ListSnapshotFilesResponse.FileInfo)response.snapshotFilesInfo().get((int)5)).fileName).isEqualTo("manifest.json");
        Assertions.assertThat((long)((ListSnapshotFilesResponse.FileInfo)response.snapshotFilesInfo().get((int)5)).size).isEqualTo(31L);
        Assertions.assertThat((String)((ListSnapshotFilesResponse.FileInfo)response.snapshotFilesInfo().get((int)6)).fileName).isEqualTo("nb-1-big-Data.db");
        Assertions.assertThat((long)((ListSnapshotFilesResponse.FileInfo)response.snapshotFilesInfo().get((int)6)).size).isEqualTo(6870000L);
        Assertions.assertThat((String)((ListSnapshotFilesResponse.FileInfo)response.snapshotFilesInfo().get((int)7)).fileName).isEqualTo("schema.cql");
        Assertions.assertThat((long)((ListSnapshotFilesResponse.FileInfo)response.snapshotFilesInfo().get((int)7)).size).isEqualTo(864L);
        Assertions.assertThat((String)((ListSnapshotFilesResponse.FileInfo)response.snapshotFilesInfo().get((int)8)).fileName).isEqualTo("nb-1-big-Filter.db");
        Assertions.assertThat((long)((ListSnapshotFilesResponse.FileInfo)response.snapshotFilesInfo().get((int)8)).size).isEqualTo(37512L);
        Assertions.assertThat((String)((ListSnapshotFilesResponse.FileInfo)response.snapshotFilesInfo().get((int)9)).fileName).isEqualTo("nb-1-big-Statistics.db");
        Assertions.assertThat((long)((ListSnapshotFilesResponse.FileInfo)response.snapshotFilesInfo().get((int)9)).size).isEqualTo(10353L);
    }
}

