/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.analytics;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.agent.ByteBuddyAgent;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.dynamic.loading.ClassReloadingStrategy;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodCall;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.apache.cassandra.analytics.SharedClusterSparkIntegrationTestBase;
import org.apache.cassandra.distributed.api.ConsistencyLevel;
import org.apache.cassandra.distributed.api.ICoordinator;
import org.apache.cassandra.distributed.api.IInstance;
import org.apache.cassandra.distributed.shared.NetworkTopology;
import org.apache.cassandra.sidecar.testing.QualifiedName;
import org.apache.cassandra.spark.data.CassandraDataLayer;
import org.apache.cassandra.spark.data.PartitionedDataLayer;
import org.apache.cassandra.spark.data.partitioner.CassandraInstance;
import org.apache.cassandra.spark.data.partitioner.NotEnoughReplicasException;
import org.apache.cassandra.testing.ClusterBuilderConfiguration;
import org.apache.cassandra.testing.TestUtils;
import org.apache.spark.SparkException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.assertj.core.api.Assertions;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;

public class BulkReaderMultiDCConsistencyTest
extends SharedClusterSparkIntegrationTestBase {
    static final List<String> OG_DATASET = Arrays.asList("a", "b", "c", "d", "e", "f", "g");
    static final int TEST_KEY = 1;
    static final String TEST_VAL = "C*";
    QualifiedName table1 = TestUtils.uniqueTestTableFullName((String)"spark_test");

    protected ClusterBuilderConfiguration testClusterConfiguration() {
        return super.testClusterConfiguration().dcCount(2).nodesPerDc(3).dcAndRackSupplier(nodeId -> {
            switch (nodeId) {
                case 1: 
                case 2: 
                case 3: {
                    return NetworkTopology.dcAndRack((String)"datacenter1", (String)"rack1");
                }
                case 4: 
                case 5: 
                case 6: {
                    return NetworkTopology.dcAndRack((String)"datacenter2", (String)"rack1");
                }
            }
            return NetworkTopology.dcAndRack((String)"", (String)"");
        });
    }

    @Test
    void happyPathTest() {
        ArrayList<String> testDataSet = new ArrayList<String>(OG_DATASET);
        testDataSet.set(1, TEST_VAL);
        this.setValueForALL(1, TEST_VAL);
        List<Row> rowList = this.bulkRead(ConsistencyLevel.ALL.name());
        BulkReaderMultiDCConsistencyTest.validateBulkReadRows(rowList, testDataSet);
        rowList = this.bulkRead(ConsistencyLevel.QUORUM.name());
        BulkReaderMultiDCConsistencyTest.validateBulkReadRows(rowList, testDataSet);
        rowList = this.bulkRead(ConsistencyLevel.EACH_QUORUM.name());
        BulkReaderMultiDCConsistencyTest.validateBulkReadRows(rowList, testDataSet);
        String valAll = this.readValueForKey(1, ConsistencyLevel.ALL);
        String valQuorum = this.readValueForKey(1, ConsistencyLevel.QUORUM);
        String valEachQuorum = this.readValueForKey(1, ConsistencyLevel.EACH_QUORUM);
        Assertions.assertThat((String)valAll).isEqualTo(valQuorum).isEqualTo(valEachQuorum).isEqualTo(rowList.get(1).getString(1));
        this.setValueForALL(1, OG_DATASET.get(1));
    }

    public static PartitionedDataLayer.AvailabilityHint getAvailability(CassandraInstance instance) {
        if (instance.nodeName().equals("localhost5") || instance.nodeName().equals("localhost6")) {
            return PartitionedDataLayer.AvailabilityHint.MOVING;
        }
        return PartitionedDataLayer.AvailabilityHint.UP;
    }

    @Test
    void eachQuorumIsNotQuorum() throws NoSuchMethodException {
        ArrayList<String> updatedDataSet = new ArrayList<String>(OG_DATASET);
        updatedDataSet.set(1, TEST_VAL);
        this.updateValueNodeInternal(5, 1, TEST_VAL);
        this.updateValueNodeInternal(6, 1, TEST_VAL);
        ByteBuddyAgent.install();
        new ByteBuddy().redefine(CassandraDataLayer.class).method((ElementMatcher)ElementMatchers.named((String)"getAvailability")).intercept((Implementation)MethodCall.invoke((Method)BulkReaderMultiDCConsistencyTest.class.getMethod("getAvailability", CassandraInstance.class)).withAllArguments()).make().load(CassandraDataLayer.class.getClassLoader(), (ClassLoadingStrategy)ClassReloadingStrategy.fromInstalledAgent());
        List<Row> rowList = this.bulkRead(ConsistencyLevel.QUORUM.name());
        BulkReaderMultiDCConsistencyTest.validateBulkReadRows(rowList, OG_DATASET);
        this.cluster.filters().allVerbs().from(new int[]{5}).to(new int[]{1}).drop();
        this.cluster.filters().allVerbs().from(new int[]{6}).to(new int[]{1}).drop();
        String quorumVal = this.readValueForKey(this.cluster.get(1).coordinator(), 1, ConsistencyLevel.QUORUM);
        Assertions.assertThat((String)quorumVal).isEqualTo(OG_DATASET.get(1));
        this.cluster.filters().reset();
        rowList = this.bulkRead(ConsistencyLevel.EACH_QUORUM.name());
        BulkReaderMultiDCConsistencyTest.validateBulkReadRows(rowList, updatedDataSet);
        String eachQuorumVal = this.readValueForKey(1, ConsistencyLevel.EACH_QUORUM);
        Assertions.assertThat((String)eachQuorumVal).isEqualTo(rowList.get(1).getString(1));
        this.setValueForALL(1, OG_DATASET.get(1));
    }

    @Test
    void eachQuorumSuccessWithOneNodeDownEachDC() throws Exception {
        this.cluster.stopUnchecked(this.cluster.get(1));
        this.cluster.stopUnchecked(this.cluster.get(4));
        List<Row> rowList = this.bulkRead(ConsistencyLevel.EACH_QUORUM.name());
        BulkReaderMultiDCConsistencyTest.validateBulkReadRows(rowList, OG_DATASET);
        String eachQuorumVal = this.readValueForKey(1, ConsistencyLevel.EACH_QUORUM);
        Assertions.assertThat((String)eachQuorumVal).isEqualTo(rowList.get(1).getString(1));
        this.tearDown();
        this.setup();
    }

    @Test
    void eachQuorumFailureWithTwoNodesDownOneDC() throws Exception {
        this.cluster.stopUnchecked(this.cluster.get(4));
        this.cluster.stopUnchecked(this.cluster.get(5));
        List<Row> rowList = this.bulkRead(ConsistencyLevel.QUORUM.name());
        BulkReaderMultiDCConsistencyTest.validateBulkReadRows(rowList, OG_DATASET);
        String quorumVal = this.readValueForKey(1, ConsistencyLevel.QUORUM);
        Assertions.assertThat((String)quorumVal).isEqualTo(rowList.get(1).getString(1));
        try {
            this.bulkRead(ConsistencyLevel.EACH_QUORUM.name());
        }
        catch (Exception ex) {
            Assertions.assertThat((Throwable)ex).isNotNull();
            Assertions.assertThat((Throwable)ex).isInstanceOf(SparkException.class);
            Assertions.assertThat((Throwable)ex.getCause()).isInstanceOf(NotEnoughReplicasException.class);
            Assertions.assertThat((String)ex.getCause().getMessage()).isEqualTo("Required 2 replicas but only 1 responded");
        }
        try {
            this.readValueForKey(1, ConsistencyLevel.EACH_QUORUM);
        }
        catch (Exception ex) {
            Assertions.assertThat((Throwable)ex).isNotNull();
            Assertions.assertThat((String)ex.getMessage()).isEqualTo("Cannot achieve consistency level EACH_QUORUM in DC datacenter2");
        }
        this.tearDown();
        this.setup();
    }

    private void validateReadRepairIsDisabled() {
        this.updateValueNodeInternal(1, 1, TEST_VAL);
        this.validateNodeInternalValue(1, 1, TEST_VAL);
        this.validateNodeInternalValue(2, 1, OG_DATASET.get(1));
        this.validateNodeInternalValue(5, 1, OG_DATASET.get(1));
        this.readValueForKey(1, ConsistencyLevel.ALL);
        this.validateNodeInternalValue(1, 1, TEST_VAL);
        this.validateNodeInternalValue(2, 1, OG_DATASET.get(1));
        this.validateNodeInternalValue(5, 1, OG_DATASET.get(1));
        this.setValueForALL(1, OG_DATASET.get(1));
    }

    @NotNull
    private List<Row> bulkRead(String consistency) {
        Dataset dataForTable1 = this.bulkReaderDataFrame(this.table1).option("consistencyLevel", consistency).option("dc", null).option("maxRetries", 1L).option("maxMillisToSleep", 50L).option("defaultMillisToSleep", 50L).load();
        List<Row> rowList = dataForTable1.collectAsList().stream().sorted(Comparator.comparing(row -> row.getInt(0))).collect(Collectors.toList());
        return rowList;
    }

    private static void validateBulkReadRows(List<Row> rowList, List<String> dataSet) {
        for (int i = 0; i < dataSet.size(); ++i) {
            Assertions.assertThat((int)rowList.get(i).getInt(0)).isEqualTo(i);
            Assertions.assertThat((String)rowList.get(i).getString(1)).isEqualTo(dataSet.get(i));
        }
    }

    protected void initializeSchemaForTest() {
        this.createTestKeyspace("spark_test", TestUtils.DC1_RF3_DC2_RF3);
        this.createTestTable(this.table1, "CREATE TABLE IF NOT EXISTS %s (id int PRIMARY KEY, name text) with read_repair='NONE';");
        IInstance firstRunningInstance = this.cluster.getFirstRunningInstance();
        for (int i = 0; i < OG_DATASET.size(); ++i) {
            String value = OG_DATASET.get(i);
            String query1 = String.format("INSERT INTO %s (id, name) VALUES (%d, '%s');", this.table1, i, value);
            firstRunningInstance.coordinator().execute(query1, ConsistencyLevel.ALL, new Object[0]);
        }
        this.validateReadRepairIsDisabled();
    }

    private void updateValueNodeInternal(int node, int key, String value) {
        this.cluster.get(node).executeInternal(String.format("UPDATE %s SET name='%s' WHERE id=%d", this.table1, value, key), new Object[0]);
    }

    private void validateNodeInternalValue(int node, int key, String val) {
        Assertions.assertThat((String)this.getNodeInternalValue(node, key)).isEqualTo(val);
    }

    private String getNodeInternalValue(int node, int key) {
        Object[][] result = this.cluster.get(node).executeInternal(String.format("SELECT name FROM %s WHERE id=%d", this.table1, key), new Object[0]);
        return (String)result[0][0];
    }

    private String readValueForKey(int key, ConsistencyLevel consistencyLevel) {
        return this.readValueForKey(this.cluster.getFirstRunningInstance().coordinator(), key, consistencyLevel);
    }

    private String readValueForKey(ICoordinator coordinator, int key, ConsistencyLevel consistencyLevel) {
        Object[][] result = coordinator.execute(String.format("SELECT name FROM %s WHERE id=%d", this.table1, key), consistencyLevel, new Object[0]);
        return (String)result[0][0];
    }

    private void setValueForALL(int key, String value) {
        this.cluster.getFirstRunningInstance().coordinator().execute(String.format("UPDATE %s SET name='%s' WHERE id=%d", this.table1, value, key), ConsistencyLevel.ALL, new Object[0]);
    }
}

