/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.db.Digest;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.marshal.SetType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.rows.ColumnData;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.ObjectSizes;
import org.apache.cassandra.utils.btree.BTree;
import org.apache.cassandra.utils.btree.BTreeRemoval;
import org.apache.cassandra.utils.btree.BTreeSearchIterator;

public class Columns
extends AbstractCollection<ColumnMetadata>
implements Collection<ColumnMetadata> {
    public static final Serializer serializer = new Serializer();
    public static final Columns NONE = new Columns(BTree.empty(), 0);
    static final long EMPTY_SIZE = ObjectSizes.measure(NONE);
    public static final ColumnMetadata FIRST_COMPLEX_STATIC = new ColumnMetadata("", "", ColumnIdentifier.getInterned(ByteBufferUtil.EMPTY_BYTE_BUFFER, UTF8Type.instance), SetType.getInstance(UTF8Type.instance, true), -1, ColumnMetadata.Kind.STATIC);
    public static final ColumnMetadata FIRST_COMPLEX_REGULAR = new ColumnMetadata("", "", ColumnIdentifier.getInterned(ByteBufferUtil.EMPTY_BYTE_BUFFER, UTF8Type.instance), SetType.getInstance(UTF8Type.instance, true), -1, ColumnMetadata.Kind.REGULAR);
    private final Object[] columns;
    private final int complexIdx;

    private Columns(Object[] columns, int complexIdx) {
        assert (complexIdx <= BTree.size(columns));
        this.columns = columns;
        this.complexIdx = complexIdx;
    }

    private Columns(Object[] columns) {
        this(columns, Columns.findFirstComplexIdx(columns));
    }

    public static Columns of(ColumnMetadata c) {
        return new Columns(BTree.singleton(c), c.isComplex() ? 0 : 1);
    }

    public static Columns from(Row row) {
        try (BTree.FastBuilder<ColumnMetadata> builder = BTree.fastBuilder();){
            for (ColumnData cd2 : row) {
                builder.add(cd2.column());
            }
            Object[] tree = builder.build();
            Columns columns = new Columns(tree, Columns.findFirstComplexIdx(tree));
            return columns;
        }
    }

    public static Columns from(BTree.Builder<ColumnMetadata> builder) {
        Object[] tree = builder.build();
        return new Columns(tree, Columns.findFirstComplexIdx(tree));
    }

    public static Columns from(Collection<ColumnMetadata> s2) {
        Object[] tree = BTree.builder(Comparator.naturalOrder()).addAll(s2).build();
        return new Columns(tree, Columns.findFirstComplexIdx(tree));
    }

    private static int findFirstComplexIdx(Object[] tree) {
        if (BTree.isEmpty(tree)) {
            return 0;
        }
        int size = BTree.size(tree);
        ColumnMetadata last = (ColumnMetadata)BTree.findByIndex(tree, size - 1);
        return last.isSimple() ? size : BTree.ceilIndex(tree, Comparator.naturalOrder(), last.isStatic() ? FIRST_COMPLEX_STATIC : FIRST_COMPLEX_REGULAR);
    }

    @Override
    public boolean isEmpty() {
        return BTree.isEmpty(this.columns);
    }

    public int simpleColumnCount() {
        return this.complexIdx;
    }

    public int complexColumnCount() {
        return BTree.size(this.columns) - this.complexIdx;
    }

    @Override
    public int size() {
        return BTree.size(this.columns);
    }

    public boolean hasSimple() {
        return this.complexIdx > 0;
    }

    public boolean hasComplex() {
        return this.complexIdx < BTree.size(this.columns);
    }

    public ColumnMetadata getSimple(int i) {
        return (ColumnMetadata)BTree.findByIndex(this.columns, i);
    }

    public ColumnMetadata getComplex(int i) {
        return (ColumnMetadata)BTree.findByIndex(this.columns, this.complexIdx + i);
    }

    public int simpleIdx(ColumnMetadata c) {
        return BTree.findIndex(this.columns, Comparator.naturalOrder(), c);
    }

    public int complexIdx(ColumnMetadata c) {
        return BTree.findIndex(this.columns, Comparator.naturalOrder(), c) - this.complexIdx;
    }

    public boolean contains(ColumnMetadata c) {
        return BTree.findIndex(this.columns, Comparator.naturalOrder(), c) >= 0;
    }

    public Columns mergeTo(Columns other) {
        if (this == other || other == NONE) {
            return this;
        }
        if (this == NONE) {
            return other;
        }
        Object[] tree = BTree.update(this.columns, other.columns, Comparator.naturalOrder());
        if (tree == this.columns) {
            return this;
        }
        if (tree == other.columns) {
            return other;
        }
        return new Columns(tree, Columns.findFirstComplexIdx(tree));
    }

    @Override
    public boolean containsAll(Collection<?> other) {
        if (other == this) {
            return true;
        }
        if (other.size() > this.size()) {
            return false;
        }
        BTreeSearchIterator iter2 = BTree.slice(this.columns, Comparator.naturalOrder(), BTree.Dir.ASC);
        for (Object def : other) {
            if (iter2.next((ColumnMetadata)def) != null) continue;
            return false;
        }
        return true;
    }

    public Iterator<ColumnMetadata> simpleColumns() {
        return BTree.iterator(this.columns, 0, this.complexIdx - 1, BTree.Dir.ASC);
    }

    public Iterator<ColumnMetadata> complexColumns() {
        return BTree.iterator(this.columns, this.complexIdx, BTree.size(this.columns) - 1, BTree.Dir.ASC);
    }

    public BTreeSearchIterator<ColumnMetadata, ColumnMetadata> iterator() {
        return BTree.slice(this.columns, Comparator.naturalOrder(), BTree.Dir.ASC);
    }

    public Iterator<ColumnMetadata> selectOrderIterator() {
        return Iterators.mergeSorted(ImmutableList.of(this.simpleColumns(), this.complexColumns()), (s2, c) -> {
            assert (!s2.kind.isPrimaryKeyKind());
            return s2.name.bytes.compareTo(c.name.bytes);
        });
    }

    public Columns without(ColumnMetadata column) {
        if (!this.contains(column)) {
            return this;
        }
        Object[] newColumns = BTreeRemoval.remove(this.columns, Comparator.naturalOrder(), column);
        return new Columns(newColumns);
    }

    public Predicate<ColumnMetadata> inOrderInclusionTester() {
        BTreeSearchIterator iter2 = BTree.slice(this.columns, Comparator.naturalOrder(), BTree.Dir.ASC);
        return column -> iter2.next(column) != null;
    }

    public void digest(Digest digest) {
        for (ColumnMetadata c : this) {
            digest.update(c.name.bytes);
        }
    }

    public void apply(Consumer<ColumnMetadata> function) {
        BTree.apply(this.columns, function);
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Columns)) {
            return false;
        }
        Columns that = (Columns)other;
        return this.complexIdx == that.complexIdx && BTree.equals(this.columns, that.columns);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.complexIdx, BTree.hashCode(this.columns));
    }

    public long unsharedHeapSize() {
        if (this == NONE) {
            return 0L;
        }
        return EMPTY_SIZE + BTree.sizeOfStructureOnHeap(this.columns);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("[");
        boolean first = true;
        for (ColumnMetadata def : this) {
            if (first) {
                first = false;
            } else {
                sb.append(" ");
            }
            sb.append(def.name);
        }
        return sb.append("]").toString();
    }

    public static class Serializer {
        public void serialize(Columns columns, DataOutputPlus out) throws IOException {
            out.writeUnsignedVInt(columns.size());
            for (ColumnMetadata column : columns) {
                ByteBufferUtil.writeWithVIntLength(column.name.bytes, out);
            }
        }

        public long serializedSize(Columns columns) {
            long size = TypeSizes.sizeofUnsignedVInt(columns.size());
            for (ColumnMetadata column : columns) {
                size += (long)ByteBufferUtil.serializedSizeWithVIntLength(column.name.bytes);
            }
            return size;
        }

        public Columns deserialize(DataInputPlus in, TableMetadata metadata) throws IOException {
            int length = (int)in.readUnsignedVInt();
            try (BTree.FastBuilder<ColumnMetadata> builder = BTree.fastBuilder();){
                for (int i = 0; i < length; ++i) {
                    ByteBuffer name = ByteBufferUtil.readWithVIntLength(in);
                    ColumnMetadata column = metadata.getColumn(name);
                    if (column == null && (column = metadata.getDroppedColumn(name)) == null) {
                        throw new RuntimeException("Unknown column " + UTF8Type.instance.getString(name) + " during deserialization");
                    }
                    builder.add(column);
                }
                Columns columns = new Columns(builder.build());
                return columns;
            }
        }

        public void serializeSubset(Collection<ColumnMetadata> columns, Columns superset, DataOutputPlus out) throws IOException {
            int supersetCount;
            int columnCount = columns.size();
            if (columnCount == (supersetCount = superset.size())) {
                out.writeUnsignedVInt(0L);
            } else if (supersetCount < 64) {
                out.writeUnsignedVInt(Serializer.encodeBitmap(columns, superset, supersetCount));
            } else {
                this.serializeLargeSubset(columns, columnCount, superset, supersetCount, out);
            }
        }

        public long serializedSubsetSize(Collection<ColumnMetadata> columns, Columns superset) {
            int supersetCount;
            int columnCount = columns.size();
            if (columnCount == (supersetCount = superset.size())) {
                return TypeSizes.sizeofUnsignedVInt(0L);
            }
            if (supersetCount < 64) {
                return TypeSizes.sizeofUnsignedVInt(Serializer.encodeBitmap(columns, superset, supersetCount));
            }
            return this.serializeLargeSubsetSize(columns, columnCount, superset, supersetCount);
        }

        public Columns deserializeSubset(Columns superset, DataInputPlus in) throws IOException {
            long encoded = in.readUnsignedVInt();
            if (encoded == 0L) {
                return superset;
            }
            if (superset.size() >= 64) {
                return this.deserializeLargeSubset(in, superset, (int)encoded);
            }
            try (BTree.FastBuilder<ColumnMetadata> builder = BTree.fastBuilder();){
                int firstComplexIdx = 0;
                for (ColumnMetadata column : superset) {
                    if ((encoded & 1L) == 0L) {
                        builder.add(column);
                        if (column.isSimple()) {
                            ++firstComplexIdx;
                        }
                    }
                    encoded >>>= 1;
                }
                if (encoded != 0L) {
                    throw new IOException("Invalid Columns subset bytes; too many bits set:" + Long.toBinaryString(encoded));
                }
                Columns columns = new Columns(builder.build(), firstComplexIdx);
                return columns;
            }
        }

        private static long encodeBitmap(Collection<ColumnMetadata> columns, Columns superset, int supersetCount) {
            long bitmap = 0L;
            Iterator iter2 = superset.iterator();
            int expectIndex = 0;
            for (ColumnMetadata column : columns) {
                if (iter2.next(column) == null) {
                    throw new IllegalStateException(columns + " is not a subset of " + superset);
                }
                int currentIndex = iter2.indexOfCurrent();
                int count = currentIndex - expectIndex;
                bitmap |= (1L << count) - 1L << expectIndex;
                expectIndex = currentIndex + 1;
            }
            int count = supersetCount - expectIndex;
            return bitmap |= (1L << count) - 1L << expectIndex;
        }

        private void serializeLargeSubset(Collection<ColumnMetadata> columns, int columnCount, Columns superset, int supersetCount, DataOutputPlus out) throws IOException {
            out.writeUnsignedVInt(supersetCount - columnCount);
            Iterator iter2 = superset.iterator();
            if (columnCount < supersetCount / 2) {
                for (ColumnMetadata column : columns) {
                    if (iter2.next(column) == null) {
                        throw new IllegalStateException();
                    }
                    out.writeUnsignedVInt(iter2.indexOfCurrent());
                }
            } else {
                int prev = -1;
                for (ColumnMetadata column : columns) {
                    if (iter2.next(column) == null) {
                        throw new IllegalStateException();
                    }
                    int cur = iter2.indexOfCurrent();
                    while (++prev != cur) {
                        out.writeUnsignedVInt(prev);
                    }
                }
                while (++prev != supersetCount) {
                    out.writeUnsignedVInt(prev);
                }
            }
        }

        private Columns deserializeLargeSubset(DataInputPlus in, Columns superset, int delta) throws IOException {
            int supersetCount = superset.size();
            int columnCount = supersetCount - delta;
            try (BTree.FastBuilder builder = BTree.fastBuilder();){
                int idx;
                if (columnCount < supersetCount / 2) {
                    for (int i = 0; i < columnCount; ++i) {
                        idx = (int)in.readUnsignedVInt();
                        builder.add(BTree.findByIndex(superset.columns, idx));
                    }
                } else {
                    Iterator iter2 = superset.iterator();
                    idx = 0;
                    int skipped = 0;
                    while (true) {
                        int nextMissingIndex;
                        int n = nextMissingIndex = skipped < delta ? (int)in.readUnsignedVInt() : supersetCount;
                        while (idx < nextMissingIndex) {
                            ColumnMetadata def = (ColumnMetadata)iter2.next();
                            builder.add(def);
                            ++idx;
                        }
                        if (idx == supersetCount) break;
                        iter2.next();
                        ++idx;
                        ++skipped;
                    }
                }
                Columns columns = new Columns(builder.build());
                return columns;
            }
        }

        private int serializeLargeSubsetSize(Collection<ColumnMetadata> columns, int columnCount, Columns superset, int supersetCount) {
            int size = TypeSizes.sizeofUnsignedVInt(supersetCount - columnCount);
            Iterator iter2 = superset.iterator();
            if (columnCount < supersetCount / 2) {
                for (ColumnMetadata column : columns) {
                    if (iter2.next(column) == null) {
                        throw new IllegalStateException();
                    }
                    size += TypeSizes.sizeofUnsignedVInt(iter2.indexOfCurrent());
                }
            } else {
                int prev = -1;
                for (ColumnMetadata column : columns) {
                    if (iter2.next(column) == null) {
                        throw new IllegalStateException();
                    }
                    int cur = iter2.indexOfCurrent();
                    while (++prev != cur) {
                        size += TypeSizes.sizeofUnsignedVInt(prev);
                    }
                }
                while (++prev != supersetCount) {
                    size += TypeSizes.sizeofUnsignedVInt(prev);
                }
            }
            return size;
        }
    }
}

