/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.paxos;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.service.paxos.AbstractPaxosCallback;
import org.apache.cassandra.service.paxos.Commit;
import org.apache.cassandra.service.paxos.PrepareResponse;
import org.apache.cassandra.utils.UUIDGen;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrepareCallback
extends AbstractPaxosCallback<PrepareResponse> {
    private static final Logger logger = LoggerFactory.getLogger(PrepareCallback.class);
    public boolean promised = true;
    public Commit mostRecentCommit;
    public Commit mostRecentInProgressCommit;
    private final Map<InetAddressAndPort, Commit> commitsByReplica = new ConcurrentHashMap<InetAddressAndPort, Commit>();

    public PrepareCallback(DecoratedKey key, TableMetadata metadata, int targets, ConsistencyLevel consistency, long queryStartNanoTime) {
        super(targets, consistency, queryStartNanoTime);
        this.mostRecentCommit = Commit.emptyCommit(key, metadata);
        this.mostRecentInProgressCommit = Commit.emptyCommit(key, metadata);
    }

    @Override
    public synchronized void onResponse(Message<PrepareResponse> message) {
        PrepareResponse response = (PrepareResponse)message.payload;
        logger.trace("Prepare response {} from {}", (Object)response, (Object)message.from());
        if (response.inProgressCommit.isAfter(this.mostRecentInProgressCommit)) {
            this.mostRecentInProgressCommit = response.inProgressCommit;
        }
        if (!response.promised) {
            this.promised = false;
            while (this.latch.getCount() > 0L) {
                this.latch.countDown();
            }
            return;
        }
        this.commitsByReplica.put(message.from(), response.mostRecentCommit);
        if (response.mostRecentCommit.isAfter(this.mostRecentCommit)) {
            this.mostRecentCommit = response.mostRecentCommit;
        }
        this.latch.countDown();
    }

    public Iterable<InetAddressAndPort> replicasMissingMostRecentCommit(TableMetadata metadata, int nowInSec) {
        long paxosTtlSec = SystemKeyspace.paxosTtlSec(metadata);
        if ((long)UUIDGen.unixTimestampInSec(this.mostRecentCommit.ballot) + paxosTtlSec < (long)nowInSec) {
            return Collections.emptySet();
        }
        return Iterables.filter(this.commitsByReplica.keySet(), new Predicate<InetAddressAndPort>(){

            @Override
            public boolean apply(InetAddressAndPort inetAddress) {
                return !((Commit)((PrepareCallback)PrepareCallback.this).commitsByReplica.get((Object)inetAddress)).ballot.equals(PrepareCallback.this.mostRecentCommit.ballot);
            }
        });
    }
}

