/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.commitlog;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.google.common.annotations.VisibleForTesting;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.apache.cassandra.spark.utils.AsyncExecutor;
import org.apache.cassandra.spark.utils.FutureUtils;
import org.apache.cassandra.spark.utils.KryoUtils;
import org.apache.cassandra.spark.utils.RangeUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PartitionUpdateWrapper
implements Comparable<PartitionUpdateWrapper> {
    public static final DigestSerializer DIGEST_SERIALIZER = new DigestSerializer();
    @NotNull
    private final ByteBuffer partitionKey;
    private final Digest digest;

    public PartitionUpdateWrapper(String keyspace, String table, BigInteger token, int dataSize, Supplier<byte[]> digestSupplier, @NotNull ByteBuffer partitionKey, long maxTimestampMicros, @Nullable AsyncExecutor executor) {
        this(partitionKey, new Digest(keyspace, table, token, dataSize, digestSupplier, maxTimestampMicros, executor));
    }

    public PartitionUpdateWrapper(@NotNull ByteBuffer partitionKey, Digest digest) {
        this.partitionKey = partitionKey;
        this.digest = digest;
    }

    @Nullable
    public ByteBuffer partitionKey() {
        return this.partitionKey;
    }

    public Digest digest() {
        return this.digest;
    }

    public int dataSize() {
        return this.digest.dataSize();
    }

    public String keyspace() {
        return this.digest.keyspace;
    }

    public String table() {
        return this.digest.table;
    }

    public BigInteger token() {
        return this.digest.token;
    }

    public long maxTimestampMicros() {
        return this.digest.maxTimestampMicros;
    }

    public int hashCode() {
        return Objects.hash(this.digest);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!(other instanceof PartitionUpdateWrapper)) {
            return false;
        }
        PartitionUpdateWrapper that = (PartitionUpdateWrapper)other;
        return Objects.equals(this.digest, that.digest);
    }

    @Override
    public int compareTo(@NotNull PartitionUpdateWrapper o) {
        return this.digest.compareTo(o.digest);
    }

    public static class Digest {
        public final String keyspace;
        public final String table;
        private final CompletableFuture<byte[]> digest;
        private final long maxTimestampMicros;
        private final CompletableFuture<Integer> dataSize;
        private final BigInteger token;

        public Digest(String keyspace, String table, BigInteger token, int dataSize, @NotNull Supplier<byte[]> digestSupplier, long maxTimestampMicros, @Nullable AsyncExecutor executor) {
            this.keyspace = keyspace;
            this.table = table;
            this.maxTimestampMicros = maxTimestampMicros;
            this.token = token;
            int tokenByteLen = RangeUtils.bigIntegerByteArraySize(this.token);
            this.digest = executor != null ? executor.submit(digestSupplier) : CompletableFuture.completedFuture(digestSupplier.get());
            this.dataSize = this.digest.thenApply(ar -> 18 + tokenByteLen + ((byte[])ar).length + dataSize);
        }

        @VisibleForTesting
        public Digest(@NotNull String keyspace, @NotNull String table, long maxTimestampMicros, @NotNull byte[] digest, int dataSize, BigInteger token) {
            this.keyspace = keyspace;
            this.table = table;
            this.maxTimestampMicros = maxTimestampMicros;
            this.token = token;
            this.digest = CompletableFuture.completedFuture(digest);
            this.dataSize = CompletableFuture.completedFuture(dataSize);
        }

        public Digest(@NotNull String keyspace, @NotNull String table, long maxTimestampMicros, @NotNull CompletableFuture<byte[]> digest, CompletableFuture<Integer> dataSize, BigInteger token) {
            this.keyspace = keyspace;
            this.table = table;
            this.maxTimestampMicros = maxTimestampMicros;
            this.token = token;
            this.digest = digest;
            this.dataSize = dataSize;
        }

        public byte[] array() {
            return FutureUtils.get(this.digest);
        }

        public int dataSize() {
            return FutureUtils.get(this.dataSize);
        }

        public String keyspace() {
            return this.keyspace;
        }

        public String table() {
            return this.table;
        }

        public BigInteger token() {
            return this.token;
        }

        public long maxTimestampMicros() {
            return this.maxTimestampMicros;
        }

        public int hashCode() {
            return Objects.hash(this.keyspace, this.table);
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            if (!(other instanceof Digest)) {
                return false;
            }
            Digest that = (Digest)other;
            return Objects.equals(this.keyspace, that.keyspace) && Objects.equals(this.table, that.table) && Arrays.equals(this.array(), that.array());
        }

        public int compareTo(@NotNull Digest o) {
            return Long.compare(this.maxTimestampMicros, o.maxTimestampMicros);
        }
    }

    public static class DigestSerializer
    extends Serializer<Digest> {
        public Digest read(Kryo kryo, Input in, Class type) {
            long maxTimestampMicros = in.readLong();
            int size = in.readInt();
            BigInteger token = KryoUtils.readBigInteger(in);
            byte[] digest = in.readBytes((int)in.readShort());
            String keyspace = in.readString();
            String table = in.readString();
            return new Digest(keyspace, table, maxTimestampMicros, digest, size, token);
        }

        public void write(Kryo kryo, Output out, Digest digest) {
            out.writeLong(digest.maxTimestampMicros);
            out.writeInt(digest.dataSize());
            KryoUtils.writeBigInteger(out, digest.token);
            byte[] ar = digest.array();
            out.writeShort(ar.length);
            out.writeBytes(ar);
            out.writeString(digest.keyspace);
            out.writeString(digest.table);
        }
    }
}

