/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.utils.test;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.cassandra.bridge.CassandraBridge;
import org.apache.cassandra.bridge.CassandraVersion;
import org.apache.cassandra.cdc.api.RangeTombstoneData;
import org.apache.cassandra.cdc.api.Row;
import org.apache.cassandra.spark.data.CqlField;
import org.apache.cassandra.spark.data.CqlTable;
import org.apache.cassandra.spark.data.ReplicationFactor;
import org.apache.cassandra.spark.data.converter.SparkSqlTypeConverter;
import org.apache.cassandra.spark.data.partitioner.Partitioner;
import org.apache.cassandra.spark.utils.ByteBufferUtils;
import org.apache.cassandra.spark.utils.ComparisonUtils;
import org.apache.cassandra.spark.utils.RandomUtils;
import org.apache.cassandra.spark.utils.TemporaryDirectory;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TestSchema {
    private final CassandraBridge bridge;
    @NotNull
    public final String keyspace;
    public final String table;
    public final String createStatement;
    public final ReplicationFactor rf = new ReplicationFactor(ReplicationFactor.ReplicationStrategy.NetworkTopologyStrategy, Collections.singletonMap("DC1", 3));
    public final String insertStatement;
    public final String updateStatement;
    public final String deleteStatement;
    public final List<CqlField> partitionKeys;
    public final List<CqlField> clusteringKeys;
    final List<CqlField> allFields;
    public final Set<CqlField.CqlUdt> udts;
    private final Map<String, Integer> fieldPositions;
    @Nullable
    private CassandraVersion version = null;
    private final int minCollectionSize;
    private final Integer blobSize;
    private final boolean quoteIdentifiers;
    public final boolean withCdc;

    public static SparkSqlTypeConverter getSparkSql() {
        try {
            Class<?> bridge = TestSchema.class.getClassLoader().loadClass("org.apache.cassandra.spark.data.converter.SparkSqlTypeConverterImplementation");
            Constructor<?> constructor = bridge.getConstructor(new Class[0]);
            return (SparkSqlTypeConverter)constructor.newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static Builder builder(CassandraBridge bridge) {
        return new Builder(bridge);
    }

    public static Builder basicBuilder(CassandraBridge bridge) {
        return TestSchema.builder(bridge).withPartitionKey("a", (CqlField.CqlType)bridge.aInt()).withClusteringKey("b", (CqlField.CqlType)bridge.aInt()).withColumn("c", (CqlField.CqlType)bridge.aInt());
    }

    public static TestSchema basic(CassandraBridge bridge) {
        return TestSchema.basicBuilder(bridge).build();
    }

    public static TestSchema basic(CassandraBridge bridge, Consumer<Builder> configurer) {
        Builder builder = TestSchema.basicBuilder(bridge);
        configurer.accept(builder);
        return builder.build();
    }

    private TestSchema(Builder builder, @NotNull String keyspace, @NotNull String table, List<CqlField> partitionKeys, List<CqlField> clusteringKeys, List<CqlField> columns) {
        this.bridge = builder.bridge;
        this.quoteIdentifiers = builder.quoteIdentifiers;
        this.keyspace = keyspace;
        this.table = table;
        this.partitionKeys = partitionKeys;
        this.clusteringKeys = clusteringKeys;
        this.minCollectionSize = builder.minCollectionSize;
        this.blobSize = builder.blobSize;
        this.allFields = this.buildAllFields(partitionKeys, clusteringKeys, columns);
        this.fieldPositions = this.calculateFieldPositions(this.allFields);
        this.createStatement = this.buildCreateStatement(columns, builder.sortOrders, builder.withCompression, builder.ttlSecs);
        this.insertStatement = this.buildInsertStatement(columns, builder.insertFields);
        this.updateStatement = this.buildUpdateStatement();
        this.deleteStatement = this.buildDeleteStatement(builder.deleteFields);
        this.udts = this.getUdtsFromFields();
        this.withCdc = builder.withCdc;
    }

    @NotNull
    private Map<String, Integer> calculateFieldPositions(@NotNull List<CqlField> allFields) {
        return allFields.stream().collect(Collectors.toMap(CqlField::name, CqlField::position));
    }

    @NotNull
    private List<CqlField> buildAllFields(List<CqlField> partitionKeys, List<CqlField> clusteringKeys, List<CqlField> columns) {
        ArrayList<CqlField> allFields = new ArrayList<CqlField>(partitionKeys.size() + clusteringKeys.size() + columns.size());
        allFields.addAll(partitionKeys);
        allFields.addAll(clusteringKeys);
        allFields.addAll(columns);
        Collections.sort(allFields);
        return allFields;
    }

    @NotNull
    private Set<CqlField.CqlUdt> getUdtsFromFields() {
        return this.allFields.stream().map(field -> field.type().udts()).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private String buildDeleteStatement(@Nullable List<String> deleteFields) {
        StringBuilder deleteStmtBuilder = new StringBuilder().append("DELETE FROM ").append(this.maybeQuoteIdentifierIfRequested(this.keyspace)).append(".").append(this.maybeQuoteIdentifierIfRequested(this.table)).append(" WHERE ");
        if (deleteFields != null) {
            deleteStmtBuilder.append(deleteFields.stream().map(override -> override + " ?").collect(Collectors.joining(" AND ")));
        } else {
            deleteStmtBuilder.append(this.allFields.stream().map(field -> this.maybeQuoteIdentifierIfRequested(field.name()) + " = ?").collect(Collectors.joining(" AND ")));
        }
        return deleteStmtBuilder.append(";").toString();
    }

    private String buildUpdateStatement() {
        StringBuilder updateStmtBuilder = new StringBuilder("UPDATE ").append(this.maybeQuoteIdentifierIfRequested(this.keyspace)).append(".").append(this.maybeQuoteIdentifierIfRequested(this.table)).append(" SET ");
        updateStmtBuilder.append(this.allFields.stream().sorted().filter(field -> !field.isPartitionKey() && !field.isClusteringColumn()).map(field -> this.maybeQuoteIdentifierIfRequested(field.name()) + " = ?").collect(Collectors.joining(", ")));
        updateStmtBuilder.append(" WHERE ");
        updateStmtBuilder.append(this.allFields.stream().sorted().filter(field -> field.isPartitionKey() || field.isClusteringColumn()).map(field -> this.maybeQuoteIdentifierIfRequested(field.name()) + " = ?").collect(Collectors.joining(" AND ")));
        return updateStmtBuilder.append(";").toString();
    }

    private String buildInsertStatement(List<CqlField> columns, @Nullable List<String> insertOverrides) {
        StringBuilder insertStmtBuilder = new StringBuilder().append("INSERT INTO ").append(this.maybeQuoteIdentifierIfRequested(this.keyspace)).append(".").append(this.maybeQuoteIdentifierIfRequested(this.table)).append(" (");
        if (insertOverrides != null) {
            insertStmtBuilder.append(String.join((CharSequence)", ", insertOverrides)).append(") VALUES (").append(insertOverrides.stream().map(override -> "?").collect(Collectors.joining(", ")));
        } else {
            insertStmtBuilder.append(this.allFields.stream().sorted().map(cqlField -> this.maybeQuoteIdentifierIfRequested(cqlField.name())).collect(Collectors.joining(", "))).append(") VALUES (").append(Stream.of(this.partitionKeys, this.clusteringKeys, columns).flatMap(Collection::stream).sorted().map(field -> "?").collect(Collectors.joining(", ")));
        }
        return insertStmtBuilder.append(");").toString();
    }

    private String buildCreateStatement(List<CqlField> columns, List<CqlField.SortOrder> sortOrders, boolean withCompression, int ttlSecs) {
        StringBuilder createStmtBuilder = new StringBuilder().append("CREATE TABLE ").append(this.maybeQuoteIdentifierIfRequested(this.keyspace)).append(".").append(this.maybeQuoteIdentifierIfRequested(this.table)).append(" (");
        for (CqlField field : Stream.of(this.partitionKeys, this.clusteringKeys, columns).flatMap(Collection::stream).sorted().collect(Collectors.toList())) {
            createStmtBuilder.append(this.maybeQuoteIdentifierIfRequested(field.name())).append(" ").append(field.cqlTypeName()).append(field.isStaticColumn() ? " static" : "").append(", ");
        }
        createStmtBuilder.append("PRIMARY KEY((").append(this.partitionKeys.stream().map(cqlField -> this.maybeQuoteIdentifierIfRequested(cqlField.name())).collect(Collectors.joining(", "))).append(")");
        if (!this.clusteringKeys.isEmpty()) {
            createStmtBuilder.append(", ").append(this.clusteringKeys.stream().map(cqlField -> this.maybeQuoteIdentifierIfRequested(cqlField.name())).collect(Collectors.joining(", ")));
        }
        createStmtBuilder.append("))");
        createStmtBuilder.append(" WITH comment = 'test table'");
        if (!sortOrders.isEmpty()) {
            createStmtBuilder.append(" AND CLUSTERING ORDER BY (");
            for (int sortOrder = 0; sortOrder < sortOrders.size(); ++sortOrder) {
                createStmtBuilder.append(this.maybeQuoteIdentifierIfRequested(this.clusteringKeys.get(sortOrder).name())).append(" ").append(sortOrders.get(sortOrder).toString());
                if (sortOrder >= sortOrders.size() - 1) continue;
                createStmtBuilder.append(", ");
            }
            createStmtBuilder.append(")");
        }
        if (!withCompression) {
            createStmtBuilder.append(" AND compression = {'enabled':'false'}");
        }
        if (ttlSecs > 0) {
            createStmtBuilder.append(" AND default_time_to_live = " + ttlSecs);
        }
        return createStmtBuilder.append(";").toString();
    }

    public void setCassandraVersion(@NotNull CassandraVersion version) {
        this.version = version;
    }

    private String maybeQuoteIdentifierIfRequested(String identifier) {
        return this.quoteIdentifiers ? this.bridge.maybeQuoteIdentifier(identifier) : identifier;
    }

    public CqlTable buildTable() {
        return new CqlTable(this.keyspace, this.table, this.createStatement, this.rf, this.allFields, this.udts, 0);
    }

    public void writeSSTable(TemporaryDirectory directory, CassandraBridge bridge, Partitioner partitioner, Consumer<CassandraBridge.Writer> writer) {
        this.writeSSTable(directory.path(), bridge, partitioner, writer);
    }

    public void writeSSTable(Path directory, CassandraBridge bridge, Partitioner partitioner, Consumer<CassandraBridge.Writer> writer) {
        this.writeSSTable(directory, bridge, partitioner, false, writer);
    }

    public void writeSSTable(Path directory, CassandraBridge bridge, Partitioner partitioner, boolean upsert, Consumer<CassandraBridge.Writer> writer) {
        bridge.writeSSTable(partitioner, this.keyspace, this.table, directory, this.createStatement, this.insertStatement, this.updateStatement, upsert, this.udts, writer);
    }

    public void writeTombstoneSSTable(Path directory, CassandraBridge bridge, Partitioner partitioner, Consumer<CassandraBridge.Writer> writer) {
        bridge.writeTombstoneSSTable(partitioner, directory, this.createStatement, this.deleteStatement, writer);
    }

    public TestRow[] randomRows(int numRows) {
        TestRow[] testRows = new TestRow[numRows];
        for (int testRow = 0; testRow < testRows.length; ++testRow) {
            testRows[testRow] = this.randomRow();
        }
        return testRows;
    }

    public TestRow randomPartitionDelete() {
        return this.randomRow(field -> !field.isPartitionKey());
    }

    public TestRow randomRow() {
        return this.randomRow(false);
    }

    public TestRow randomRow(boolean nullifyValueColumn) {
        return this.randomRow(field -> nullifyValueColumn && field.isValueColumn());
    }

    private TestRow randomRow(Predicate<CqlField> nullifiedFields) {
        Object[] values = new Object[this.allFields.size()];
        for (CqlField field : this.allFields) {
            if (nullifiedFields.test(field)) {
                values[field.position()] = null;
                continue;
            }
            if (field.type().getClass().getSimpleName().equals("Blob") && this.blobSize != null) {
                values[field.position()] = RandomUtils.randomByteBuffer((int)this.blobSize);
                continue;
            }
            values[field.position()] = field.type().randomValue(this.minCollectionSize);
        }
        return new TestRow(values);
    }

    public TestRow toTestRow(InternalRow row, SparkSqlTypeConverter typeConverter) {
        if (row instanceof GenericInternalRow) {
            Object[] values = new Object[this.allFields.size()];
            for (CqlField field : this.allFields) {
                values[field.position()] = typeConverter.sparkSqlRowValue(field, (GenericInternalRow)row, field.position());
            }
            return new TestRow(values);
        }
        throw new IllegalStateException("Can only convert GenericInternalRow");
    }

    public TestRow toTestRow(org.apache.spark.sql.Row row, Set<String> requiredColumns, SparkSqlTypeConverter typeConverter) {
        Object[] values = new Object[requiredColumns != null ? requiredColumns.size() : this.allFields.size()];
        int skipped = 0;
        for (CqlField field : this.allFields) {
            if (requiredColumns != null && !requiredColumns.contains(field.name())) {
                ++skipped;
                continue;
            }
            int position = field.position() - skipped;
            values[position] = row.get(position) != null ? typeConverter.sparkSqlRowValue(field, row, position) : null;
        }
        return new TestRow(values);
    }

    public final class TestRow
    implements Row {
        private final Object[] values;
        private boolean isTombstoned;
        private boolean isInsert;
        private List<RangeTombstoneData> rangeTombstones;
        private int ttl;

        private TestRow(Object[] values) {
            this(values, false, true);
        }

        private TestRow(Object[] values, boolean isTombstoned, boolean isInsert) {
            this.values = values;
            this.isTombstoned = isTombstoned;
            this.isInsert = isInsert;
        }

        public void setRangeTombstones(List<RangeTombstoneData> rangeTombstones) {
            this.rangeTombstones = rangeTombstones;
        }

        public List<RangeTombstoneData> rangeTombstones() {
            return this.rangeTombstones;
        }

        public boolean isDeleted() {
            return this.isTombstoned;
        }

        public void delete() {
            this.isTombstoned = true;
        }

        public boolean isInsert() {
            return this.isInsert;
        }

        public void setTTL(int ttl) {
            this.ttl = ttl;
        }

        public int ttl() {
            return this.ttl;
        }

        public void fromUpdate() {
            this.isInsert = false;
        }

        public void fromInsert() {
            this.isInsert = true;
        }

        public TestRow copy(String field, Object value) {
            return this.copy(this.getFieldPosition(field), value);
        }

        public TestRow copy(int position, Object value) {
            Object[] newValues = new Object[this.values.length];
            System.arraycopy(this.values, 0, newValues, 0, this.values.length);
            newValues[position] = value;
            return new TestRow(newValues);
        }

        public TestRow withColumns(@Nullable Set<String> columns) {
            if (columns == null) {
                return this;
            }
            Object[] result = new Object[columns.size()];
            int skipped = 0;
            for (CqlField field : TestSchema.this.allFields) {
                if (!columns.contains(field.name())) {
                    ++skipped;
                    continue;
                }
                result[field.position() - skipped] = this.values[field.position()];
            }
            return new TestRow(result);
        }

        public Object[] rawValues(int start, int end) {
            assert (end <= this.values.length && start <= end) : String.format("start: %s, end: %s", TestSchema.this.version, start, end);
            Object[] result = new Object[end - start];
            System.arraycopy(this.values, start, result, 0, end - start);
            return result;
        }

        public Object[] allValues() {
            return this.values(0, this.values.length);
        }

        public Object[] values(int start, int end) {
            assert (TestSchema.this.version != null && start <= end && end <= this.values.length) : String.format("version: %s, start: %s, end: %s", TestSchema.this.version, start, end);
            Object[] result = new Object[end - start];
            int sourceIndex = start;
            int destinationIndex = 0;
            while (sourceIndex < end) {
                result[destinationIndex] = this.convertForCqlWriter(this.getType(sourceIndex), this.values[sourceIndex], false);
                ++sourceIndex;
                ++destinationIndex;
            }
            return result;
        }

        private Object convertForCqlWriter(CqlField.CqlType type, Object value, boolean isCollectionElement) {
            return type.convertForCqlWriter(value, TestSchema.this.version, isCollectionElement);
        }

        public CqlField.CqlType getType(int position) {
            if (0 <= position && position < TestSchema.this.allFields.size()) {
                return TestSchema.this.allFields.get(position).type();
            }
            throw new IllegalStateException("Unknown field at position: " + position);
        }

        public boolean isNull(String field) {
            return this.get(field) == null;
        }

        public String getString(String field) {
            return (String)this.get(field);
        }

        public UUID getUUID(String field) {
            return (UUID)this.get(field);
        }

        public Long getLong(String field) {
            return (Long)this.get(field);
        }

        public Integer getInteger(String field) {
            return (Integer)this.get(field);
        }

        public Object get(String field) {
            return this.get(this.getFieldPosition(field));
        }

        private int getFieldPosition(String field) {
            return Objects.requireNonNull(TestSchema.this.fieldPositions.get(field), "Unknown field: " + field);
        }

        public Object get(int position) {
            return this.values[position];
        }

        public boolean isTombstone() {
            return TestSchema.this.allFields.stream().filter(CqlField::isValueColumn).allMatch(field -> this.values[field.position()] == null);
        }

        public String getPartitionHexKey() {
            StringBuilder str = new StringBuilder();
            for (int key = 0; key < TestSchema.this.partitionKeys.size(); ++key) {
                CqlField.CqlType type = TestSchema.this.partitionKeys.get(key).type();
                str.append(ByteBufferUtils.toHexString((CqlField.CqlType)type, (Object)this.get(key))).append(':');
            }
            return str.toString();
        }

        public String getPrimaryHexKey() {
            StringBuilder str = new StringBuilder();
            for (int key = 0; key < TestSchema.this.partitionKeys.size() + TestSchema.this.clusteringKeys.size(); ++key) {
                CqlField.CqlType type = key < TestSchema.this.partitionKeys.size() ? TestSchema.this.partitionKeys.get(key).type() : TestSchema.this.clusteringKeys.get(key - TestSchema.this.partitionKeys.size()).type();
                str.append(ByteBufferUtils.toHexString((CqlField.CqlType)type, (Object)this.get(key))).append(':');
            }
            return str.toString();
        }

        public String toString() {
            return String.format("[%s]", IntStream.range(0, this.values.length).mapToObj(index -> ByteBufferUtils.toHexString((CqlField.CqlType)TestSchema.this.allFields.get(index).type(), (Object)this.values[index])).collect(Collectors.joining(", ")));
        }

        public int hashCode() {
            return Objects.hash(this.values);
        }

        public boolean equals(Object other) {
            return other instanceof TestRow && ComparisonUtils.equals((Object[])this.values, (Object[])((TestRow)other).values);
        }
    }

    public static class Builder {
        private final CassandraBridge bridge;
        private String keyspace = null;
        private String table = null;
        private final List<CqlField> partitionKeys = new ArrayList<CqlField>();
        private final List<CqlField> clusteringKeys = new ArrayList<CqlField>();
        private final List<CqlField> columns = new ArrayList<CqlField>();
        private final List<CqlField.SortOrder> sortOrders = new ArrayList<CqlField.SortOrder>();
        private List<String> insertFields = null;
        private List<String> deleteFields;
        private int minCollectionSize = 16;
        private Integer blobSize = null;
        private boolean withCompression = true;
        private boolean quoteIdentifiers = false;
        private int ttlSecs = 0;
        private boolean withCdc = false;

        public Builder(CassandraBridge bridge) {
            this.bridge = bridge;
        }

        public Builder withKeyspace(String keyspace) {
            this.keyspace = keyspace;
            return this;
        }

        public Builder withTable(String table) {
            this.table = table;
            return this;
        }

        public Builder withPartitionKey(String name, CqlField.CqlType type) {
            this.partitionKeys.add(new CqlField(true, false, false, name, type, 0));
            return this;
        }

        public Builder withClusteringKey(String name, CqlField.CqlType type) {
            this.clusteringKeys.add(new CqlField(false, true, false, name, type, 0));
            return this;
        }

        public Builder withStaticColumn(String name, CqlField.CqlType type) {
            this.columns.add(new CqlField(false, false, true, name, type, 0));
            return this;
        }

        public Builder withColumn(String name, CqlField.CqlType type) {
            this.columns.add(new CqlField(false, false, false, name, type, 0));
            return this;
        }

        public Builder withSortOrder(CqlField.SortOrder sortOrder) {
            this.sortOrders.add(sortOrder);
            return this;
        }

        public Builder withInsertFields(String ... fields) {
            this.insertFields = Arrays.asList(fields);
            return this;
        }

        public Builder withDeleteFields(String ... fields) {
            this.deleteFields = Arrays.asList(fields);
            return this;
        }

        public Builder withMinCollectionSize(int minCollectionSize) {
            this.minCollectionSize = minCollectionSize;
            return this;
        }

        public Builder withCompression(boolean withCompression) {
            this.withCompression = withCompression;
            return this;
        }

        public Builder withBlobSize(int blobSize) {
            this.blobSize = blobSize;
            return this;
        }

        public Builder withQuotedIdentifiers() {
            this.quoteIdentifiers = true;
            return this;
        }

        public Builder withTTL(int ttlSecs) {
            this.ttlSecs = ttlSecs;
            return this;
        }

        public Builder withCdc(boolean withCdc) {
            this.withCdc = withCdc;
            return this;
        }

        public TestSchema build() {
            if (!this.partitionKeys.isEmpty()) {
                return new TestSchema(this, (String)(this.keyspace != null ? this.keyspace : "keyspace_" + UUID.randomUUID().toString().replaceAll("-", "")), (String)(this.table != null ? this.table : "table_" + UUID.randomUUID().toString().replaceAll("-", "")), IntStream.range(0, this.partitionKeys.size()).mapToObj(index -> this.partitionKeys.get(index).cloneWithPosition(index)).sorted().collect(Collectors.toList()), IntStream.range(0, this.clusteringKeys.size()).mapToObj(index -> this.clusteringKeys.get(index).cloneWithPosition(this.partitionKeys.size() + index)).sorted().collect(Collectors.toList()), IntStream.range(0, this.columns.size()).mapToObj(index -> this.columns.get(index).cloneWithPosition(this.partitionKeys.size() + this.clusteringKeys.size() + index)).sorted(Comparator.comparing(CqlField::name)).collect(Collectors.toList()));
            }
            throw new IllegalArgumentException("Need at least one partition key");
        }
    }
}

