/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter;

import com.google.common.collect.Range;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.concurrent.ExecutorService;
import org.apache.cassandra.spark.bulkwriter.BulkSparkConf;
import org.apache.cassandra.spark.bulkwriter.BulkWriterContext;
import org.apache.cassandra.spark.bulkwriter.DirectDataTransferApi;
import org.apache.cassandra.spark.bulkwriter.RingInstance;
import org.apache.cassandra.spark.bulkwriter.SortedSSTableWriter;
import org.apache.cassandra.spark.bulkwriter.StreamSession;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.CloudStorageDataTransferApi;
import org.apache.cassandra.spark.bulkwriter.token.ReplicaAwareFailureHandler;
import org.apache.cassandra.spark.transports.storage.extensions.StorageTransportConfiguration;
import org.apache.cassandra.spark.transports.storage.extensions.StorageTransportExtension;
import org.jetbrains.annotations.NotNull;

public interface TransportContext {
    public StreamSession<? extends TransportContext> createStreamSession(BulkWriterContext var1, String var2, SortedSSTableWriter var3, Range<BigInteger> var4, ReplicaAwareFailureHandler<RingInstance> var5, ExecutorService var6);

    default public void close() {
    }

    public static interface TransportContextProvider
    extends Serializable {
        public TransportContext createContext(@NotNull BulkWriterContext var1, @NotNull BulkSparkConf var2, boolean var3);
    }

    public static interface CloudStorageTransportContext
    extends TransportContext {
        @NotNull
        public CloudStorageDataTransferApi dataTransferApi();

        @NotNull
        public StorageTransportConfiguration transportConfiguration();

        @NotNull
        public StorageTransportExtension transportExtensionImplementation();
    }

    public static interface DirectDataBulkWriterContext
    extends TransportContext {
        public DirectDataTransferApi dataTransferApi();
    }
}

