/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter.cloudstorage.coordinated;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.RateLimiter;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import o.a.c.sidecar.client.shaded.client.RequestContext;
import o.a.c.sidecar.client.shaded.client.SidecarClient;
import o.a.c.sidecar.client.shaded.client.SidecarInstance;
import o.a.c.sidecar.client.shaded.client.retry.RetryPolicy;
import o.a.c.sidecar.client.shaded.common.data.RestoreJobProgressFetchPolicy;
import o.a.c.sidecar.client.shaded.common.request.CreateRestoreJobSliceRequest;
import o.a.c.sidecar.client.shaded.common.request.Request;
import o.a.c.sidecar.client.shaded.common.request.data.CreateRestoreJobRequestPayload;
import o.a.c.sidecar.client.shaded.common.request.data.CreateSliceRequestPayload;
import o.a.c.sidecar.client.shaded.common.request.data.RestoreJobProgressRequestParams;
import o.a.c.sidecar.client.shaded.common.request.data.UpdateRestoreJobRequestPayload;
import o.a.c.sidecar.client.shaded.common.response.data.RestoreJobProgressResponsePayload;
import o.a.c.sidecar.client.shaded.common.response.data.RestoreJobSummaryResponsePayload;
import org.apache.cassandra.spark.bulkwriter.JobInfo;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.Bundle;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.BundleStorageObject;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.CloudStorageDataTransferApi;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.CloudStorageDataTransferApiImpl;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.coordinated.CoordinatedCloudStorageDataTransferApiExtension;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.coordinated.MultiClusterContainer;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.coordinated.MultiClusterSupport;
import org.apache.cassandra.spark.data.QualifiedTableName;
import org.apache.cassandra.spark.exception.S3ApiCallException;
import org.apache.cassandra.spark.exception.SidecarApiCallException;
import org.apache.cassandra.spark.transports.storage.StorageCredentials;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoordinatedCloudStorageDataTransferApi
implements CloudStorageDataTransferApi,
CoordinatedCloudStorageDataTransferApiExtension,
MultiClusterSupport<CloudStorageDataTransferApiImpl> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CoordinatedCloudStorageDataTransferApi.class);
    private final MultiClusterContainer<CloudStorageDataTransferApiImpl> dataTransferApis = new MultiClusterContainer();
    private final RateLimiter sidecarApiCallRateLimiter;

    public CoordinatedCloudStorageDataTransferApi(@NotNull Map<String, CloudStorageDataTransferApiImpl> dataTransferApiByCluster) {
        this(RateLimiter.create((double)1.0), dataTransferApiByCluster);
    }

    @VisibleForTesting
    public CoordinatedCloudStorageDataTransferApi(RateLimiter sidecarApiCallRateLimiter, @NotNull Map<String, CloudStorageDataTransferApiImpl> dataTransferApiByCluster) {
        Preconditions.checkArgument((!dataTransferApiByCluster.isEmpty() ? 1 : 0) != 0, (Object)"dataTransferApiByCluster cannot be empty");
        this.dataTransferApis.addAll(dataTransferApiByCluster);
        this.sidecarApiCallRateLimiter = sidecarApiCallRateLimiter;
    }

    @Override
    public int size() {
        return this.dataTransferApis.size();
    }

    @Override
    public void forEach(BiConsumer<String, CloudStorageDataTransferApiImpl> action) {
        Predicate<String> allowAllClusters = id -> false;
        this.forEachInternal(allowAllClusters, action);
    }

    @Override
    public BundleStorageObject uploadBundle(StorageCredentials writeCredentials, Bundle bundle) throws S3ApiCallException {
        return this.dataTransferApis.getAnyValueOrThrow().uploadBundle(writeCredentials, bundle);
    }

    @Override
    public RestoreJobSummaryResponsePayload restoreJobSummary() throws SidecarApiCallException {
        return this.dataTransferApis.getAnyValueOrThrow().restoreJobSummary();
    }

    @Override
    public void updateRestoreJob(UpdateRestoreJobRequestPayload updateRestoreJobRequestPayload) throws SidecarApiCallException {
        this.forEachInternal(api -> api.updateRestoreJob(updateRestoreJobRequestPayload));
    }

    @Override
    public void abortRestoreJob() throws SidecarApiCallException {
        this.forEachInternal(CloudStorageDataTransferApiImpl::abortRestoreJob);
    }

    @Override
    public void createRestoreSliceFromExecutor(String clusterId, CreateSliceRequestPayload createSliceRequestPayload) throws SidecarApiCallException {
        this.createRestoreSliceInternal(clusterId, (CloudStorageDataTransferApiImpl)this.dataTransferApis.getValueOrThrow(clusterId), createSliceRequestPayload);
    }

    @Override
    public void restoreJobProgress(RestoreJobProgressFetchPolicy fetchPolicy, Predicate<String> shouldSkipCluster, BiConsumer<String, RestoreJobProgressResponsePayload> progressHandler) throws SidecarApiCallException {
        this.forEachInternal(shouldSkipCluster, (clusterId, dataTransferApi) -> this.restoreJobProgressInternal((String)clusterId, (CloudStorageDataTransferApiImpl)dataTransferApi, fetchPolicy, progressHandler));
    }

    @Override
    @Nullable
    public CloudStorageDataTransferApiImpl getValueOrNull(@NotNull String clusterId) {
        return this.dataTransferApis.getValueOrNull(clusterId);
    }

    @Override
    public void createRestoreJob(CreateRestoreJobRequestPayload createRestoreJobRequestPayload) throws SidecarApiCallException {
        throw new UnsupportedOperationException("Not supported for coordinated write");
    }

    @Override
    public void createRestoreSliceFromExecutor(SidecarInstance sidecarInstance, CreateSliceRequestPayload createSliceRequestPayload) throws SidecarApiCallException {
        throw new UnsupportedOperationException("Not supported for coordinated write");
    }

    @Override
    public CompletableFuture<Void> createRestoreSliceFromDriver(SidecarInstance sidecarInstance, CreateSliceRequestPayload createSliceRequestPayload) {
        throw new UnsupportedOperationException("Not supported for coordinated write");
    }

    private void createRestoreSliceInternal(String clusterId, CloudStorageDataTransferApiImpl dataTransferApi, CreateSliceRequestPayload createSliceRequestPayload) throws SidecarApiCallException {
        JobInfo jobInfo = dataTransferApi.jobInfo();
        SidecarClient sidecarClient = dataTransferApi.sidecarClient();
        QualifiedTableName qualifiedTableName = jobInfo.qualifiedTableName();
        UUID restoreJobId = jobInfo.getRestoreJobId(clusterId);
        CreateRestoreJobSliceRequest request = new CreateRestoreJobSliceRequest(qualifiedTableName.keyspace(), qualifiedTableName.table(), restoreJobId, createSliceRequestPayload);
        CloudStorageDataTransferApiImpl.ExecutorCreateSliceRetryPolicy retryPolicy = new CloudStorageDataTransferApiImpl.ExecutorCreateSliceRetryPolicy(sidecarClient);
        RequestContext requestContext = sidecarClient.requestBuilder().retryPolicy((RetryPolicy)retryPolicy).request((Request)request).build();
        try {
            sidecarClient.executeRequestAsync(requestContext).get();
        }
        catch (Exception exception) {
            this.handleInterruption(exception);
            throw new SidecarApiCallException("Failed to create restore job slice. restoreJobId=" + String.valueOf(restoreJobId) + " sliceId=" + createSliceRequestPayload.sliceId(), (Throwable)exception);
        }
    }

    private void restoreJobProgressInternal(String clusterId, CloudStorageDataTransferApiImpl dataTransferApi, RestoreJobProgressFetchPolicy fetchPolicy, BiConsumer<String, RestoreJobProgressResponsePayload> progressHandler) {
        JobInfo jobInfo = dataTransferApi.jobInfo();
        QualifiedTableName qualifiedTableName = jobInfo.qualifiedTableName();
        UUID restoreJobId = jobInfo.getRestoreJobId(clusterId);
        RestoreJobProgressRequestParams requestParams = new RestoreJobProgressRequestParams(qualifiedTableName.keyspace(), qualifiedTableName.table(), restoreJobId, fetchPolicy);
        RestoreJobProgressResponsePayload jobProgress = this.restoreJobProgress(dataTransferApi, requestParams);
        progressHandler.accept(clusterId, jobProgress);
    }

    private void forEachInternal(Consumer<CloudStorageDataTransferApiImpl> dataTransferApiConsumer) {
        this.forEach((String ignored, CloudStorageDataTransferApiImpl api) -> dataTransferApiConsumer.accept((CloudStorageDataTransferApiImpl)api));
    }

    private void forEachInternal(Predicate<String> shouldSkipCluster, BiConsumer<String, CloudStorageDataTransferApiImpl> dataTransferApiAction) {
        this.dataTransferApis.forEach((String clusterId, T dataTransferApi) -> {
            if (shouldSkipCluster.test((String)clusterId)) {
                LOGGER.debug("Cluster is skipped according to clusterIdFilter. clusterId={}", clusterId);
                return;
            }
            this.sidecarApiCallRateLimiter.acquire(1);
            try {
                dataTransferApiAction.accept((String)clusterId, (CloudStorageDataTransferApiImpl)dataTransferApi);
            }
            catch (SidecarApiCallException exception) {
                LOGGER.error("Fails to call Sidecar. clusterId={}", clusterId, (Object)exception);
                throw exception;
            }
        });
    }

    @VisibleForTesting
    RestoreJobProgressResponsePayload restoreJobProgress(CloudStorageDataTransferApiImpl dataTransferApi, RestoreJobProgressRequestParams requestParams) {
        try {
            return (RestoreJobProgressResponsePayload)dataTransferApi.sidecarClient().restoreJobProgress(requestParams).get();
        }
        catch (Exception exception) {
            this.handleInterruption(exception);
            throw new SidecarApiCallException("Failed to retrieve job progress. restoreJobId=" + String.valueOf(requestParams.jobId), (Throwable)exception);
        }
    }
}

