/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.querybuilder.condition;

import com.datastax.oss.driver.api.querybuilder.condition.Condition;
import com.datastax.oss.driver.api.querybuilder.condition.ConditionBuilder;
import com.datastax.oss.driver.api.querybuilder.condition.ConditionalStatement;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import com.datastax.oss.driver.internal.querybuilder.condition.DefaultCondition;
import com.datastax.oss.driver.internal.querybuilder.lhs.LeftOperand;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import net.jcip.annotations.Immutable;

@Immutable
public class DefaultConditionBuilder
implements ConditionBuilder<Condition> {
    private final LeftOperand leftOperand;

    public DefaultConditionBuilder(@NonNull LeftOperand leftOperand) {
        this.leftOperand = leftOperand;
    }

    @Override
    @NonNull
    public Condition build(@NonNull String operator, @Nullable Term rightOperand) {
        return new DefaultCondition(this.leftOperand, operator, rightOperand);
    }

    @Immutable
    public static class Fluent<StatementT extends ConditionalStatement<StatementT>>
    implements ConditionBuilder<StatementT> {
        private final ConditionalStatement<StatementT> statement;
        private final ConditionBuilder<Condition> delegate;

        public Fluent(@NonNull ConditionalStatement<StatementT> statement, @NonNull LeftOperand leftOperand) {
            this.statement = statement;
            this.delegate = new DefaultConditionBuilder(leftOperand);
        }

        @Override
        @NonNull
        public StatementT build(@NonNull String operator, @Nullable Term rightOperand) {
            return this.statement.if_((Condition)this.delegate.build(operator, rightOperand));
        }
    }
}

