/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.cdc;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.vertx.core.Promise;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.cassandra.sidecar.cdc.CdcConfig;
import org.apache.cassandra.sidecar.common.server.ThrowingRunnable;
import org.apache.cassandra.sidecar.common.server.utils.DurationSpec;
import org.apache.cassandra.sidecar.common.server.utils.MillisecondBoundConfiguration;
import org.apache.cassandra.sidecar.common.server.utils.SecondBoundConfiguration;
import org.apache.cassandra.sidecar.config.CdcConfiguration;
import org.apache.cassandra.sidecar.config.SchemaKeyspaceConfiguration;
import org.apache.cassandra.sidecar.config.SidecarConfiguration;
import org.apache.cassandra.sidecar.db.CdcConfigAccessor;
import org.apache.cassandra.sidecar.db.KafkaConfigAccessor;
import org.apache.cassandra.sidecar.tasks.PeriodicTask;
import org.apache.cassandra.sidecar.tasks.PeriodicTaskExecutor;
import org.apache.cassandra.sidecar.tasks.ScheduleDecision;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class CdcConfigImpl
implements CdcConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(CdcConfigImpl.class);
    private static final int DEFAULT_MAX_WATERMARKER_SIZE = 400000;
    private static final String DEFAULT_JOB_ID = "test-job-id";
    private static final int DEFAULT_MAX_COMMITLOGS_PER_INSTANCE = 4;
    private static final int DEFAULT_MAX_RECORD_BYTE_SIZE = -1;
    public static final int DEFAULT_WATERMARK_WINDOW = 259200;
    private final SchemaKeyspaceConfiguration schemaKeyspaceConfiguration;
    private final CdcConfiguration cdcConfiguration;
    private final CdcConfigAccessor cdcConfigAccessor;
    private final KafkaConfigAccessor kafkaConfigAccessor;
    private final List<ThrowingRunnable> configChangeListeners = Collections.synchronizedList(new ArrayList());
    private final ConfigRefreshNotifier configRefreshNotifier;
    private volatile Map<String, String> kafkaConfigMappings = Map.of();
    private volatile Map<String, String> cdcConfigMappings = Map.of();

    @Inject
    public CdcConfigImpl(SidecarConfiguration sidecarConfiguration, CdcConfigAccessor cdcConfigAccessor, KafkaConfigAccessor kafkaConfigAccessor, PeriodicTaskExecutor periodicTaskExecutor) {
        this.schemaKeyspaceConfiguration = sidecarConfiguration.serviceConfiguration().schemaKeyspaceConfiguration();
        this.cdcConfiguration = sidecarConfiguration.serviceConfiguration().cdcConfiguration();
        this.cdcConfigAccessor = cdcConfigAccessor;
        this.kafkaConfigAccessor = kafkaConfigAccessor;
        if (this.schemaKeyspaceConfiguration.isEnabled()) {
            this.configRefreshNotifier = new ConfigRefreshNotifier();
            periodicTaskExecutor.schedule(this.configRefreshNotifier);
        } else {
            this.configRefreshNotifier = null;
        }
    }

    @Override
    public Map<String, Object> kafkaConfigs() {
        HashMap<String, Object> kafkaConfigs = new HashMap<String, Object>();
        kafkaConfigs.putAll(this.getAuthConfigs());
        kafkaConfigs.putAll(this.kafkaConfigMappings);
        return ImmutableMap.copyOf(kafkaConfigs);
    }

    @Override
    public Map<String, Object> cdcConfigs() {
        return ImmutableMap.copyOf(this.cdcConfigMappings);
    }

    @Override
    public boolean isConfigReady() {
        return this.cdcConfigAccessor.isAvailable() && !this.kafkaConfigMappings.isEmpty() && !this.cdcConfigMappings.isEmpty();
    }

    @Override
    public String kafkaTopic() {
        return this.cdcConfigMappings.get(ConfigKeys.TOPIC.lowcaseName);
    }

    @Override
    @NotNull
    public CdcConfig.TopicFormatType topicFormat() {
        return CdcConfig.TopicFormatType.valueOf(this.cdcConfigMappings.getOrDefault(ConfigKeys.TOPIC_FORMAT_TYPE.lowcaseName, CdcConfig.TopicFormatType.STATIC.name()));
    }

    @Override
    public boolean cdcEnabled() {
        return Boolean.parseBoolean(this.cdcConfigMappings.getOrDefault(ConfigKeys.CDC_ENABLED.lowcaseName, "true"));
    }

    @Override
    public String jobId() {
        return this.cdcConfigMappings.getOrDefault(ConfigKeys.JOBID.lowcaseName, DEFAULT_JOB_ID);
    }

    @Override
    public boolean logOnly() {
        return this.getBool(ConfigKeys.LOG_ONLY.lowcaseName, false);
    }

    @Override
    public boolean persistEnabled() {
        return this.getBool(ConfigKeys.PERSIST_STATE.lowcaseName, true);
    }

    @Override
    public boolean failOnRecordTooLargeError() {
        return this.getBool(ConfigKeys.FAIL_KAFKA_TOO_LARGE_ERRORS.lowcaseName, false);
    }

    @Override
    public boolean failOnKafkaError() {
        return this.getBool(ConfigKeys.FAIL_KAFKA_ERRORS.lowcaseName, true);
    }

    @Override
    public MillisecondBoundConfiguration persistDelay() {
        return new MillisecondBoundConfiguration((long)this.getInt(ConfigKeys.PERSIST_DELAY_MILLIS.lowcaseName, 1000), TimeUnit.MILLISECONDS);
    }

    @Override
    public String datacenter() {
        return this.cdcConfigMappings.get(ConfigKeys.DATACENTER.lowcaseName);
    }

    @Override
    public SecondBoundConfiguration watermarkWindow() {
        return new SecondBoundConfiguration((long)this.getInt(ConfigKeys.WATERMARK_SECONDS.lowcaseName, 259200), TimeUnit.SECONDS);
    }

    @Override
    public int maxRecordSizeBytes() {
        return -1;
    }

    @Override
    @Nullable
    public String compression() {
        return null;
    }

    @Override
    public MillisecondBoundConfiguration minDelayBetweenMicroBatches() {
        long millis = Long.parseLong(this.cdcConfigMappings.getOrDefault(ConfigKeys.MICRO_BATCH_DELAY_MILLIS.lowcaseName, "1000"));
        return new MillisecondBoundConfiguration(millis, TimeUnit.MILLISECONDS);
    }

    @Override
    public String env() {
        return this.cdcConfigMappings.getOrDefault(ConfigKeys.ENV.lowcaseName, "");
    }

    @Override
    public int maxCommitLogsPerInstance() {
        return this.getInt(ConfigKeys.MAX_COMMIT_LOGS.lowcaseName, 4);
    }

    @Override
    public int maxWatermarkerSize() {
        return this.getInt(ConfigKeys.MAX_WATERMARKER_SIZE.lowcaseName, 400000);
    }

    protected boolean getBool(String key, boolean orDefault) {
        String bool = this.cdcConfigMappings.get(key);
        return bool != null ? Boolean.parseBoolean(bool) : orDefault;
    }

    protected int getInt(String key, int orDefault) {
        return this.getInt(key, () -> orDefault);
    }

    protected int getInt(String key, Supplier<Integer> orDefault) {
        String aInt = this.cdcConfigMappings.get(key);
        return aInt != null ? Integer.valueOf(aInt) : orDefault.get();
    }

    public void registerConfigChangeListener(ThrowingRunnable listener) {
        this.configChangeListeners.add(listener);
    }

    private Map<String, Object> getAuthConfigs() {
        return new HashMap<String, Object>();
    }

    @VisibleForTesting
    void forceExecuteNotifier() {
        if (this.configRefreshNotifier != null && this.configRefreshNotifier.scheduleDecision() == ScheduleDecision.EXECUTE) {
            this.configRefreshNotifier.execute((Promise<Void>)Promise.promise());
        }
    }

    @VisibleForTesting
    ConfigRefreshNotifier configRefreshNotifier() {
        return this.configRefreshNotifier;
    }

    static enum ConfigKeys {
        DATACENTER,
        LOG_ONLY,
        PERSIST_STATE,
        ENV,
        TOPIC,
        TOPIC_FORMAT_TYPE,
        CDC_ENABLED,
        JOBID,
        WATERMARK_SECONDS,
        MICRO_BATCH_DELAY_MILLIS,
        MAX_COMMIT_LOGS,
        MAX_WATERMARKER_SIZE,
        FAIL_KAFKA_ERRORS,
        FAIL_KAFKA_TOO_LARGE_ERRORS,
        PERSIST_DELAY_MILLIS;

        private final String lowcaseName = this.name().toLowerCase();
    }

    class ConfigRefreshNotifier
    implements PeriodicTask {
        ConfigRefreshNotifier() {
        }

        @Override
        public DurationSpec delay() {
            return CdcConfigImpl.this.cdcConfiguration.cdcConfigRefreshTime();
        }

        @Override
        public void execute(Promise<Void> promise) {
            for (ThrowingRunnable listener : CdcConfigImpl.this.configChangeListeners) {
                try {
                    listener.run();
                }
                catch (Throwable e) {
                    LOGGER.error("There was an error with callback {}", (Object)listener, (Object)e);
                }
            }
            promise.tryComplete();
        }

        @Override
        public ScheduleDecision scheduleDecision() {
            Map<String, String> newCdcConfigMappings;
            Map<String, String> newKafkaConfigMappings;
            if (!CdcConfigImpl.this.schemaKeyspaceConfiguration.isEnabled() || !CdcConfigImpl.this.cdcConfiguration.isEnabled()) {
                LOGGER.trace("Skipping config refreshing");
                return ScheduleDecision.SKIP;
            }
            try {
                newKafkaConfigMappings = CdcConfigImpl.this.kafkaConfigAccessor.getConfig().getConfigs();
                newCdcConfigMappings = CdcConfigImpl.this.cdcConfigAccessor.getConfig().getConfigs();
            }
            catch (Throwable e) {
                LOGGER.error("Failed to access cdc/kafka configs", e);
                return ScheduleDecision.SKIP;
            }
            boolean shouldSkip = true;
            if (!newKafkaConfigMappings.equals(CdcConfigImpl.this.kafkaConfigMappings)) {
                shouldSkip = false;
                CdcConfigImpl.this.kafkaConfigMappings = newKafkaConfigMappings;
            }
            if (!newCdcConfigMappings.equals(CdcConfigImpl.this.cdcConfigMappings)) {
                shouldSkip = false;
                CdcConfigImpl.this.cdcConfigMappings = newCdcConfigMappings;
            }
            return shouldSkip ? ScheduleDecision.SKIP : ScheduleDecision.EXECUTE;
        }
    }
}

