/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.db;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.vertx.ext.auth.authorization.Authorization;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.cassandra.sidecar.acl.authorization.PermissionFactory;
import org.apache.cassandra.sidecar.common.server.CQLSessionProvider;
import org.apache.cassandra.sidecar.db.DatabaseAccessor;
import org.apache.cassandra.sidecar.db.schema.SidecarSchema;
import org.apache.cassandra.sidecar.db.schema.SystemAuthSchema;
import org.apache.cassandra.sidecar.db.schema.TableSchema;
import org.jetbrains.annotations.VisibleForTesting;

@Singleton
public class SystemAuthDatabaseAccessor
extends DatabaseAccessor<SystemAuthSchema> {
    private final PermissionFactory permissionFactory;

    @Inject
    public SystemAuthDatabaseAccessor(SidecarSchema sidecarSchema, CQLSessionProvider sessionProvider, PermissionFactory permissionFactory) {
        this(sidecarSchema.tableSchema(SystemAuthSchema.class), sessionProvider, permissionFactory);
    }

    @VisibleForTesting
    public SystemAuthDatabaseAccessor(SystemAuthSchema systemAuthSchema, CQLSessionProvider sessionProvider, PermissionFactory permissionFactory) {
        super((TableSchema)systemAuthSchema, sessionProvider);
        this.permissionFactory = permissionFactory;
    }

    public String findRoleFromIdentity(String identity) {
        BoundStatement statement = ((SystemAuthSchema)this.tableSchema).roleFromIdentity().bind(new Object[]{identity});
        ResultSet result = this.execute((Statement)statement);
        Row row = result.one();
        return row != null ? row.getString("role") : null;
    }

    public Map<String, String> findAllIdentityToRoles() {
        BoundStatement statement = ((SystemAuthSchema)this.tableSchema).allRolesAndIdentities().bind();
        ResultSet resultSet = this.execute((Statement)statement);
        HashMap<String, String> results = new HashMap<String, String>();
        for (Row row : resultSet) {
            results.put(row.getString("identity"), row.getString("role"));
        }
        return results;
    }

    public Map<String, Set<Authorization>> findAllRolesAndPermissions() {
        BoundStatement statement = ((SystemAuthSchema)this.tableSchema).allRolesAndPermissions().bind();
        ResultSet result = this.execute((Statement)statement);
        HashMap<String, Set<Authorization>> roleAuthorizations = new HashMap<String, Set<Authorization>>();
        for (Row row : result) {
            String role = row.getString("role");
            String resource = row.getString("resource");
            Set permissions = row.getSet("permissions", String.class);
            HashSet<Authorization> authorizations = new HashSet<Authorization>();
            for (String permission : permissions) {
                try {
                    authorizations.add(this.permissionFactory.createPermission(permission).toAuthorization(resource));
                }
                catch (Exception e) {
                    this.logger.error("Error parsing Cassandra permission={} resource={} role={}", new Object[]{permission, resource, role, e});
                }
            }
            roleAuthorizations.computeIfAbsent(role, k -> new HashSet()).addAll(authorizations);
        }
        return roleAuthorizations;
    }

    public boolean isSuperUser(String role) {
        SimpleStatement statement = new SimpleStatement(String.format(((SystemAuthSchema)this.tableSchema).unpreparedListRoles(), role));
        ResultSet result = this.execute((Statement)statement);
        for (Row row : result) {
            if (!row.getBool("super")) continue;
            return true;
        }
        return false;
    }

    public Map<String, Boolean> findAllRolesToSuperuserStatus() {
        BoundStatement statement = ((SystemAuthSchema)this.tableSchema).allRoles().bind();
        ResultSet result = this.execute((Statement)statement);
        List rows = result.all();
        Map<String, Boolean> roleToSuperUser = rows.stream().collect(Collectors.toMap(row -> row.getString("role"), row -> row.getBool("is_superuser")));
        for (Row row2 : rows) {
            Set memberOf;
            if (roleToSuperUser.get(row2.getString("role")).booleanValue() || (memberOf = row2.getSet("member_of", String.class)) == null || memberOf.isEmpty()) continue;
            if (!memberOf.stream().anyMatch(roleToSuperUser::get)) continue;
            roleToSuperUser.put(row2.getString("role"), true);
        }
        return roleToSuperUser;
    }
}

