/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.oauth2;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.impl.JsonUtil;
import io.vertx.ext.auth.oauth2.OAuth2AuthorizationURL;
import java.util.ArrayList;
import java.util.Base64;
import java.util.LinkedHashMap;
import java.util.Map;

public class OAuth2AuthorizationURLConverter {
    private static final Base64.Decoder BASE64_DECODER = JsonUtil.BASE64_DECODER;
    private static final Base64.Encoder BASE64_ENCODER = JsonUtil.BASE64_ENCODER;

    static void fromJson(Iterable<Map.Entry<String, Object>> json, OAuth2AuthorizationURL obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "additionalParameters": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof String) {
                            map.put((String)entry.getKey(), (String)entry.getValue());
                        }
                    });
                    obj.setAdditionalParameters(map);
                    break;
                }
                case "redirectUri": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setRedirectUri((String)member.getValue());
                    break;
                }
                case "scopes": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<String> list = new ArrayList<String>();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            list.add((String)item);
                        }
                    });
                    obj.setScopes(list);
                    break;
                }
                case "state": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setState((String)member.getValue());
                }
            }
        }
    }

    static void toJson(OAuth2AuthorizationURL obj, JsonObject json) {
        OAuth2AuthorizationURLConverter.toJson(obj, json.getMap());
    }

    static void toJson(OAuth2AuthorizationURL obj, Map<String, Object> json) {
        if (obj.getAdditionalParameters() != null) {
            JsonObject map = new JsonObject();
            obj.getAdditionalParameters().forEach((key, value) -> map.put(key, value));
            json.put("additionalParameters", map);
        }
        if (obj.getRedirectUri() != null) {
            json.put("redirectUri", obj.getRedirectUri());
        }
        if (obj.getScopes() != null) {
            JsonArray array = new JsonArray();
            obj.getScopes().forEach(item -> array.add(item));
            json.put("scopes", array);
        }
        if (obj.getState() != null) {
            json.put("state", obj.getState());
        }
    }
}

