/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.plugin.flink.buffer;

import org.apache.flink.runtime.io.network.buffer.Buffer;

public class BufferHeader {
    private final Buffer.DataType dataType;
    private final boolean isCompressed;
    private int subPartitionId;
    private int attemptId;
    private int nextBatchId;
    private int totalLength;
    private final int size;

    public BufferHeader(Buffer.DataType dataType, boolean isCompressed, int size) {
        this(0, 0, 0, size + 2, dataType, isCompressed, size);
    }

    public BufferHeader(int subPartitionId, Buffer.DataType dataType, boolean isCompressed, int size) {
        this(subPartitionId, 0, 0, size + 2, dataType, isCompressed, size);
    }

    public BufferHeader(int subPartitionId, int attemptId, int nextBatchId, int totalLength, Buffer.DataType dataType, boolean isCompressed, int size) {
        this.subPartitionId = subPartitionId;
        this.attemptId = attemptId;
        this.nextBatchId = nextBatchId;
        this.totalLength = totalLength;
        this.dataType = dataType;
        this.isCompressed = isCompressed;
        this.size = size;
    }

    public int getSubPartitionId() {
        return this.subPartitionId;
    }

    public Buffer.DataType getDataType() {
        return this.dataType;
    }

    public boolean isCompressed() {
        return this.isCompressed;
    }

    public int getSize() {
        return this.size;
    }
}

