/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.plugin.flink.buffer;

import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Queue;
import org.apache.celeborn.plugin.flink.buffer.BufferHeader;
import org.apache.celeborn.plugin.flink.utils.BufferUtils;
import org.apache.celeborn.plugin.flink.utils.Utils;
import org.apache.celeborn.reflect.DynMethods;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferRecycler;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBuf;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBufAllocator;
import org.apache.flink.shaded.netty4.io.netty.buffer.CompositeByteBuf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BufferPacker {
    private static Logger logger = LoggerFactory.getLogger(BufferPacker.class);
    protected final BiConsumerWithException<ByteBuf, BufferHeader, InterruptedException> ripeBufferHandler;
    protected Buffer cachedBuffer;
    protected int currentSubIdx = -1;

    public BufferPacker(BiConsumerWithException<ByteBuf, BufferHeader, InterruptedException> ripeBufferHandler) {
        this.ripeBufferHandler = ripeBufferHandler;
    }

    public void process(Buffer buffer, int subIdx) throws InterruptedException {
        if (buffer == null) {
            return;
        }
        if (buffer.readableBytes() == 0) {
            buffer.recycleBuffer();
            return;
        }
        if (this.cachedBuffer == null) {
            this.cachedBuffer = buffer;
            this.currentSubIdx = subIdx;
        } else if (this.currentSubIdx != subIdx) {
            Buffer dumpedBuffer = this.cachedBuffer;
            this.cachedBuffer = buffer;
            int targetSubIdx = this.currentSubIdx;
            this.currentSubIdx = subIdx;
            this.logBufferPack(false, dumpedBuffer.getDataType(), dumpedBuffer.readableBytes());
            this.handleRipeBuffer(dumpedBuffer, targetSubIdx, dumpedBuffer.getDataType(), dumpedBuffer.isCompressed());
        } else if (this.cachedBuffer.readableBytes() + buffer.readableBytes() - 16 <= this.cachedBuffer.getMaxCapacity()) {
            this.cachedBuffer.asByteBuf().writeBytes(buffer.asByteBuf(), 16, buffer.readableBytes() - 16);
            this.logBufferPack(false, buffer.getDataType(), buffer.readableBytes() - 16);
            buffer.recycleBuffer();
        } else {
            Buffer dumpedBuffer = this.cachedBuffer;
            this.cachedBuffer = buffer;
            this.logBufferPack(false, dumpedBuffer.getDataType(), dumpedBuffer.readableBytes());
            this.handleRipeBuffer(dumpedBuffer, this.currentSubIdx, dumpedBuffer.getDataType(), dumpedBuffer.isCompressed());
        }
    }

    protected void logBufferPack(boolean isDrain, Buffer.DataType dataType, int length) {
        logger.debug("isDrain:{}, cachedBuffer pack partition:{} type:{}, length:{}", new Object[]{isDrain, this.currentSubIdx, dataType, length});
    }

    public void drain() throws InterruptedException {
        if (this.cachedBuffer != null) {
            this.logBufferPack(true, this.cachedBuffer.getDataType(), this.cachedBuffer.readableBytes());
            this.handleRipeBuffer(this.cachedBuffer, this.currentSubIdx, this.cachedBuffer.getDataType(), this.cachedBuffer.isCompressed());
        }
        this.cachedBuffer = null;
        this.currentSubIdx = -1;
    }

    protected void handleRipeBuffer(Buffer buffer, int subIdx, Buffer.DataType dataType, boolean isCompressed) throws InterruptedException {
        buffer.setCompressed(false);
        this.ripeBufferHandler.accept(buffer.asByteBuf(), new BufferHeader(subIdx, dataType, isCompressed, buffer.getSize()));
    }

    public boolean isEmpty() {
        return this.cachedBuffer == null;
    }

    public void close() {
        if (this.cachedBuffer != null) {
            this.cachedBuffer.recycleBuffer();
            this.cachedBuffer = null;
        }
        this.currentSubIdx = -1;
    }

    public static Queue<Buffer> unpack(ByteBuf byteBuf) {
        ArrayDeque<Buffer> buffers = new ArrayDeque<Buffer>();
        try {
            BufferHeader bufferHeader;
            if (byteBuf instanceof CompositeByteBuf) {
                CompositeByteBuf compositeByteBuf = (CompositeByteBuf)byteBuf;
                ByteBuf headerBuffer = compositeByteBuf.component(0).unwrap();
                ByteBuf dataBuffer = compositeByteBuf.component(1).unwrap();
                dataBuffer.retain();
                Utils.checkState(dataBuffer instanceof Buffer, "Illegal data buffer type for CompositeByteBuf.");
                BufferHeader bufferHeader2 = BufferUtils.getBufferHeaderFromByteBuf(headerBuffer, 0);
                Buffer slice = ((Buffer)dataBuffer).readOnlySlice(0, bufferHeader2.getSize());
                buffers.add(new UnpackSlicedBuffer(slice, bufferHeader2.getDataType(), bufferHeader2.isCompressed(), bufferHeader2.getSize()));
                ArrayDeque<Buffer> arrayDeque = buffers;
                return arrayDeque;
            }
            Utils.checkState(byteBuf instanceof Buffer, "Illegal buffer type.");
            Buffer buffer = (Buffer)byteBuf;
            int totalBytes = buffer.readableBytes();
            boolean isFirst = true;
            for (int position = 0; position < totalBytes; position += bufferHeader.getSize()) {
                if (isFirst) {
                    bufferHeader = BufferUtils.getBufferHeader(buffer, position, isFirst);
                    position += 22;
                } else {
                    logger.debug("readbuffer: total: {}, position: {}", (Object)totalBytes, (Object)position);
                    bufferHeader = BufferUtils.getBufferHeader(buffer, position);
                    position += 6;
                }
                Buffer slice = buffer.readOnlySlice(position, bufferHeader.getSize());
                buffers.add(new UnpackSlicedBuffer(slice, bufferHeader.getDataType(), bufferHeader.isCompressed(), bufferHeader.getSize()));
                slice.retainBuffer();
                isFirst = false;
            }
            logger.debug("Unpack buffer size {} get sliced buffers {} detail {}", new Object[]{buffer.getSize(), buffers.size(), buffers});
            ArrayDeque<Buffer> arrayDeque = buffers;
            return arrayDeque;
        }
        catch (Throwable throwable) {
            buffers.forEach(Buffer::recycleBuffer);
            throw throwable;
        }
        finally {
            byteBuf.release();
        }
    }

    private static class UnpackSlicedBuffer
    implements Buffer {
        private final Buffer buffer;
        private Buffer.DataType dataType;
        private boolean isCompressed;
        private final int size;

        UnpackSlicedBuffer(Buffer buffer, Buffer.DataType dataType, boolean isCompressed, int size) {
            this.buffer = buffer;
            this.dataType = dataType;
            this.isCompressed = isCompressed;
            this.size = size;
        }

        public boolean isBuffer() {
            return this.dataType.isBuffer();
        }

        public MemorySegment getMemorySegment() {
            return this.buffer.getMemorySegment();
        }

        public int getMemorySegmentOffset() {
            return this.buffer.getMemorySegmentOffset();
        }

        public BufferRecycler getRecycler() {
            return this.buffer.getRecycler();
        }

        public void setRecycler(BufferRecycler bufferRecycler) {
            DynMethods.builder("setRecycler").impl(this.buffer.getClass().getName(), BufferRecycler.class).build().bind(this.buffer).invoke(bufferRecycler);
        }

        public void recycleBuffer() {
            this.buffer.recycleBuffer();
        }

        public boolean isRecycled() {
            return this.buffer.isRecycled();
        }

        public Buffer retainBuffer() {
            return this.buffer.retainBuffer();
        }

        public Buffer readOnlySlice() {
            return this.buffer.readOnlySlice();
        }

        public Buffer readOnlySlice(int i, int i1) {
            return this.buffer.readOnlySlice(i, i1);
        }

        public int getMaxCapacity() {
            return this.buffer.getMaxCapacity();
        }

        public int getReaderIndex() {
            return this.buffer.getReaderIndex();
        }

        public void setReaderIndex(int i) throws IndexOutOfBoundsException {
            this.buffer.setReaderIndex(i);
        }

        public int getSize() {
            return this.size;
        }

        public void setSize(int i) {
            this.buffer.setSize(i);
        }

        public int readableBytes() {
            return this.buffer.readableBytes();
        }

        public ByteBuffer getNioBufferReadable() {
            return this.buffer.getNioBufferReadable();
        }

        public ByteBuffer getNioBuffer(int i, int i1) throws IndexOutOfBoundsException {
            return this.buffer.getNioBuffer(i, i1);
        }

        public void setAllocator(ByteBufAllocator byteBufAllocator) {
            this.buffer.setAllocator(byteBufAllocator);
        }

        public ByteBuf asByteBuf() {
            return this.buffer.asByteBuf();
        }

        public boolean isCompressed() {
            return this.isCompressed;
        }

        public void setCompressed(boolean b) {
            this.isCompressed = b;
        }

        public Buffer.DataType getDataType() {
            return this.dataType;
        }

        public void setDataType(Buffer.DataType dataType) {
            this.dataType = dataType;
        }

        public int refCnt() {
            return this.buffer.refCnt();
        }

        public String toString() {
            return "UnpackSlicedBuffer{dataType=" + this.dataType + ", isCompressed=" + this.isCompressed + ", size=" + this.size + ", hash=" + System.identityHashCode(this) + '}';
        }
    }

    public static interface BiConsumerWithException<T, U, E extends Throwable> {
        public void accept(T var1, U var2) throws E;
    }
}

