/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.convert;

import java.lang.reflect.Array;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.apache.commons.configuration2.convert.ListDelimiterHandler;
import org.apache.commons.configuration2.convert.ValueTransformer;

public abstract class AbstractListDelimiterHandler
implements ListDelimiterHandler {
    static Collection<?> flatten(ListDelimiterHandler handler, Object value, int limit, Set<Object> dejaVu) {
        if (value instanceof String) {
            return handler.split((String)value, true);
        }
        dejaVu.add(value);
        LinkedList<Object> result = new LinkedList<Object>();
        if (value instanceof Path) {
            result.add(value);
        } else if (value instanceof Iterable) {
            AbstractListDelimiterHandler.flattenIterator(handler, result, ((Iterable)value).iterator(), limit, dejaVu);
        } else if (value instanceof Iterator) {
            AbstractListDelimiterHandler.flattenIterator(handler, result, (Iterator)value, limit, dejaVu);
        } else if (value != null) {
            if (value.getClass().isArray()) {
                int len = Array.getLength(value);
                int size = 0;
                for (int idx = 0; idx < len && size < limit; ++idx) {
                    result.addAll(handler.flatten(Array.get(value, idx), limit - size));
                    size = result.size();
                }
            } else {
                result.add(value);
            }
        }
        return result;
    }

    static void flattenIterator(ListDelimiterHandler handler, Collection<Object> target, Iterator<?> iterator, int limit, Set<Object> dejaVue) {
        int size = target.size();
        while (size < limit && iterator.hasNext()) {
            Object next = iterator.next();
            if (dejaVue.contains(next)) continue;
            target.addAll(AbstractListDelimiterHandler.flatten(handler, next, limit - size, dejaVue));
            size = target.size();
        }
    }

    @Override
    public Object escape(Object value, ValueTransformer transformer) {
        return transformer.transformValue(value instanceof String ? this.escapeString((String)value) : value);
    }

    protected abstract String escapeString(String var1);

    private Collection<?> flatten(Object value) {
        return this.flatten(value, Integer.MAX_VALUE);
    }

    @Override
    public Iterable<?> parse(Object value) {
        return this.flatten(value);
    }

    @Override
    public Collection<String> split(String s, boolean trim) {
        return s == null ? new ArrayList(0) : this.splitString(s, trim);
    }

    protected abstract Collection<String> splitString(String var1, boolean var2);
}

