/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.xml;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.ValidationEventHandler;
import jakarta.xml.bind.helpers.DefaultValidationEventHandler;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import org.ehcache.config.ResourcePool;
import org.ehcache.config.ResourcePools;
import org.ehcache.config.ResourceType;
import org.ehcache.config.SizedResourcePool;
import org.ehcache.config.builders.ResourcePoolsBuilder;
import org.ehcache.config.units.EntryUnit;
import org.ehcache.impl.config.SizedResourcePoolImpl;
import org.ehcache.xml.CacheResourceConfigurationParser;
import org.ehcache.xml.XmlConfiguration;
import org.ehcache.xml.XmlUtil;
import org.ehcache.xml.exceptions.XmlConfigurationException;
import org.ehcache.xml.model.CacheTemplate;
import org.ehcache.xml.model.CacheType;
import org.ehcache.xml.model.Disk;
import org.ehcache.xml.model.Heap;
import org.ehcache.xml.model.MemoryTypeWithPropSubst;
import org.ehcache.xml.model.MemoryUnit;
import org.ehcache.xml.model.ObjectFactory;
import org.ehcache.xml.model.Offheap;
import org.ehcache.xml.model.PersistableMemoryTypeWithPropSubst;
import org.ehcache.xml.model.ResourceTypeWithPropSubst;
import org.ehcache.xml.model.ResourceUnit;
import org.ehcache.xml.model.ResourcesType;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ResourceConfigurationParser {
    private static final ObjectFactory OBJECT_FACTORY = new ObjectFactory();
    private static final Schema CORE_SCHEMA;
    private static final String CORE_SCHEMA_NS;
    private final JAXBContext jaxbContext;
    private final Set<CacheResourceConfigurationParser> extensionParsers;

    public ResourceConfigurationParser(Set<CacheResourceConfigurationParser> extensionParsers) {
        this.extensionParsers = extensionParsers;
        try {
            this.jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ResourcesType.class});
        }
        catch (JAXBException e) {
            throw new AssertionError((Object)e);
        }
    }

    public ResourcePools parse(CacheTemplate cacheTemplate, ResourcePoolsBuilder resourcePoolsBuilder, ClassLoader classLoader) {
        if (cacheTemplate.getHeap() != null) {
            resourcePoolsBuilder = resourcePoolsBuilder.with(this.parseHeapConfiguration(cacheTemplate.getHeap()));
        } else if (!cacheTemplate.getResources().isEmpty()) {
            for (Element element : cacheTemplate.getResources()) {
                SizedResourcePoolImpl<SizedResourcePool> resourcePool;
                block12: {
                    if (!CORE_SCHEMA_NS.equals(element.getNamespaceURI())) {
                        resourcePool = this.parseResourceExtension(element, classLoader);
                    } else {
                        try {
                            Unmarshaller unmarshaller = this.jaxbContext.createUnmarshaller();
                            unmarshaller.setEventHandler((ValidationEventHandler)new DefaultValidationEventHandler());
                            Object resource = unmarshaller.unmarshal((Node)element);
                            if (resource instanceof Heap) {
                                resourcePool = this.parseHeapConfiguration((Heap)((Object)resource));
                                break block12;
                            }
                            if (resource instanceof Offheap) {
                                MemoryTypeWithPropSubst offheapResource = (MemoryTypeWithPropSubst)((Offheap)((Object)resource)).getValue();
                                resourcePool = new SizedResourcePoolImpl<SizedResourcePool>(ResourceType.Core.OFFHEAP, offheapResource.getValue().longValue(), ResourceConfigurationParser.parseMemory(offheapResource), false);
                                break block12;
                            }
                            if (resource instanceof Disk) {
                                PersistableMemoryTypeWithPropSubst diskResource = (PersistableMemoryTypeWithPropSubst)((Disk)((Object)resource)).getValue();
                                resourcePool = new SizedResourcePoolImpl<SizedResourcePool>(ResourceType.Core.DISK, diskResource.getValue().longValue(), ResourceConfigurationParser.parseMemory(diskResource), diskResource.isPersistent());
                                break block12;
                            }
                            throw new AssertionError((Object)("Unrecognized resource: " + element + " / " + resource.getClass().getName()));
                        }
                        catch (JAXBException e) {
                            throw new IllegalArgumentException("Can't find parser for resource: " + element, e);
                        }
                    }
                }
                resourcePoolsBuilder = resourcePoolsBuilder.with(resourcePool);
            }
        } else {
            throw new XmlConfigurationException("No resources defined for the cache: " + cacheTemplate.id());
        }
        return resourcePoolsBuilder.build();
    }

    private ResourcePool parseHeapConfiguration(Heap heap) {
        ResourceTypeWithPropSubst heapResource = (ResourceTypeWithPropSubst)heap.getValue();
        return new SizedResourcePoolImpl<SizedResourcePool>(ResourceType.Core.HEAP, heapResource.getValue().longValue(), ResourceConfigurationParser.parseUnit(heapResource), false);
    }

    private static org.ehcache.config.ResourceUnit parseUnit(ResourceTypeWithPropSubst resourceType) {
        if (resourceType.getUnit().equals((Object)ResourceUnit.ENTRIES)) {
            return EntryUnit.ENTRIES;
        }
        return org.ehcache.config.units.MemoryUnit.valueOf(resourceType.getUnit().value().toUpperCase());
    }

    private static org.ehcache.config.units.MemoryUnit parseMemory(MemoryTypeWithPropSubst memoryType) {
        return org.ehcache.config.units.MemoryUnit.valueOf(memoryType.getUnit().value().toUpperCase());
    }

    ResourcePool parseResourceExtension(Element element, ClassLoader classLoader) {
        for (CacheResourceConfigurationParser parser : this.extensionParsers) {
            ResourcePool resourcePool = (ResourcePool)parser.parse(element, classLoader);
            if (resourcePool == null) continue;
            return resourcePool;
        }
        throw new XmlConfigurationException("Can't find parser for element: " + element);
    }

    public CacheType unparse(Document target, ResourcePools resourcePools, CacheType cacheType) {
        ArrayList<Element> resources = new ArrayList<Element>();
        resourcePools.getResourceTypeSet().forEach(resourceType -> {
            Object resourcePool = resourcePools.getPoolForResource(resourceType);
            if (resourceType instanceof ResourceType.Core) {
                JAXBElement resource;
                SizedResourcePool pool = (SizedResourcePool)resourcePool;
                if (resourceType == ResourceType.Core.HEAP) {
                    resource = OBJECT_FACTORY.createHeap(OBJECT_FACTORY.createResourceTypeWithPropSubst().withValue(BigInteger.valueOf(pool.getSize())).withUnit(ResourceConfigurationParser.unparseUnit(pool.getUnit())));
                } else if (resourceType == ResourceType.Core.OFFHEAP) {
                    resource = OBJECT_FACTORY.createOffheap(OBJECT_FACTORY.createMemoryTypeWithPropSubst().withValue(BigInteger.valueOf(pool.getSize())).withUnit(ResourceConfigurationParser.unparseMemory((org.ehcache.config.units.MemoryUnit)pool.getUnit())));
                } else if (resourceType == ResourceType.Core.DISK) {
                    resource = OBJECT_FACTORY.createDisk(OBJECT_FACTORY.createPersistableMemoryTypeWithPropSubst().withValue(BigInteger.valueOf(pool.getSize())).withUnit(ResourceConfigurationParser.unparseMemory((org.ehcache.config.units.MemoryUnit)pool.getUnit())).withPersistent(pool.isPersistent()));
                } else {
                    throw new AssertionError((Object)("Unrecognized core resource type: " + resourceType));
                }
                try {
                    DocumentFragment fragment = target.createDocumentFragment();
                    Marshaller marshaller = this.jaxbContext.createMarshaller();
                    marshaller.setSchema(CORE_SCHEMA);
                    marshaller.marshal((Object)resource, (Node)fragment);
                    NodeList children = fragment.getChildNodes();
                    for (int i = 0; i < children.getLength(); ++i) {
                        Node item = children.item(i);
                        if (!(item instanceof Element)) {
                            throw new XmlConfigurationException("Unexpected marshalled resource node: " + item);
                        }
                        resources.add((Element)item);
                    }
                }
                catch (JAXBException e) {
                    throw new XmlConfigurationException(e);
                }
            } else {
                HashMap parsers = new HashMap();
                this.extensionParsers.forEach(parser -> parser.getResourceTypes().forEach(rt -> parsers.put(rt, parser)));
                CacheResourceConfigurationParser parser2 = (CacheResourceConfigurationParser)parsers.get(resourcePool.getClass());
                if (parser2 != null) {
                    resources.add(parser2.unparse(target, resourcePool));
                } else {
                    throw new AssertionError((Object)("Parser not found for resource type: " + resourceType));
                }
            }
        });
        return cacheType.withResources(OBJECT_FACTORY.createResourcesType().withResource(resources));
    }

    private static ResourceUnit unparseUnit(org.ehcache.config.ResourceUnit resourceUnit) {
        if (resourceUnit instanceof EntryUnit) {
            return ResourceUnit.ENTRIES;
        }
        return ResourceUnit.fromValue(resourceUnit.toString());
    }

    private static MemoryUnit unparseMemory(org.ehcache.config.units.MemoryUnit memoryUnit) {
        return MemoryUnit.fromValue(memoryUnit.toString());
    }

    static {
        try {
            CORE_SCHEMA = XmlUtil.newSchema(new StreamSource(XmlConfiguration.CORE_SCHEMA_URL.toExternalForm()));
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
        CORE_SCHEMA_NS = OBJECT_FACTORY.createResource(OBJECT_FACTORY.createResourceTypeWithPropSubst()).getName().getNamespaceURI();
    }
}

