/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.impl;

import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.core.MultivaluedMap;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import org.apache.cxf.jaxrs.impl.AbstractResponseContextImpl;
import org.apache.cxf.jaxrs.impl.ResponseImpl;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.message.Message;

public class ContainerResponseContextImpl
extends AbstractResponseContextImpl
implements ContainerResponseContext {
    private Class<?> serviceCls;
    private Method invoked;

    public ContainerResponseContextImpl(ResponseImpl r, Message m, Class<?> serviceCls, Method invoked) {
        super(r, m);
        this.serviceCls = serviceCls;
        this.invoked = invoked;
    }

    public Annotation[] getEntityAnnotations() {
        return super.getResponseEntityAnnotations();
    }

    public Class<?> getEntityClass() {
        return InjectionUtils.getRawResponseClass(this.r.getActualEntity());
    }

    public Type getEntityType() {
        return InjectionUtils.getGenericResponseType(this.invoked, this.serviceCls, this.r.getActualEntity(), this.getEntityClass(), this.m.getExchange());
    }

    public MultivaluedMap<String, Object> getHeaders() {
        return this.r.getMetadata();
    }

    public OutputStream getEntityStream() {
        return (OutputStream)this.m.getContent(OutputStream.class);
    }

    public void setEntityStream(OutputStream os) {
        this.m.setContent(OutputStream.class, (Object)os);
    }

    public boolean containsHeaderString(String name, String valueSeparatorRegex, Predicate<String> valuePredicate) {
        List<String> headerStrings = HttpUtils.getHeaderStrings((List)this.getHeaders().get((Object)name));
        String headerString = HttpUtils.getHeaderString(headerStrings);
        if (headerString == null) {
            return false;
        }
        return Arrays.stream(headerString.split(valueSeparatorRegex)).map(String::trim).filter(valuePredicate).findAny().isPresent();
    }
}

