/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.signature.impl;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.shared.annotation.constraint.Live;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import org.opensaml.core.xml.AbstractXMLObject;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.util.IndexedXMLObjectChildrenList;
import org.opensaml.xmlsec.signature.Transform;
import org.opensaml.xmlsec.signature.XPath;

public class TransformImpl
extends AbstractXMLObject
implements Transform {
    @Nullable
    private String algorithm;
    @Nonnull
    private final IndexedXMLObjectChildrenList<XMLObject> indexedChildren = new IndexedXMLObjectChildrenList((XMLObject)this);

    protected TransformImpl(@Nullable String namespaceURI, @Nonnull String elementLocalName, @Nullable String namespacePrefix) {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    @Nullable
    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(@Nullable String newAlgorithm) {
        this.algorithm = this.prepareForAssignment(this.algorithm, newAlgorithm);
    }

    @Nonnull
    @Live
    public List<XMLObject> getAllChildren() {
        return this.indexedChildren;
    }

    @Nonnull
    @Live
    public List<XMLObject> getXMLObjects(@Nonnull QName typeOrName) {
        return this.indexedChildren.subList(typeOrName);
    }

    @Nonnull
    @Live
    public List<XPath> getXPaths() {
        return this.indexedChildren.subList(XPath.DEFAULT_ELEMENT_NAME);
    }

    @Nullable
    @Unmodifiable
    @NotLive
    public List<XMLObject> getOrderedChildren() {
        return CollectionSupport.copyToList(this.indexedChildren);
    }
}

