/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.config;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.activemq.artemis.core.config.JaasAppConfigurationEntry;

public class JaasAppConfiguration
implements Serializable {
    private static final long serialVersionUID = -651209063030767325L;
    private String name;
    private List<JaasAppConfigurationEntry> modules = new ArrayList<JaasAppConfigurationEntry>();

    public String getName() {
        return this.name;
    }

    public JaasAppConfiguration setName(String name) {
        this.name = name;
        return this;
    }

    public List<JaasAppConfigurationEntry> getModules() {
        return this.modules;
    }

    public JaasAppConfiguration addModule(JaasAppConfigurationEntry entry) {
        this.modules.add(entry);
        return this;
    }

    public static AppConfigurationEntry[] asAppConfigurationEntry(JaasAppConfiguration jaasAppConfiguration) {
        if (jaasAppConfiguration == null) {
            return null;
        }
        AppConfigurationEntry[] entries = new AppConfigurationEntry[jaasAppConfiguration.getModules().size()];
        for (int i = 0; i < jaasAppConfiguration.getModules().size(); ++i) {
            JaasAppConfigurationEntry jaasAppConfigurationEntry = jaasAppConfiguration.getModules().get(i);
            entries[i] = new AppConfigurationEntry(jaasAppConfigurationEntry.getLoginModuleClass(), jaasAppConfigurationEntry.getLoginModuleControlFlag(), jaasAppConfigurationEntry.getParams());
        }
        return entries;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JaasAppConfiguration that = (JaasAppConfiguration)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.modules, that.modules);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.modules);
    }
}

