/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.core.util;

public class MethodsBag {
    private static final double log2div = Math.log(2.0);
    public static final char[] INTEGER_MIN_VALUE_CHARARRAY = "-2147483648".toCharArray();
    public static final char[] LONG_MIN_VALUE_CHARARRAY = "-9223372036854775808".toCharArray();
    static final char[] DigitOnes = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    static final char[] DigitTens = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9'};
    static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    static final int[] sizeTable = new int[]{9, 99, 999, 9999, 99999, 999999, 9999999, 99999999, 999999999, Integer.MAX_VALUE};

    public static int numberOf7BitBlocksToRepresent(int n) {
        assert (n >= 0);
        if (n < 128) {
            return 1;
        }
        if (n < 16384) {
            return 2;
        }
        if (n < 0x200000) {
            return 3;
        }
        if (n < 0x10000000) {
            return 4;
        }
        return 5;
    }

    public static int numberOf7BitBlocksToRepresent(long l) {
        if (l < -1L) {
            return MethodsBag.numberOf7BitBlocksToRepresent((int)l);
        }
        if (l < 0x800000000L) {
            return 5;
        }
        if (l < 0x40000000000L) {
            return 6;
        }
        if (l < 0x2000000000000L) {
            return 7;
        }
        if (l < 0x100000000000000L) {
            return 8;
        }
        if (l < Long.MIN_VALUE) {
            return 9;
        }
        return 10;
    }

    public static final int getCodingLength(int characteristics) {
        assert (characteristics >= 0);
        switch (characteristics) {
            case 0: 
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: 
            case 4: {
                return 2;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return 3;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                return 4;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                return 5;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: {
                return 6;
            }
        }
        assert (characteristics > 64);
        if (characteristics < 129) {
            return 7;
        }
        if (characteristics < 257) {
            return 8;
        }
        if (characteristics < 513) {
            return 9;
        }
        if (characteristics < 1025) {
            return 10;
        }
        if (characteristics < 2049) {
            return 11;
        }
        if (characteristics < 4097) {
            return 12;
        }
        if (characteristics < 8193) {
            return 13;
        }
        if (characteristics < 16385) {
            return 14;
        }
        if (characteristics < 32769) {
            return 15;
        }
        return (int)Math.ceil(Math.log(characteristics) / log2div);
    }

    static final int stringSize(int x) {
        int i = 0;
        while (x > sizeTable[i]) {
            ++i;
        }
        return i + 1;
    }

    static final int stringSize(long x) {
        long p = 10L;
        for (int i = 1; i < 19; ++i) {
            if (x < p) {
                return i;
            }
            p = 10L * p;
        }
        return 19;
    }

    public static final int getStringSize(int i) {
        return i < 0 ? MethodsBag.stringSize(-i) + 1 : MethodsBag.stringSize(i);
    }

    public static final int getStringSize(long l) {
        if (l == Long.MIN_VALUE) {
            return 20;
        }
        return l < 0L ? MethodsBag.stringSize(-l) + 1 : MethodsBag.stringSize(l);
    }

    public static final void itos(int i, int index, char[] buf) {
        int r;
        int q;
        assert (i != Integer.MIN_VALUE);
        int sign = 0;
        if (i < 0) {
            sign = 45;
            i = -i;
        }
        while (i >= 65536) {
            q = i / 100;
            r = i - ((q << 6) + (q << 5) + (q << 2));
            i = q;
            buf[--index] = DigitOnes[r];
            buf[--index] = DigitTens[r];
        }
        do {
            q = i * 52429 >>> 19;
            r = i - ((q << 3) + (q << 1));
            buf[--index] = digits[r];
        } while ((i = q) != 0);
        if (sign != 0) {
            buf[--index] = sign;
        }
    }

    public static final void itos(long i, int index, char[] buf) {
        int q2;
        int r;
        if (i == Long.MIN_VALUE) {
            buf[--index] = 56;
            buf[--index] = 48;
            buf[--index] = 56;
            buf[--index] = 53;
            buf[--index] = 55;
            buf[--index] = 55;
            buf[--index] = 52;
            buf[--index] = 53;
            buf[--index] = 56;
            buf[--index] = 54;
            buf[--index] = 51;
            buf[--index] = 48;
            buf[--index] = 50;
            buf[--index] = 55;
            buf[--index] = 51;
            buf[--index] = 51;
            buf[--index] = 50;
            buf[--index] = 50;
            buf[--index] = 57;
            buf[--index] = 45;
            return;
        }
        assert (i != Long.MIN_VALUE);
        int sign = 0;
        if (i < 0L) {
            sign = 45;
            i = -i;
        }
        while (i > Integer.MAX_VALUE) {
            long q = i / 100L;
            r = (int)(i - ((q << 6) + (q << 5) + (q << 2)));
            i = q;
            buf[--index] = DigitOnes[r];
            buf[--index] = DigitTens[r];
        }
        int i2 = (int)i;
        while (i2 >= 65536) {
            q2 = i2 / 100;
            r = i2 - ((q2 << 6) + (q2 << 5) + (q2 << 2));
            i2 = q2;
            buf[--index] = DigitOnes[r];
            buf[--index] = DigitTens[r];
        }
        do {
            q2 = i2 * 52429 >>> 19;
            r = i2 - ((q2 << 3) + (q2 << 1));
            buf[--index] = digits[r];
        } while ((i2 = q2) != 0);
        if (sign != 0) {
            buf[--index] = sign;
        }
    }

    public static final int itosReverse(int i, int index, char[] buf) {
        int r;
        int q;
        assert (i >= 0);
        int posChar = index;
        while (i >= 65536) {
            q = i / 100;
            r = i - ((q << 6) + (q << 5) + (q << 2));
            i = q;
            buf[posChar++] = DigitOnes[r];
            buf[posChar++] = DigitTens[r];
        }
        do {
            q = i * 52429 >>> 19;
            r = i - ((q << 3) + (q << 1));
            buf[posChar++] = digits[r];
        } while ((i = q) != 0);
        return posChar - index;
    }

    public static final void itosReverse(long i, int index, char[] buf) {
        int q2;
        int r;
        assert (i >= 0L);
        while (i > Integer.MAX_VALUE) {
            long q = i / 100L;
            r = (int)(i - ((q << 6) + (q << 5) + (q << 2)));
            i = q;
            buf[index++] = DigitOnes[r];
            buf[index++] = DigitTens[r];
        }
        int i2 = (int)i;
        while (i2 >= 65536) {
            q2 = i2 / 100;
            r = i2 - ((q2 << 6) + (q2 << 5) + (q2 << 2));
            i2 = q2;
            buf[index++] = DigitOnes[r];
            buf[index++] = DigitTens[r];
        }
        do {
            q2 = i2 * 52429 >>> 19;
            r = i2 - ((q2 << 3) + (q2 << 1));
            buf[index++] = digits[r];
        } while ((i2 = q2) != 0);
    }
}

