/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.api.layers;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.daffodil.lib.util.SimpleNamedLoadableService;
import org.apache.daffodil.runtime1.layers.LayerRuntime;
import org.apache.daffodil.runtime1.layers.LayerUtils;

public abstract class Layer
implements SimpleNamedLoadableService {
    private final String localName;
    private final String targetNamespace;
    private LayerRuntime layerRuntime;
    private ArrayList<Class<? extends Exception>> peExceptions = new ArrayList();

    public Layer(String string, String string2) {
        LayerUtils.requireJavaIdCompatible(string, "layerLocalName");
        LayerUtils.requireURICompatible(string2, "layerNamespace");
        this.localName = string;
        this.targetNamespace = string2;
    }

    @Override
    public final String name() {
        return LayerUtils.spiName(this.localName, this.targetNamespace);
    }

    public final String localName() {
        return this.localName;
    }

    public final String namespace() {
        return this.targetNamespace;
    }

    public final void setLayerRuntime(LayerRuntime layerRuntime) {
        this.layerRuntime = layerRuntime;
    }

    public final LayerRuntime getLayerRuntime() {
        return this.layerRuntime;
    }

    public void processingError(String string) {
        this.layerRuntime.processingError(string);
    }

    public void processingError(Throwable throwable) {
        this.layerRuntime.processingError(throwable);
    }

    public void runtimeSchemaDefinitionError(String string) {
        this.layerRuntime.runtimeSchemaDefinitionError(string);
    }

    public void runtimeSchemaDefinitionError(Throwable throwable) {
        this.layerRuntime.runtimeSchemaDefinitionError(throwable);
    }

    public abstract InputStream wrapLayerInput(InputStream var1) throws Exception;

    public abstract OutputStream wrapLayerOutput(OutputStream var1) throws Exception;

    public final void setProcessingErrorException(Class<? extends Exception> clazz) {
        this.peExceptions.add(clazz);
    }

    public final List<Class<? extends Exception>> getProcessingErrorExceptions() {
        return this.peExceptions;
    }
}

