/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.sagemaker.model.ImageVersion;
import java.util.Date;

@SdkInternalApi
public class ImageVersionMarshaller {
    private static final MarshallingInfo<Date> CREATIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> FAILUREREASON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FailureReason").build();
    private static final MarshallingInfo<String> IMAGEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ImageArn").build();
    private static final MarshallingInfo<String> IMAGEVERSIONARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ImageVersionArn").build();
    private static final MarshallingInfo<String> IMAGEVERSIONSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ImageVersionStatus").build();
    private static final MarshallingInfo<Date> LASTMODIFIEDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastModifiedTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Integer> VERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Version").build();
    private static final ImageVersionMarshaller instance = new ImageVersionMarshaller();

    public static ImageVersionMarshaller getInstance() {
        return instance;
    }

    public void marshall(ImageVersion imageVersion, ProtocolMarshaller protocolMarshaller) {
        if (imageVersion == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)imageVersion.getCreationTime(), CREATIONTIME_BINDING);
            protocolMarshaller.marshall((Object)imageVersion.getFailureReason(), FAILUREREASON_BINDING);
            protocolMarshaller.marshall((Object)imageVersion.getImageArn(), IMAGEARN_BINDING);
            protocolMarshaller.marshall((Object)imageVersion.getImageVersionArn(), IMAGEVERSIONARN_BINDING);
            protocolMarshaller.marshall((Object)imageVersion.getImageVersionStatus(), IMAGEVERSIONSTATUS_BINDING);
            protocolMarshaller.marshall((Object)imageVersion.getLastModifiedTime(), LASTMODIFIEDTIME_BINDING);
            protocolMarshaller.marshall((Object)imageVersion.getVersion(), VERSION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

