/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.core.management.SubResource;
import com.azure.resourcemanager.network.fluent.models.LoadBalancerBackendAddressPropertiesFormat;
import com.azure.resourcemanager.network.models.LoadBalancerBackendAddressAdminState;
import com.azure.resourcemanager.network.models.NatRulePortMapping;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class LoadBalancerBackendAddress {
    @JsonProperty(value="properties")
    private LoadBalancerBackendAddressPropertiesFormat innerProperties;
    @JsonProperty(value="name")
    private String name;

    private LoadBalancerBackendAddressPropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    public String name() {
        return this.name;
    }

    public LoadBalancerBackendAddress withName(String name) {
        this.name = name;
        return this;
    }

    public SubResource virtualNetwork() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualNetwork();
    }

    public LoadBalancerBackendAddress withVirtualNetwork(SubResource virtualNetwork) {
        if (this.innerProperties() == null) {
            this.innerProperties = new LoadBalancerBackendAddressPropertiesFormat();
        }
        this.innerProperties().withVirtualNetwork(virtualNetwork);
        return this;
    }

    public SubResource subnet() {
        return this.innerProperties() == null ? null : this.innerProperties().subnet();
    }

    public LoadBalancerBackendAddress withSubnet(SubResource subnet) {
        if (this.innerProperties() == null) {
            this.innerProperties = new LoadBalancerBackendAddressPropertiesFormat();
        }
        this.innerProperties().withSubnet(subnet);
        return this;
    }

    public String ipAddress() {
        return this.innerProperties() == null ? null : this.innerProperties().ipAddress();
    }

    public LoadBalancerBackendAddress withIpAddress(String ipAddress) {
        if (this.innerProperties() == null) {
            this.innerProperties = new LoadBalancerBackendAddressPropertiesFormat();
        }
        this.innerProperties().withIpAddress(ipAddress);
        return this;
    }

    public SubResource networkInterfaceIpConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().networkInterfaceIpConfiguration();
    }

    public SubResource loadBalancerFrontendIpConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().loadBalancerFrontendIpConfiguration();
    }

    public LoadBalancerBackendAddress withLoadBalancerFrontendIpConfiguration(SubResource loadBalancerFrontendIpConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new LoadBalancerBackendAddressPropertiesFormat();
        }
        this.innerProperties().withLoadBalancerFrontendIpConfiguration(loadBalancerFrontendIpConfiguration);
        return this;
    }

    public List<NatRulePortMapping> inboundNatRulesPortMapping() {
        return this.innerProperties() == null ? null : this.innerProperties().inboundNatRulesPortMapping();
    }

    public LoadBalancerBackendAddressAdminState adminState() {
        return this.innerProperties() == null ? null : this.innerProperties().adminState();
    }

    public LoadBalancerBackendAddress withAdminState(LoadBalancerBackendAddressAdminState adminState) {
        if (this.innerProperties() == null) {
            this.innerProperties = new LoadBalancerBackendAddressPropertiesFormat();
        }
        this.innerProperties().withAdminState(adminState);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

