/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.engine.task.dispatcher;

import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.dolphinscheduler.server.master.engine.task.client.ITaskExecutorClient;
import org.apache.dolphinscheduler.server.master.engine.task.dispatcher.WorkerGroupDispatcher;
import org.apache.dolphinscheduler.server.master.engine.task.runnable.ITaskExecutionRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WorkerGroupDispatcherCoordinator
implements AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkerGroupDispatcherCoordinator.class);
    @Autowired
    private ITaskExecutorClient taskExecutorClient;
    private final ConcurrentHashMap<String, WorkerGroupDispatcher> workerGroupDispatcherMap = new ConcurrentHashMap();

    public void start() {
        log.info("WorkerGroupTaskDispatcherManager started...");
    }

    public void dispatchTask(ITaskExecutionRunnable taskExecutionRunnable, long delayTimeMills) {
        String workerGroup = taskExecutionRunnable.getTaskInstance().getWorkerGroup();
        this.getOrCreateWorkerGroupDispatcher(workerGroup).dispatchTask(taskExecutionRunnable, delayTimeMills);
        log.info("Success add Task[id={}] to WorkerGroupDispatcher[name={}]", (Object)taskExecutionRunnable.getId(), (Object)workerGroup);
    }

    public boolean removeTask(ITaskExecutionRunnable taskExecutionRunnable) {
        String workerGroup = taskExecutionRunnable.getTaskInstance().getWorkerGroup();
        boolean removed = this.getOrCreateWorkerGroupDispatcher(workerGroup).removeTask(taskExecutionRunnable);
        if (removed) {
            log.info("Success removed Task[id={}] from WorkerGroupDispatcher[name={}]", (Object)taskExecutionRunnable.getId(), (Object)workerGroup);
        } else {
            log.info("Failed to remove Task[id={}] from WorkerGroupDispatcher[name={}], this task has been dispatched", (Object)taskExecutionRunnable.getId(), (Object)workerGroup);
        }
        return removed;
    }

    public boolean existWorkerGroup(String workerGroup) {
        return this.workerGroupDispatcherMap.containsKey(workerGroup);
    }

    @Override
    public void close() throws Exception {
        log.info("WorkerGroupDispatcherCoordinator closing");
        for (WorkerGroupDispatcher workerGroupDispatcher : this.workerGroupDispatcherMap.values()) {
            try {
                workerGroupDispatcher.close();
            }
            catch (Exception e) {
                log.error("close WorkerGroupDispatcher[name={}] error", (Object)workerGroupDispatcher.getName(), (Object)e);
            }
        }
        log.info("WorkerGroupDispatcherCoordinator closed...");
    }

    private WorkerGroupDispatcher getOrCreateWorkerGroupDispatcher(String workerGroup) {
        return this.workerGroupDispatcherMap.computeIfAbsent(workerGroup, wg -> {
            WorkerGroupDispatcher workerGroupDispatcher = new WorkerGroupDispatcher((String)wg, this.taskExecutorClient);
            workerGroupDispatcher.start();
            return workerGroupDispatcher;
        });
    }
}

