/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service.impl;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.dolphinscheduler.api.service.TaskDefinitionLogService;
import org.apache.dolphinscheduler.dao.entity.WorkflowTaskRelation;
import org.apache.dolphinscheduler.dao.repository.TaskDefinitionLogDao;
import org.apache.dolphinscheduler.dao.repository.WorkflowTaskRelationLogDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TaskDefinitionLogServiceImpl
implements TaskDefinitionLogService {
    @Autowired
    private WorkflowTaskRelationLogDao workflowTaskRelationLogDao;
    @Autowired
    private TaskDefinitionLogDao taskDefinitionLogDao;

    @Override
    public void deleteTaskByWorkflowDefinitionCode(long workflowDefinitionCode) {
        List workflowTaskRelationLogList = this.workflowTaskRelationLogDao.queryByWorkflowDefinitionCode(workflowDefinitionCode);
        if (CollectionUtils.isEmpty((Collection)workflowTaskRelationLogList)) {
            return;
        }
        HashSet<Long> needToDeleteTaskDefinitionCodes = new HashSet<Long>();
        for (WorkflowTaskRelation workflowTaskRelation : workflowTaskRelationLogList) {
            needToDeleteTaskDefinitionCodes.add(workflowTaskRelation.getPreTaskCode());
            needToDeleteTaskDefinitionCodes.add(workflowTaskRelation.getPostTaskCode());
        }
        this.taskDefinitionLogDao.deleteByTaskDefinitionCodes(needToDeleteTaskDefinitionCodes);
        this.workflowTaskRelationLogDao.deleteByWorkflowDefinitionCode(workflowDefinitionCode);
    }
}

