/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.dao.repository.impl;

import java.util.List;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.dolphinscheduler.common.enums.Flag;
import org.apache.dolphinscheduler.common.enums.TaskGroupQueueStatus;
import org.apache.dolphinscheduler.dao.entity.TaskGroupQueue;
import org.apache.dolphinscheduler.dao.mapper.TaskGroupQueueMapper;
import org.apache.dolphinscheduler.dao.repository.BaseDao;
import org.apache.dolphinscheduler.dao.repository.TaskGroupQueueDao;
import org.springframework.stereotype.Repository;

@Repository
public class TaskGroupQueueDaoImpl
extends BaseDao<TaskGroupQueue, TaskGroupQueueMapper>
implements TaskGroupQueueDao {
    public TaskGroupQueueDaoImpl(@NonNull TaskGroupQueueMapper taskGroupQueueMapper) {
        super(taskGroupQueueMapper);
        if (taskGroupQueueMapper == null) {
            throw new NullPointerException("taskGroupQueueMapper is marked non-null but is null");
        }
    }

    @Override
    public void deleteByWorkflowInstanceIds(List<Integer> workflowInstanceIds) {
        if (CollectionUtils.isEmpty(workflowInstanceIds)) {
            return;
        }
        ((TaskGroupQueueMapper)this.mybatisMapper).deleteByWorkflowInstanceIds(workflowInstanceIds);
    }

    @Override
    public List<TaskGroupQueue> queryAllInQueueTaskGroupQueue() {
        return ((TaskGroupQueueMapper)this.mybatisMapper).queryAllTaskGroupQueueByInQueue(Flag.YES.getCode());
    }

    @Override
    public List<TaskGroupQueue> queryInQueueTaskGroupQueue(int minTaskGroupQueueId, int limit) {
        return ((TaskGroupQueueMapper)this.mybatisMapper).queryInQueueTaskGroupQueue(Flag.YES.getCode(), minTaskGroupQueueId, limit);
    }

    @Override
    public List<TaskGroupQueue> queryAllInQueueTaskGroupQueueByGroupId(Integer taskGroupId) {
        return ((TaskGroupQueueMapper)this.mybatisMapper).queryAllInQueueTaskGroupQueueByGroupId(taskGroupId, Flag.YES.getCode());
    }

    @Override
    public List<TaskGroupQueue> queryByTaskInstanceId(Integer taskInstanceId) {
        return ((TaskGroupQueueMapper)this.mybatisMapper).queryByTaskInstanceId(taskInstanceId);
    }

    @Override
    public List<TaskGroupQueue> queryAcquiredTaskGroupQueueByGroupId(Integer taskGroupId) {
        return ((TaskGroupQueueMapper)this.mybatisMapper).queryUsingTaskGroupQueueByGroupId(taskGroupId, TaskGroupQueueStatus.ACQUIRE_SUCCESS.getCode(), Flag.YES.getCode(), Flag.NO.getCode());
    }

    @Override
    public int countUsingTaskGroupQueueByGroupId(Integer taskGroupId) {
        return ((TaskGroupQueueMapper)this.mybatisMapper).countUsingTaskGroupQueueByGroupId(taskGroupId, TaskGroupQueueStatus.ACQUIRE_SUCCESS.getCode(), Flag.YES.ordinal(), Flag.NO.getCode());
    }

    @Override
    public List<TaskGroupQueue> queryWaitNotifyForceStartTaskGroupQueue(int minTaskGroupQueueId, int limit) {
        return ((TaskGroupQueueMapper)this.mybatisMapper).queryWaitNotifyForceStartTaskGroupQueue(Flag.YES.getCode(), Flag.YES.getCode(), minTaskGroupQueueId, limit);
    }
}

