/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.sagemaker.model.ContainerDefinition;
import com.amazonaws.services.sagemaker.model.InferenceExecutionConfig;
import com.amazonaws.services.sagemaker.model.Tag;
import com.amazonaws.services.sagemaker.model.VpcConfig;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateModelRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String modelName;
    private ContainerDefinition primaryContainer;
    private List<ContainerDefinition> containers;
    private InferenceExecutionConfig inferenceExecutionConfig;
    private String executionRoleArn;
    private List<Tag> tags;
    private VpcConfig vpcConfig;
    private Boolean enableNetworkIsolation;

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public String getModelName() {
        return this.modelName;
    }

    public CreateModelRequest withModelName(String modelName) {
        this.setModelName(modelName);
        return this;
    }

    public void setPrimaryContainer(ContainerDefinition primaryContainer) {
        this.primaryContainer = primaryContainer;
    }

    public ContainerDefinition getPrimaryContainer() {
        return this.primaryContainer;
    }

    public CreateModelRequest withPrimaryContainer(ContainerDefinition primaryContainer) {
        this.setPrimaryContainer(primaryContainer);
        return this;
    }

    public List<ContainerDefinition> getContainers() {
        return this.containers;
    }

    public void setContainers(Collection<ContainerDefinition> containers) {
        if (containers == null) {
            this.containers = null;
            return;
        }
        this.containers = new ArrayList<ContainerDefinition>(containers);
    }

    public CreateModelRequest withContainers(ContainerDefinition ... containers) {
        if (this.containers == null) {
            this.setContainers(new ArrayList<ContainerDefinition>(containers.length));
        }
        for (ContainerDefinition ele : containers) {
            this.containers.add(ele);
        }
        return this;
    }

    public CreateModelRequest withContainers(Collection<ContainerDefinition> containers) {
        this.setContainers(containers);
        return this;
    }

    public void setInferenceExecutionConfig(InferenceExecutionConfig inferenceExecutionConfig) {
        this.inferenceExecutionConfig = inferenceExecutionConfig;
    }

    public InferenceExecutionConfig getInferenceExecutionConfig() {
        return this.inferenceExecutionConfig;
    }

    public CreateModelRequest withInferenceExecutionConfig(InferenceExecutionConfig inferenceExecutionConfig) {
        this.setInferenceExecutionConfig(inferenceExecutionConfig);
        return this;
    }

    public void setExecutionRoleArn(String executionRoleArn) {
        this.executionRoleArn = executionRoleArn;
    }

    public String getExecutionRoleArn() {
        return this.executionRoleArn;
    }

    public CreateModelRequest withExecutionRoleArn(String executionRoleArn) {
        this.setExecutionRoleArn(executionRoleArn);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreateModelRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateModelRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public void setVpcConfig(VpcConfig vpcConfig) {
        this.vpcConfig = vpcConfig;
    }

    public VpcConfig getVpcConfig() {
        return this.vpcConfig;
    }

    public CreateModelRequest withVpcConfig(VpcConfig vpcConfig) {
        this.setVpcConfig(vpcConfig);
        return this;
    }

    public void setEnableNetworkIsolation(Boolean enableNetworkIsolation) {
        this.enableNetworkIsolation = enableNetworkIsolation;
    }

    public Boolean getEnableNetworkIsolation() {
        return this.enableNetworkIsolation;
    }

    public CreateModelRequest withEnableNetworkIsolation(Boolean enableNetworkIsolation) {
        this.setEnableNetworkIsolation(enableNetworkIsolation);
        return this;
    }

    public Boolean isEnableNetworkIsolation() {
        return this.enableNetworkIsolation;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getModelName() != null) {
            sb.append("ModelName: ").append(this.getModelName()).append(",");
        }
        if (this.getPrimaryContainer() != null) {
            sb.append("PrimaryContainer: ").append(this.getPrimaryContainer()).append(",");
        }
        if (this.getContainers() != null) {
            sb.append("Containers: ").append(this.getContainers()).append(",");
        }
        if (this.getInferenceExecutionConfig() != null) {
            sb.append("InferenceExecutionConfig: ").append(this.getInferenceExecutionConfig()).append(",");
        }
        if (this.getExecutionRoleArn() != null) {
            sb.append("ExecutionRoleArn: ").append(this.getExecutionRoleArn()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getVpcConfig() != null) {
            sb.append("VpcConfig: ").append(this.getVpcConfig()).append(",");
        }
        if (this.getEnableNetworkIsolation() != null) {
            sb.append("EnableNetworkIsolation: ").append(this.getEnableNetworkIsolation());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateModelRequest)) {
            return false;
        }
        CreateModelRequest other = (CreateModelRequest)obj;
        if (other.getModelName() == null ^ this.getModelName() == null) {
            return false;
        }
        if (other.getModelName() != null && !other.getModelName().equals(this.getModelName())) {
            return false;
        }
        if (other.getPrimaryContainer() == null ^ this.getPrimaryContainer() == null) {
            return false;
        }
        if (other.getPrimaryContainer() != null && !other.getPrimaryContainer().equals(this.getPrimaryContainer())) {
            return false;
        }
        if (other.getContainers() == null ^ this.getContainers() == null) {
            return false;
        }
        if (other.getContainers() != null && !other.getContainers().equals(this.getContainers())) {
            return false;
        }
        if (other.getInferenceExecutionConfig() == null ^ this.getInferenceExecutionConfig() == null) {
            return false;
        }
        if (other.getInferenceExecutionConfig() != null && !other.getInferenceExecutionConfig().equals(this.getInferenceExecutionConfig())) {
            return false;
        }
        if (other.getExecutionRoleArn() == null ^ this.getExecutionRoleArn() == null) {
            return false;
        }
        if (other.getExecutionRoleArn() != null && !other.getExecutionRoleArn().equals(this.getExecutionRoleArn())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getVpcConfig() == null ^ this.getVpcConfig() == null) {
            return false;
        }
        if (other.getVpcConfig() != null && !other.getVpcConfig().equals(this.getVpcConfig())) {
            return false;
        }
        if (other.getEnableNetworkIsolation() == null ^ this.getEnableNetworkIsolation() == null) {
            return false;
        }
        return other.getEnableNetworkIsolation() == null || other.getEnableNetworkIsolation().equals(this.getEnableNetworkIsolation());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getModelName() == null ? 0 : this.getModelName().hashCode());
        hashCode = 31 * hashCode + (this.getPrimaryContainer() == null ? 0 : this.getPrimaryContainer().hashCode());
        hashCode = 31 * hashCode + (this.getContainers() == null ? 0 : this.getContainers().hashCode());
        hashCode = 31 * hashCode + (this.getInferenceExecutionConfig() == null ? 0 : this.getInferenceExecutionConfig().hashCode());
        hashCode = 31 * hashCode + (this.getExecutionRoleArn() == null ? 0 : this.getExecutionRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getVpcConfig() == null ? 0 : this.getVpcConfig().hashCode());
        hashCode = 31 * hashCode + (this.getEnableNetworkIsolation() == null ? 0 : this.getEnableNetworkIsolation().hashCode());
        return hashCode;
    }

    public CreateModelRequest clone() {
        return (CreateModelRequest)super.clone();
    }
}

