/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.commons.config;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.kubernetes.commons.config.PropertySourceUtils;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;

public abstract class ConfigMapPropertySource
extends MapPropertySource {
    private static final Log LOG = LogFactory.getLog(ConfigMapPropertySource.class);

    public ConfigMapPropertySource(String name, Map<String, Object> source) {
        super(name, source);
    }

    protected static String getName(String applicationName, String namespace) {
        return "configmap." + applicationName + "." + namespace;
    }

    protected static Map<String, Object> processAllEntries(Map<String, String> input, Environment environment) {
        Set<Map.Entry<String, String>> entrySet = input.entrySet();
        if (entrySet.size() == 1) {
            Map.Entry<String, String> singleEntry = entrySet.iterator().next();
            String propertyName = singleEntry.getKey();
            String propertyValue = singleEntry.getValue();
            if (propertyName.endsWith(".yml") || propertyName.endsWith(".yaml")) {
                LOG.debug((Object)("The single property with name: [" + propertyName + "] will be treated as a yaml file"));
                return PropertySourceUtils.yamlParserGenerator(environment).andThen(PropertySourceUtils.PROPERTIES_TO_MAP).apply(propertyValue);
            }
            if (propertyName.endsWith(".properties")) {
                LOG.debug((Object)("The single property with name: [" + propertyName + "] will be treated as a properties file"));
                return PropertySourceUtils.KEY_VALUE_TO_PROPERTIES.andThen(PropertySourceUtils.PROPERTIES_TO_MAP).apply(propertyValue);
            }
        }
        return ConfigMapPropertySource.defaultProcessAllEntries(input, environment);
    }

    protected static Map<String, Object> defaultProcessAllEntries(Map<String, String> input, Environment environment) {
        return input.entrySet().stream().map(e -> ConfigMapPropertySource.extractProperties((String)e.getKey(), (String)e.getValue(), environment)).flatMap(m -> m.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, PropertySourceUtils.throwingMerger(), HashMap::new));
    }

    protected static Map<String, Object> extractProperties(String resourceName, String content, Environment environment) {
        if (resourceName.equals("application.yaml") || resourceName.equals("application.yml")) {
            return PropertySourceUtils.yamlParserGenerator(environment).andThen(PropertySourceUtils.PROPERTIES_TO_MAP).apply(content);
        }
        if (resourceName.equals("application.properties")) {
            return PropertySourceUtils.KEY_VALUE_TO_PROPERTIES.andThen(PropertySourceUtils.PROPERTIES_TO_MAP).apply(content);
        }
        return Collections.singletonMap(resourceName, content);
    }
}

