/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.registry.jdbc.model.DTO;

import java.util.Date;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.registry.jdbc.model.DO.JdbcRegistryClientHeartbeat;

public class JdbcRegistryClientHeartbeatDTO {
    private Long id;
    private String clientName;
    private Long lastHeartbeatTime;
    private ClientConfig clientConfig;
    private Date createTime;

    public static JdbcRegistryClientHeartbeatDTO fromJdbcRegistryClientHeartbeat(JdbcRegistryClientHeartbeat jdbcRegistryClientHeartbeat) {
        return JdbcRegistryClientHeartbeatDTO.builder().id(jdbcRegistryClientHeartbeat.getId()).clientName(jdbcRegistryClientHeartbeat.getClientName()).lastHeartbeatTime(jdbcRegistryClientHeartbeat.getLastHeartbeatTime()).clientConfig((ClientConfig)JSONUtils.parseObject((String)jdbcRegistryClientHeartbeat.getConnectionConfig(), ClientConfig.class)).createTime(jdbcRegistryClientHeartbeat.getCreateTime()).build();
    }

    public static JdbcRegistryClientHeartbeat toJdbcRegistryClientHeartbeat(JdbcRegistryClientHeartbeatDTO jdbcRegistryClientHeartbeatDTO) {
        return JdbcRegistryClientHeartbeat.builder().id(jdbcRegistryClientHeartbeatDTO.getId()).clientName(jdbcRegistryClientHeartbeatDTO.getClientName()).lastHeartbeatTime(jdbcRegistryClientHeartbeatDTO.getLastHeartbeatTime()).connectionConfig(JSONUtils.toJsonString((Object)jdbcRegistryClientHeartbeatDTO.getClientConfig())).createTime(jdbcRegistryClientHeartbeatDTO.getCreateTime()).build();
    }

    public boolean isDead() {
        return System.currentTimeMillis() - this.lastHeartbeatTime > this.clientConfig.getSessionTimeout();
    }

    public JdbcRegistryClientHeartbeatDTO clone() {
        return JdbcRegistryClientHeartbeatDTO.builder().id(this.id).clientName(this.clientName).lastHeartbeatTime(this.lastHeartbeatTime).clientConfig(this.clientConfig).createTime(this.createTime).build();
    }

    @Generated
    public static JdbcRegistryClientHeartbeatDTOBuilder builder() {
        return new JdbcRegistryClientHeartbeatDTOBuilder();
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getClientName() {
        return this.clientName;
    }

    @Generated
    public Long getLastHeartbeatTime() {
        return this.lastHeartbeatTime;
    }

    @Generated
    public ClientConfig getClientConfig() {
        return this.clientConfig;
    }

    @Generated
    public Date getCreateTime() {
        return this.createTime;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    @Generated
    public void setLastHeartbeatTime(Long lastHeartbeatTime) {
        this.lastHeartbeatTime = lastHeartbeatTime;
    }

    @Generated
    public void setClientConfig(ClientConfig clientConfig) {
        this.clientConfig = clientConfig;
    }

    @Generated
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JdbcRegistryClientHeartbeatDTO)) {
            return false;
        }
        JdbcRegistryClientHeartbeatDTO other = (JdbcRegistryClientHeartbeatDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$lastHeartbeatTime = this.getLastHeartbeatTime();
        Long other$lastHeartbeatTime = other.getLastHeartbeatTime();
        if (this$lastHeartbeatTime == null ? other$lastHeartbeatTime != null : !((Object)this$lastHeartbeatTime).equals(other$lastHeartbeatTime)) {
            return false;
        }
        String this$clientName = this.getClientName();
        String other$clientName = other.getClientName();
        if (this$clientName == null ? other$clientName != null : !this$clientName.equals(other$clientName)) {
            return false;
        }
        ClientConfig this$clientConfig = this.getClientConfig();
        ClientConfig other$clientConfig = other.getClientConfig();
        if (this$clientConfig == null ? other$clientConfig != null : !((Object)this$clientConfig).equals(other$clientConfig)) {
            return false;
        }
        Date this$createTime = this.getCreateTime();
        Date other$createTime = other.getCreateTime();
        return !(this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof JdbcRegistryClientHeartbeatDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $lastHeartbeatTime = this.getLastHeartbeatTime();
        result = result * 59 + ($lastHeartbeatTime == null ? 43 : ((Object)$lastHeartbeatTime).hashCode());
        String $clientName = this.getClientName();
        result = result * 59 + ($clientName == null ? 43 : $clientName.hashCode());
        ClientConfig $clientConfig = this.getClientConfig();
        result = result * 59 + ($clientConfig == null ? 43 : ((Object)$clientConfig).hashCode());
        Date $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "JdbcRegistryClientHeartbeatDTO(id=" + this.getId() + ", clientName=" + this.getClientName() + ", lastHeartbeatTime=" + this.getLastHeartbeatTime() + ", clientConfig=" + this.getClientConfig() + ", createTime=" + this.getCreateTime() + ")";
    }

    @Generated
    public JdbcRegistryClientHeartbeatDTO() {
    }

    @Generated
    public JdbcRegistryClientHeartbeatDTO(Long id, String clientName, Long lastHeartbeatTime, ClientConfig clientConfig, Date createTime) {
        this.id = id;
        this.clientName = clientName;
        this.lastHeartbeatTime = lastHeartbeatTime;
        this.clientConfig = clientConfig;
        this.createTime = createTime;
    }

    @Generated
    public static class JdbcRegistryClientHeartbeatDTOBuilder {
        @Generated
        private Long id;
        @Generated
        private String clientName;
        @Generated
        private Long lastHeartbeatTime;
        @Generated
        private ClientConfig clientConfig;
        @Generated
        private Date createTime;

        @Generated
        JdbcRegistryClientHeartbeatDTOBuilder() {
        }

        @Generated
        public JdbcRegistryClientHeartbeatDTOBuilder id(Long id) {
            this.id = id;
            return this;
        }

        @Generated
        public JdbcRegistryClientHeartbeatDTOBuilder clientName(String clientName) {
            this.clientName = clientName;
            return this;
        }

        @Generated
        public JdbcRegistryClientHeartbeatDTOBuilder lastHeartbeatTime(Long lastHeartbeatTime) {
            this.lastHeartbeatTime = lastHeartbeatTime;
            return this;
        }

        @Generated
        public JdbcRegistryClientHeartbeatDTOBuilder clientConfig(ClientConfig clientConfig) {
            this.clientConfig = clientConfig;
            return this;
        }

        @Generated
        public JdbcRegistryClientHeartbeatDTOBuilder createTime(Date createTime) {
            this.createTime = createTime;
            return this;
        }

        @Generated
        public JdbcRegistryClientHeartbeatDTO build() {
            return new JdbcRegistryClientHeartbeatDTO(this.id, this.clientName, this.lastHeartbeatTime, this.clientConfig, this.createTime);
        }

        @Generated
        public String toString() {
            return "JdbcRegistryClientHeartbeatDTO.JdbcRegistryClientHeartbeatDTOBuilder(id=" + this.id + ", clientName=" + this.clientName + ", lastHeartbeatTime=" + this.lastHeartbeatTime + ", clientConfig=" + this.clientConfig + ", createTime=" + this.createTime + ")";
        }
    }

    public static class ClientConfig {
        private long sessionTimeout;

        @Generated
        private static long $default$sessionTimeout() {
            return TimeUnit.SECONDS.toMillis(60L);
        }

        @Generated
        public static ClientConfigBuilder builder() {
            return new ClientConfigBuilder();
        }

        @Generated
        public long getSessionTimeout() {
            return this.sessionTimeout;
        }

        @Generated
        public void setSessionTimeout(long sessionTimeout) {
            this.sessionTimeout = sessionTimeout;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ClientConfig)) {
                return false;
            }
            ClientConfig other = (ClientConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return this.getSessionTimeout() == other.getSessionTimeout();
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ClientConfig;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $sessionTimeout = this.getSessionTimeout();
            result = result * 59 + (int)($sessionTimeout >>> 32 ^ $sessionTimeout);
            return result;
        }

        @Generated
        public String toString() {
            return "JdbcRegistryClientHeartbeatDTO.ClientConfig(sessionTimeout=" + this.getSessionTimeout() + ")";
        }

        @Generated
        public ClientConfig() {
            this.sessionTimeout = ClientConfig.$default$sessionTimeout();
        }

        @Generated
        public ClientConfig(long sessionTimeout) {
            this.sessionTimeout = sessionTimeout;
        }

        @Generated
        public static class ClientConfigBuilder {
            @Generated
            private boolean sessionTimeout$set;
            @Generated
            private long sessionTimeout$value;

            @Generated
            ClientConfigBuilder() {
            }

            @Generated
            public ClientConfigBuilder sessionTimeout(long sessionTimeout) {
                this.sessionTimeout$value = sessionTimeout;
                this.sessionTimeout$set = true;
                return this;
            }

            @Generated
            public ClientConfig build() {
                long sessionTimeout$value = this.sessionTimeout$value;
                if (!this.sessionTimeout$set) {
                    sessionTimeout$value = ClientConfig.$default$sessionTimeout();
                }
                return new ClientConfig(sessionTimeout$value);
            }

            @Generated
            public String toString() {
                return "JdbcRegistryClientHeartbeatDTO.ClientConfig.ClientConfigBuilder(sessionTimeout$value=" + this.sessionTimeout$value + ")";
            }
        }
    }
}

