/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.RefreshableWrapperImpl;
import com.azure.resourcemanager.resources.fluentcore.utils.PagedConverter;
import com.azure.resourcemanager.sql.SqlServerManager;
import com.azure.resourcemanager.sql.fluent.SqlManagementClient;
import com.azure.resourcemanager.sql.fluent.models.DatabaseInner;
import com.azure.resourcemanager.sql.fluent.models.RecommendedElasticPoolInner;
import com.azure.resourcemanager.sql.fluent.models.RecommendedElasticPoolMetricInner;
import com.azure.resourcemanager.sql.implementation.RecommendedElasticPoolMetricImpl;
import com.azure.resourcemanager.sql.implementation.SqlDatabaseImpl;
import com.azure.resourcemanager.sql.implementation.SqlServerImpl;
import com.azure.resourcemanager.sql.models.ElasticPoolEdition;
import com.azure.resourcemanager.sql.models.RecommendedElasticPool;
import com.azure.resourcemanager.sql.models.RecommendedElasticPoolMetric;
import com.azure.resourcemanager.sql.models.SqlDatabase;
import com.azure.resourcemanager.sql.models.TrackedResource;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import reactor.core.publisher.Mono;

class RecommendedElasticPoolImpl
extends RefreshableWrapperImpl<RecommendedElasticPoolInner, RecommendedElasticPool>
implements RecommendedElasticPool {
    private final SqlServerImpl sqlServer;

    protected RecommendedElasticPoolImpl(RecommendedElasticPoolInner innerObject, SqlServerImpl sqlServer) {
        super((Object)innerObject);
        this.sqlServer = sqlServer;
    }

    protected Mono<RecommendedElasticPoolInner> getInnerAsync() {
        return ((SqlManagementClient)this.manager().serviceClient()).getRecommendedElasticPools().getAsync(this.resourceGroupName(), this.sqlServerName(), this.name());
    }

    public SqlServerManager manager() {
        return (SqlServerManager)this.sqlServer.manager();
    }

    @Override
    public String sqlServerName() {
        return this.sqlServer.name();
    }

    @Override
    public ElasticPoolEdition databaseEdition() {
        return ((RecommendedElasticPoolInner)((Object)this.innerModel())).databaseEdition();
    }

    @Override
    public double dtu() {
        return ((RecommendedElasticPoolInner)((Object)this.innerModel())).dtu();
    }

    @Override
    public double databaseDtuMin() {
        return ((RecommendedElasticPoolInner)((Object)this.innerModel())).databaseDtuMin();
    }

    @Override
    public double databaseDtuMax() {
        return ((RecommendedElasticPoolInner)((Object)this.innerModel())).databaseDtuMax();
    }

    @Override
    public double storageMB() {
        return ((RecommendedElasticPoolInner)((Object)this.innerModel())).storageMB();
    }

    @Override
    public OffsetDateTime observationPeriodStart() {
        return ((RecommendedElasticPoolInner)((Object)this.innerModel())).observationPeriodStart();
    }

    @Override
    public OffsetDateTime observationPeriodEnd() {
        return ((RecommendedElasticPoolInner)((Object)this.innerModel())).observationPeriodEnd();
    }

    @Override
    public double maxObservedDtu() {
        return ((RecommendedElasticPoolInner)((Object)this.innerModel())).maxObservedDtu();
    }

    @Override
    public double maxObservedStorageMB() {
        return ((RecommendedElasticPoolInner)((Object)this.innerModel())).maxObservedStorageMB();
    }

    @Override
    public List<TrackedResource> databases() {
        return ((RecommendedElasticPoolInner)((Object)this.innerModel())).databases();
    }

    @Override
    public List<SqlDatabase> listDatabases() {
        ArrayList<SqlDatabaseImpl> databasesList = new ArrayList<SqlDatabaseImpl>();
        PagedIterable<DatabaseInner> databaseInners = ((SqlManagementClient)((SqlServerManager)this.sqlServer.manager()).serviceClient()).getDatabases().listByElasticPool(this.sqlServer.resourceGroupName(), this.sqlServer.name(), this.name());
        for (DatabaseInner inner : databaseInners) {
            databasesList.add(new SqlDatabaseImpl(inner.name(), this.sqlServer, inner, this.manager()));
        }
        return Collections.unmodifiableList(databasesList);
    }

    @Override
    public PagedFlux<SqlDatabase> listDatabasesAsync() {
        RecommendedElasticPoolImpl self = this;
        return PagedConverter.mapPage(((SqlManagementClient)((SqlServerManager)this.sqlServer.manager()).serviceClient()).getDatabases().listByElasticPoolAsync(this.sqlServer.resourceGroupName(), this.sqlServer.name(), this.name()), databaseInner -> new SqlDatabaseImpl(databaseInner.name(), self.sqlServer, (DatabaseInner)((Object)databaseInner), self.manager()));
    }

    @Override
    public SqlDatabase getDatabase(String databaseName) {
        DatabaseInner databaseInner = ((SqlManagementClient)((SqlServerManager)this.sqlServer.manager()).serviceClient()).getDatabases().get(this.sqlServer.resourceGroupName(), this.sqlServer.name(), databaseName);
        return new SqlDatabaseImpl(databaseInner.name(), this.sqlServer, databaseInner, this.manager());
    }

    @Override
    public Mono<SqlDatabase> getDatabaseAsync(String databaseName) {
        RecommendedElasticPoolImpl self = this;
        return ((SqlManagementClient)((SqlServerManager)this.sqlServer.manager()).serviceClient()).getDatabases().getAsync(this.sqlServer.resourceGroupName(), this.sqlServer.name(), databaseName).map(databaseInner -> new SqlDatabaseImpl(databaseInner.name(), self.sqlServer, (DatabaseInner)((Object)databaseInner), self.manager()));
    }

    @Override
    public List<RecommendedElasticPoolMetric> listMetrics() {
        ArrayList<RecommendedElasticPoolMetricImpl> recommendedElasticPoolMetrics = new ArrayList<RecommendedElasticPoolMetricImpl>();
        PagedIterable<RecommendedElasticPoolMetricInner> recommendedElasticPoolMetricInners = ((SqlManagementClient)((SqlServerManager)this.sqlServer.manager()).serviceClient()).getRecommendedElasticPools().listMetrics(this.resourceGroupName(), this.sqlServerName(), this.name());
        for (RecommendedElasticPoolMetricInner inner : recommendedElasticPoolMetricInners) {
            recommendedElasticPoolMetrics.add(new RecommendedElasticPoolMetricImpl(inner));
        }
        return Collections.unmodifiableList(recommendedElasticPoolMetrics);
    }

    public String name() {
        return ((RecommendedElasticPoolInner)((Object)this.innerModel())).name();
    }

    public String id() {
        return ((RecommendedElasticPoolInner)((Object)this.innerModel())).id();
    }

    public String resourceGroupName() {
        return this.sqlServer.resourceGroupName();
    }
}

