/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Event;
import io.fabric8.kubernetes.api.model.EventFluent;
import io.fabric8.kubernetes.api.model.EventSeries;
import io.fabric8.kubernetes.api.model.EventSeriesBuilder;
import io.fabric8.kubernetes.api.model.EventSeriesFluentImpl;
import io.fabric8.kubernetes.api.model.EventSource;
import io.fabric8.kubernetes.api.model.EventSourceBuilder;
import io.fabric8.kubernetes.api.model.EventSourceFluentImpl;
import io.fabric8.kubernetes.api.model.MicroTime;
import io.fabric8.kubernetes.api.model.MicroTimeBuilder;
import io.fabric8.kubernetes.api.model.MicroTimeFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class EventFluentImpl<A extends EventFluent<A>>
extends BaseFluent<A>
implements EventFluent<A> {
    private String action;
    private String apiVersion;
    private Integer count;
    private MicroTimeBuilder eventTime;
    private String firstTimestamp;
    private ObjectReferenceBuilder involvedObject;
    private String kind;
    private String lastTimestamp;
    private String message;
    private ObjectMetaBuilder metadata;
    private String reason;
    private ObjectReferenceBuilder related;
    private String reportingComponent;
    private String reportingInstance;
    private EventSeriesBuilder series;
    private EventSourceBuilder source;
    private String type;
    private Map<String, Object> additionalProperties;

    public EventFluentImpl() {
    }

    public EventFluentImpl(Event instance) {
        this.withAction(instance.getAction());
        this.withApiVersion(instance.getApiVersion());
        this.withCount(instance.getCount());
        this.withEventTime(instance.getEventTime());
        this.withFirstTimestamp(instance.getFirstTimestamp());
        this.withInvolvedObject(instance.getInvolvedObject());
        this.withKind(instance.getKind());
        this.withLastTimestamp(instance.getLastTimestamp());
        this.withMessage(instance.getMessage());
        this.withMetadata(instance.getMetadata());
        this.withReason(instance.getReason());
        this.withRelated(instance.getRelated());
        this.withReportingComponent(instance.getReportingComponent());
        this.withReportingInstance(instance.getReportingInstance());
        this.withSeries(instance.getSeries());
        this.withSource(instance.getSource());
        this.withType(instance.getType());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public String getAction() {
        return this.action;
    }

    @Override
    public A withAction(String action) {
        this.action = action;
        return (A)this;
    }

    @Override
    public Boolean hasAction() {
        return this.action != null;
    }

    @Override
    @Deprecated
    public A withNewAction(String arg0) {
        return this.withAction(new String(arg0));
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    @Deprecated
    public A withNewApiVersion(String arg0) {
        return this.withApiVersion(new String(arg0));
    }

    @Override
    public Integer getCount() {
        return this.count;
    }

    @Override
    public A withCount(Integer count) {
        this.count = count;
        return (A)this;
    }

    @Override
    public Boolean hasCount() {
        return this.count != null;
    }

    @Override
    @Deprecated
    public MicroTime getEventTime() {
        return this.eventTime != null ? this.eventTime.build() : null;
    }

    @Override
    public MicroTime buildEventTime() {
        return this.eventTime != null ? this.eventTime.build() : null;
    }

    @Override
    public A withEventTime(MicroTime eventTime) {
        this._visitables.get("eventTime").remove(this.eventTime);
        if (eventTime != null) {
            this.eventTime = new MicroTimeBuilder(eventTime);
            this._visitables.get("eventTime").add(this.eventTime);
        }
        return (A)this;
    }

    @Override
    public Boolean hasEventTime() {
        return this.eventTime != null;
    }

    @Override
    public A withNewEventTime(String time) {
        return this.withEventTime(new MicroTime(time));
    }

    @Override
    public EventFluent.EventTimeNested<A> withNewEventTime() {
        return new EventTimeNestedImpl();
    }

    @Override
    public EventFluent.EventTimeNested<A> withNewEventTimeLike(MicroTime item) {
        return new EventTimeNestedImpl(item);
    }

    @Override
    public EventFluent.EventTimeNested<A> editEventTime() {
        return this.withNewEventTimeLike(this.getEventTime());
    }

    @Override
    public EventFluent.EventTimeNested<A> editOrNewEventTime() {
        return this.withNewEventTimeLike(this.getEventTime() != null ? this.getEventTime() : new MicroTimeBuilder().build());
    }

    @Override
    public EventFluent.EventTimeNested<A> editOrNewEventTimeLike(MicroTime item) {
        return this.withNewEventTimeLike(this.getEventTime() != null ? this.getEventTime() : item);
    }

    @Override
    public String getFirstTimestamp() {
        return this.firstTimestamp;
    }

    @Override
    public A withFirstTimestamp(String firstTimestamp) {
        this.firstTimestamp = firstTimestamp;
        return (A)this;
    }

    @Override
    public Boolean hasFirstTimestamp() {
        return this.firstTimestamp != null;
    }

    @Override
    @Deprecated
    public A withNewFirstTimestamp(String arg0) {
        return this.withFirstTimestamp(new String(arg0));
    }

    @Override
    @Deprecated
    public ObjectReference getInvolvedObject() {
        return this.involvedObject != null ? this.involvedObject.build() : null;
    }

    @Override
    public ObjectReference buildInvolvedObject() {
        return this.involvedObject != null ? this.involvedObject.build() : null;
    }

    @Override
    public A withInvolvedObject(ObjectReference involvedObject) {
        this._visitables.get("involvedObject").remove(this.involvedObject);
        if (involvedObject != null) {
            this.involvedObject = new ObjectReferenceBuilder(involvedObject);
            this._visitables.get("involvedObject").add(this.involvedObject);
        }
        return (A)this;
    }

    @Override
    public Boolean hasInvolvedObject() {
        return this.involvedObject != null;
    }

    @Override
    public EventFluent.InvolvedObjectNested<A> withNewInvolvedObject() {
        return new InvolvedObjectNestedImpl();
    }

    @Override
    public EventFluent.InvolvedObjectNested<A> withNewInvolvedObjectLike(ObjectReference item) {
        return new InvolvedObjectNestedImpl(item);
    }

    @Override
    public EventFluent.InvolvedObjectNested<A> editInvolvedObject() {
        return this.withNewInvolvedObjectLike(this.getInvolvedObject());
    }

    @Override
    public EventFluent.InvolvedObjectNested<A> editOrNewInvolvedObject() {
        return this.withNewInvolvedObjectLike(this.getInvolvedObject() != null ? this.getInvolvedObject() : new ObjectReferenceBuilder().build());
    }

    @Override
    public EventFluent.InvolvedObjectNested<A> editOrNewInvolvedObjectLike(ObjectReference item) {
        return this.withNewInvolvedObjectLike(this.getInvolvedObject() != null ? this.getInvolvedObject() : item);
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public A withNewKind(String arg0) {
        return this.withKind(new String(arg0));
    }

    @Override
    public String getLastTimestamp() {
        return this.lastTimestamp;
    }

    @Override
    public A withLastTimestamp(String lastTimestamp) {
        this.lastTimestamp = lastTimestamp;
        return (A)this;
    }

    @Override
    public Boolean hasLastTimestamp() {
        return this.lastTimestamp != null;
    }

    @Override
    @Deprecated
    public A withNewLastTimestamp(String arg0) {
        return this.withLastTimestamp(new String(arg0));
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public A withMessage(String message) {
        this.message = message;
        return (A)this;
    }

    @Override
    public Boolean hasMessage() {
        return this.message != null;
    }

    @Override
    @Deprecated
    public A withNewMessage(String arg0) {
        return this.withMessage(new String(arg0));
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.get("metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public EventFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public EventFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public EventFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public EventFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public EventFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    public String getReason() {
        return this.reason;
    }

    @Override
    public A withReason(String reason) {
        this.reason = reason;
        return (A)this;
    }

    @Override
    public Boolean hasReason() {
        return this.reason != null;
    }

    @Override
    @Deprecated
    public A withNewReason(String arg0) {
        return this.withReason(new String(arg0));
    }

    @Override
    @Deprecated
    public ObjectReference getRelated() {
        return this.related != null ? this.related.build() : null;
    }

    @Override
    public ObjectReference buildRelated() {
        return this.related != null ? this.related.build() : null;
    }

    @Override
    public A withRelated(ObjectReference related) {
        this._visitables.get("related").remove(this.related);
        if (related != null) {
            this.related = new ObjectReferenceBuilder(related);
            this._visitables.get("related").add(this.related);
        }
        return (A)this;
    }

    @Override
    public Boolean hasRelated() {
        return this.related != null;
    }

    @Override
    public EventFluent.RelatedNested<A> withNewRelated() {
        return new RelatedNestedImpl();
    }

    @Override
    public EventFluent.RelatedNested<A> withNewRelatedLike(ObjectReference item) {
        return new RelatedNestedImpl(item);
    }

    @Override
    public EventFluent.RelatedNested<A> editRelated() {
        return this.withNewRelatedLike(this.getRelated());
    }

    @Override
    public EventFluent.RelatedNested<A> editOrNewRelated() {
        return this.withNewRelatedLike(this.getRelated() != null ? this.getRelated() : new ObjectReferenceBuilder().build());
    }

    @Override
    public EventFluent.RelatedNested<A> editOrNewRelatedLike(ObjectReference item) {
        return this.withNewRelatedLike(this.getRelated() != null ? this.getRelated() : item);
    }

    @Override
    public String getReportingComponent() {
        return this.reportingComponent;
    }

    @Override
    public A withReportingComponent(String reportingComponent) {
        this.reportingComponent = reportingComponent;
        return (A)this;
    }

    @Override
    public Boolean hasReportingComponent() {
        return this.reportingComponent != null;
    }

    @Override
    @Deprecated
    public A withNewReportingComponent(String arg0) {
        return this.withReportingComponent(new String(arg0));
    }

    @Override
    public String getReportingInstance() {
        return this.reportingInstance;
    }

    @Override
    public A withReportingInstance(String reportingInstance) {
        this.reportingInstance = reportingInstance;
        return (A)this;
    }

    @Override
    public Boolean hasReportingInstance() {
        return this.reportingInstance != null;
    }

    @Override
    @Deprecated
    public A withNewReportingInstance(String arg0) {
        return this.withReportingInstance(new String(arg0));
    }

    @Override
    @Deprecated
    public EventSeries getSeries() {
        return this.series != null ? this.series.build() : null;
    }

    @Override
    public EventSeries buildSeries() {
        return this.series != null ? this.series.build() : null;
    }

    @Override
    public A withSeries(EventSeries series) {
        this._visitables.get("series").remove(this.series);
        if (series != null) {
            this.series = new EventSeriesBuilder(series);
            this._visitables.get("series").add(this.series);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSeries() {
        return this.series != null;
    }

    @Override
    public EventFluent.SeriesNested<A> withNewSeries() {
        return new SeriesNestedImpl();
    }

    @Override
    public EventFluent.SeriesNested<A> withNewSeriesLike(EventSeries item) {
        return new SeriesNestedImpl(item);
    }

    @Override
    public EventFluent.SeriesNested<A> editSeries() {
        return this.withNewSeriesLike(this.getSeries());
    }

    @Override
    public EventFluent.SeriesNested<A> editOrNewSeries() {
        return this.withNewSeriesLike(this.getSeries() != null ? this.getSeries() : new EventSeriesBuilder().build());
    }

    @Override
    public EventFluent.SeriesNested<A> editOrNewSeriesLike(EventSeries item) {
        return this.withNewSeriesLike(this.getSeries() != null ? this.getSeries() : item);
    }

    @Override
    @Deprecated
    public EventSource getSource() {
        return this.source != null ? this.source.build() : null;
    }

    @Override
    public EventSource buildSource() {
        return this.source != null ? this.source.build() : null;
    }

    @Override
    public A withSource(EventSource source) {
        this._visitables.get("source").remove(this.source);
        if (source != null) {
            this.source = new EventSourceBuilder(source);
            this._visitables.get("source").add(this.source);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSource() {
        return this.source != null;
    }

    @Override
    public A withNewSource(String component, String host) {
        return this.withSource(new EventSource(component, host));
    }

    @Override
    public EventFluent.SourceNested<A> withNewSource() {
        return new SourceNestedImpl();
    }

    @Override
    public EventFluent.SourceNested<A> withNewSourceLike(EventSource item) {
        return new SourceNestedImpl(item);
    }

    @Override
    public EventFluent.SourceNested<A> editSource() {
        return this.withNewSourceLike(this.getSource());
    }

    @Override
    public EventFluent.SourceNested<A> editOrNewSource() {
        return this.withNewSourceLike(this.getSource() != null ? this.getSource() : new EventSourceBuilder().build());
    }

    @Override
    public EventFluent.SourceNested<A> editOrNewSourceLike(EventSource item) {
        return this.withNewSourceLike(this.getSource() != null ? this.getSource() : item);
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public A withType(String type) {
        this.type = type;
        return (A)this;
    }

    @Override
    public Boolean hasType() {
        return this.type != null;
    }

    @Override
    @Deprecated
    public A withNewType(String arg0) {
        return this.withType(new String(arg0));
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventFluentImpl that = (EventFluentImpl)o;
        if (this.action != null ? !this.action.equals(that.action) : that.action != null) {
            return false;
        }
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.count != null ? !this.count.equals(that.count) : that.count != null) {
            return false;
        }
        if (this.eventTime != null ? !this.eventTime.equals(that.eventTime) : that.eventTime != null) {
            return false;
        }
        if (this.firstTimestamp != null ? !this.firstTimestamp.equals(that.firstTimestamp) : that.firstTimestamp != null) {
            return false;
        }
        if (this.involvedObject != null ? !this.involvedObject.equals(that.involvedObject) : that.involvedObject != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.lastTimestamp != null ? !this.lastTimestamp.equals(that.lastTimestamp) : that.lastTimestamp != null) {
            return false;
        }
        if (this.message != null ? !this.message.equals(that.message) : that.message != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.reason != null ? !this.reason.equals(that.reason) : that.reason != null) {
            return false;
        }
        if (this.related != null ? !this.related.equals(that.related) : that.related != null) {
            return false;
        }
        if (this.reportingComponent != null ? !this.reportingComponent.equals(that.reportingComponent) : that.reportingComponent != null) {
            return false;
        }
        if (this.reportingInstance != null ? !this.reportingInstance.equals(that.reportingInstance) : that.reportingInstance != null) {
            return false;
        }
        if (this.series != null ? !this.series.equals(that.series) : that.series != null) {
            return false;
        }
        if (this.source != null ? !this.source.equals(that.source) : that.source != null) {
            return false;
        }
        if (this.type != null ? !this.type.equals(that.type) : that.type != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.action, this.apiVersion, this.count, this.eventTime, this.firstTimestamp, this.involvedObject, this.kind, this.lastTimestamp, this.message, this.metadata, this.reason, this.related, this.reportingComponent, this.reportingInstance, this.series, this.source, this.type, this.additionalProperties, super.hashCode());
    }

    public class SourceNestedImpl<N>
    extends EventSourceFluentImpl<EventFluent.SourceNested<N>>
    implements EventFluent.SourceNested<N>,
    Nested<N> {
        EventSourceBuilder builder;

        SourceNestedImpl(EventSource item) {
            this.builder = new EventSourceBuilder(this, item);
        }

        SourceNestedImpl() {
            this.builder = new EventSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)EventFluentImpl.this.withSource(this.builder.build());
        }

        @Override
        public N endSource() {
            return this.and();
        }
    }

    public class SeriesNestedImpl<N>
    extends EventSeriesFluentImpl<EventFluent.SeriesNested<N>>
    implements EventFluent.SeriesNested<N>,
    Nested<N> {
        EventSeriesBuilder builder;

        SeriesNestedImpl(EventSeries item) {
            this.builder = new EventSeriesBuilder(this, item);
        }

        SeriesNestedImpl() {
            this.builder = new EventSeriesBuilder(this);
        }

        @Override
        public N and() {
            return (N)EventFluentImpl.this.withSeries(this.builder.build());
        }

        @Override
        public N endSeries() {
            return this.and();
        }
    }

    public class RelatedNestedImpl<N>
    extends ObjectReferenceFluentImpl<EventFluent.RelatedNested<N>>
    implements EventFluent.RelatedNested<N>,
    Nested<N> {
        ObjectReferenceBuilder builder;

        RelatedNestedImpl(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        RelatedNestedImpl() {
            this.builder = new ObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)EventFluentImpl.this.withRelated(this.builder.build());
        }

        @Override
        public N endRelated() {
            return this.and();
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<EventFluent.MetadataNested<N>>
    implements EventFluent.MetadataNested<N>,
    Nested<N> {
        ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)EventFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }

    public class InvolvedObjectNestedImpl<N>
    extends ObjectReferenceFluentImpl<EventFluent.InvolvedObjectNested<N>>
    implements EventFluent.InvolvedObjectNested<N>,
    Nested<N> {
        ObjectReferenceBuilder builder;

        InvolvedObjectNestedImpl(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        InvolvedObjectNestedImpl() {
            this.builder = new ObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)EventFluentImpl.this.withInvolvedObject(this.builder.build());
        }

        @Override
        public N endInvolvedObject() {
            return this.and();
        }
    }

    public class EventTimeNestedImpl<N>
    extends MicroTimeFluentImpl<EventFluent.EventTimeNested<N>>
    implements EventFluent.EventTimeNested<N>,
    Nested<N> {
        MicroTimeBuilder builder;

        EventTimeNestedImpl(MicroTime item) {
            this.builder = new MicroTimeBuilder(this, item);
        }

        EventTimeNestedImpl() {
            this.builder = new MicroTimeBuilder(this);
        }

        @Override
        public N and() {
            return (N)EventFluentImpl.this.withEventTime(this.builder.build());
        }

        @Override
        public N endEventTime() {
            return this.and();
        }
    }
}

