/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.exception.AzureException;
import com.azure.core.http.HttpHeader;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.http.rest.StreamResponse;
import com.azure.core.management.serializer.SerializerFactory;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.appservice.AppServiceManager;
import com.azure.resourcemanager.appservice.models.DeployType;
import com.azure.resourcemanager.appservice.models.KuduAuthenticationPolicy;
import com.azure.resourcemanager.appservice.models.KuduDeploymentResult;
import com.azure.resourcemanager.appservice.models.WebAppBase;
import com.azure.resourcemanager.resources.fluentcore.policy.AuthenticationPolicy;
import com.azure.resourcemanager.resources.fluentcore.policy.AuxiliaryAuthenticationPolicy;
import com.azure.resourcemanager.resources.fluentcore.policy.ProviderRegistrationPolicy;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.StandardOpenOption;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.reactivestreams.Publisher;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.retry.Retry;

class KuduClient {
    private final ClientLogger logger = new ClientLogger(this.getClass());
    private final String host;
    private final KuduService service;

    KuduClient(WebAppBase webAppBase) {
        if (webAppBase.defaultHostname() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new UnsupportedOperationException("Cannot initialize kudu client before web app is created"));
        }
        String host = webAppBase.defaultHostname().toLowerCase(Locale.ROOT).replace("http://", "").replace("https://", "");
        String[] parts = host.split("\\.", 2);
        host = parts[0] + ".scm." + parts[1];
        this.host = "https://" + host;
        ArrayList<HttpPipelinePolicy> policies = new ArrayList<HttpPipelinePolicy>();
        int count = ((AppServiceManager)((Object)webAppBase.manager())).httpPipeline().getPolicyCount();
        for (int i = 0; i < count; ++i) {
            HttpPipelinePolicy policy = ((AppServiceManager)((Object)webAppBase.manager())).httpPipeline().getPolicy(i);
            if (policy instanceof AuthenticationPolicy || policy instanceof ProviderRegistrationPolicy || policy instanceof AuxiliaryAuthenticationPolicy) continue;
            policies.add(policy);
        }
        policies.add(new KuduAuthenticationPolicy(webAppBase));
        HttpPipeline httpPipeline = new HttpPipelineBuilder().policies(policies.toArray(new HttpPipelinePolicy[0])).httpClient(((AppServiceManager)((Object)webAppBase.manager())).httpPipeline().getHttpClient()).build();
        this.service = (KuduService)RestProxy.create(KuduService.class, (HttpPipeline)httpPipeline, (SerializerAdapter)SerializerFactory.createDefaultManagementSerializerAdapter());
    }

    Flux<String> streamApplicationLogsAsync() {
        return KuduClient.streamFromFluxBytes((Flux<ByteBuffer>)this.service.streamApplicationLogs(this.host).flatMapMany(StreamResponse::getValue));
    }

    Flux<String> streamHttpLogsAsync() {
        return KuduClient.streamFromFluxBytes((Flux<ByteBuffer>)this.service.streamHttpLogs(this.host).flatMapMany(StreamResponse::getValue));
    }

    Flux<String> streamTraceLogsAsync() {
        return KuduClient.streamFromFluxBytes((Flux<ByteBuffer>)this.service.streamTraceLogs(this.host).flatMapMany(StreamResponse::getValue));
    }

    Flux<String> streamDeploymentLogsAsync() {
        return KuduClient.streamFromFluxBytes((Flux<ByteBuffer>)this.service.streamDeploymentLogs(this.host).flatMapMany(StreamResponse::getValue));
    }

    Flux<String> streamAllLogsAsync() {
        return KuduClient.streamFromFluxBytes((Flux<ByteBuffer>)this.service.streamAllLogs(this.host).flatMapMany(StreamResponse::getValue));
    }

    static Flux<String> streamFromFluxBytes(Flux<ByteBuffer> source) {
        int newLine = 10;
        int newLineR = 13;
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        return source.concatMap(byteBuffer -> {
            int index = KuduClient.findByte(byteBuffer, (byte)10);
            if (index == -1) {
                try {
                    stream.write(FluxUtil.byteBufferToArray((ByteBuffer)byteBuffer));
                    return Flux.empty();
                }
                catch (IOException e) {
                    return Flux.error((Throwable)e);
                }
            }
            ArrayList<String> lines = new ArrayList<String>();
            while ((index = KuduClient.findByte(byteBuffer, (byte)10)) != -1) {
                byte[] byteArray = new byte[index + 1];
                byteBuffer.get(byteArray);
                try {
                    stream.write(byteArray);
                    String line = new String(stream.toByteArray(), StandardCharsets.UTF_8);
                    if (line.isEmpty() || line.charAt(line.length() - 1) != '\n') continue;
                    if (!(line = line.substring(0, line.length() - 1)).isEmpty() && line.charAt(line.length() - 1) == '\r') {
                        line = line.substring(0, line.length() - 1);
                    }
                    lines.add(line);
                    stream.reset();
                }
                catch (IOException e) {
                    return Flux.error((Throwable)e);
                }
            }
            if (byteBuffer.hasRemaining()) {
                try {
                    stream.write(FluxUtil.byteBufferToArray((ByteBuffer)byteBuffer));
                }
                catch (IOException e) {
                    return Flux.error((Throwable)e);
                }
            }
            if (lines.isEmpty()) {
                return Flux.empty();
            }
            return Flux.fromIterable(lines);
        });
    }

    private static int findByte(ByteBuffer byteBuffer, byte b) {
        int position = byteBuffer.position();
        int index = -1;
        for (int i = 0; i < byteBuffer.remaining(); ++i) {
            if (byteBuffer.get(position + i) != b) continue;
            index = i;
            break;
        }
        return index;
    }

    Mono<Void> warDeployAsync(InputStream warFile, long length, String appName) {
        Flux flux = FluxUtil.toFluxByteBuffer((InputStream)warFile);
        return this.retryOnError(this.service.warDeploy(this.host, (Flux<ByteBuffer>)flux, length, appName));
    }

    Mono<Void> warDeployAsync(File warFile, String appName) throws IOException {
        AsynchronousFileChannel fileChannel = AsynchronousFileChannel.open(warFile.toPath(), StandardOpenOption.READ);
        return this.retryOnError(this.service.warDeploy(this.host, (Flux<ByteBuffer>)FluxUtil.readFile((AsynchronousFileChannel)fileChannel), fileChannel.size(), appName)).doFinally(ignored -> {
            try {
                fileChannel.close();
            }
            catch (IOException e) {
                this.logger.logThrowableAsError((Throwable)e);
            }
        });
    }

    Mono<Void> zipDeployAsync(InputStream zipFile, long length) {
        Flux flux = FluxUtil.toFluxByteBuffer((InputStream)zipFile);
        return this.retryOnError(this.service.zipDeploy(this.host, (Flux<ByteBuffer>)flux, length));
    }

    Mono<Void> zipDeployAsync(File zipFile) throws IOException {
        AsynchronousFileChannel fileChannel = AsynchronousFileChannel.open(zipFile.toPath(), StandardOpenOption.READ);
        return this.retryOnError(this.service.zipDeploy(this.host, (Flux<ByteBuffer>)FluxUtil.readFile((AsynchronousFileChannel)fileChannel), fileChannel.size())).doFinally(ignored -> {
            try {
                fileChannel.close();
            }
            catch (IOException e) {
                this.logger.logThrowableAsError((Throwable)e);
            }
        });
    }

    Mono<Void> deployAsync(DeployType type, InputStream file, long length, String path, Boolean restart, Boolean clean) {
        Flux flux = FluxUtil.toFluxByteBuffer((InputStream)file);
        return this.retryOnError(this.service.deploy(this.host, (Flux<ByteBuffer>)flux, length, type, path, restart, clean, false, false)).then();
    }

    Mono<Void> deployAsync(DeployType type, File file, String path, Boolean restart, Boolean clean) throws IOException {
        AsynchronousFileChannel fileChannel = AsynchronousFileChannel.open(file.toPath(), StandardOpenOption.READ);
        return this.retryOnError(this.service.deploy(this.host, (Flux<ByteBuffer>)FluxUtil.readFile((AsynchronousFileChannel)fileChannel), fileChannel.size(), type, path, restart, clean, false, false)).then().doFinally(ignored -> {
            try {
                fileChannel.close();
            }
            catch (IOException e) {
                this.logger.logThrowableAsError((Throwable)e);
            }
        });
    }

    Mono<KuduDeploymentResult> pushDeployAsync(DeployType type, File file, String path, Boolean restart, Boolean clean, Boolean trackDeployment) throws IOException {
        boolean trackDeploymentProgress = trackDeployment == null || trackDeployment != false;
        AsynchronousFileChannel fileChannel = AsynchronousFileChannel.open(file.toPath(), StandardOpenOption.READ);
        return this.retryOnError(this.service.deploy(this.host, (Flux<ByteBuffer>)FluxUtil.readFile((AsynchronousFileChannel)fileChannel), fileChannel.size(), type, path, restart, clean, true, trackDeployment)).map(response -> {
            HttpHeader deploymentIdHeader = response.getHeaders().get("SCM-DEPLOYMENT-ID");
            if (trackDeploymentProgress && (deploymentIdHeader == null || deploymentIdHeader.getValue() == null || deploymentIdHeader.getValue().isEmpty())) {
                throw this.logger.logExceptionAsError((RuntimeException)new AzureException("Deployment ID not found in response header 'SCM-DEPLOYMENT-ID'"));
            }
            return new KuduDeploymentResult(deploymentIdHeader == null ? null : deploymentIdHeader.getValue());
        }).doFinally(ignored -> {
            try {
                fileChannel.close();
            }
            catch (IOException e) {
                this.logger.logThrowableAsError((Throwable)e);
            }
        });
    }

    Mono<Map<String, String>> settings() {
        return this.retryOnError(this.service.settings(this.host));
    }

    private <T> Mono<T> retryOnError(Mono<T> observable) {
        int retryCount = 6;
        return observable.retryWhen(Retry.withThrowable(flux -> flux.zipWith((Publisher)Flux.range((int)1, (int)6), (throwable, count) -> {
            if (count < 6 && (throwable instanceof TimeoutException || throwable instanceof SocketTimeoutException)) {
                return count;
            }
            throw this.logger.logExceptionAsError(Exceptions.propagate((Throwable)throwable));
        }).flatMap(i -> Mono.delay((Duration)Duration.ofSeconds((long)i.intValue() * 10L)))));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="KuduService")
    private static interface KuduService {
        @Get(value="api/logstream/application")
        public Mono<StreamResponse> streamApplicationLogs(@HostParam(value="$host") String var1);

        @Get(value="api/logstream/http")
        public Mono<StreamResponse> streamHttpLogs(@HostParam(value="$host") String var1);

        @Get(value="api/logstream/kudu/trace")
        public Mono<StreamResponse> streamTraceLogs(@HostParam(value="$host") String var1);

        @Get(value="api/logstream/kudu/deployment")
        public Mono<StreamResponse> streamDeploymentLogs(@HostParam(value="$host") String var1);

        @Get(value="api/logstream")
        public Mono<StreamResponse> streamAllLogs(@HostParam(value="$host") String var1);

        @Headers(value={"Content-Type: application/octet-stream"})
        @Post(value="api/wardeploy")
        public Mono<Void> warDeploy(@HostParam(value="$host") String var1, @BodyParam(value="application/octet-stream") Flux<ByteBuffer> var2, @HeaderParam(value="content-length") long var3, @QueryParam(value="name") String var5);

        @Headers(value={"Content-Type: application/octet-stream"})
        @Post(value="api/zipdeploy")
        public Mono<Void> zipDeploy(@HostParam(value="$host") String var1, @BodyParam(value="application/octet-stream") Flux<ByteBuffer> var2, @HeaderParam(value="content-length") long var3);

        @Headers(value={"Content-Type: application/octet-stream"})
        @Post(value="api/publish")
        public Mono<Response<Void>> deploy(@HostParam(value="$host") String var1, @BodyParam(value="application/octet-stream") Flux<ByteBuffer> var2, @HeaderParam(value="content-length") long var3, @QueryParam(value="type") DeployType var5, @QueryParam(value="path") String var6, @QueryParam(value="restart") Boolean var7, @QueryParam(value="clean") Boolean var8, @QueryParam(value="isAsync") Boolean var9, @QueryParam(value="trackDeploymentProgress") Boolean var10);

        @Get(value="api/settings")
        public Mono<Map<String, String>> settings(@HostParam(value="$host") String var1);
    }
}

