/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.servicebus.implementation;

import com.azure.resourcemanager.servicebus.ServiceBusManager;
import com.azure.resourcemanager.servicebus.fluent.ServiceBusManagementClient;
import com.azure.resourcemanager.servicebus.fluent.models.AccessKeysInner;
import com.azure.resourcemanager.servicebus.fluent.models.SBAuthorizationRuleInner;
import com.azure.resourcemanager.servicebus.implementation.AuthorizationRuleBaseImpl;
import com.azure.resourcemanager.servicebus.implementation.QueueImpl;
import com.azure.resourcemanager.servicebus.models.QueueAuthorizationRule;
import com.azure.resourcemanager.servicebus.models.RegenerateAccessKeyParameters;
import reactor.core.publisher.Mono;

class QueueAuthorizationRuleImpl
extends AuthorizationRuleBaseImpl<QueueAuthorizationRule, QueueImpl, SBAuthorizationRuleInner, QueueAuthorizationRuleImpl, ServiceBusManager>
implements QueueAuthorizationRule,
QueueAuthorizationRule.Definition,
QueueAuthorizationRule.Update {
    private final String namespaceName;

    QueueAuthorizationRuleImpl(String resourceGroupName, String namespaceName, String queueName, String name, SBAuthorizationRuleInner inner, ServiceBusManager manager) {
        super(name, inner, manager);
        this.namespaceName = namespaceName;
        this.withExistingParentResource(resourceGroupName, queueName);
    }

    @Override
    public String namespaceName() {
        return this.namespaceName;
    }

    @Override
    public String queueName() {
        return this.parentName;
    }

    protected Mono<SBAuthorizationRuleInner> getInnerAsync() {
        return ((ServiceBusManagementClient)((ServiceBusManager)((Object)this.manager())).serviceClient()).getQueues().getAuthorizationRuleAsync(this.resourceGroupName(), this.namespaceName(), this.queueName(), this.name());
    }

    protected Mono<QueueAuthorizationRule> createChildResourceAsync() {
        QueueAuthorizationRuleImpl self = this;
        return ((ServiceBusManagementClient)((ServiceBusManager)((Object)this.manager())).serviceClient()).getQueues().createOrUpdateAuthorizationRuleAsync(this.resourceGroupName(), this.namespaceName(), this.queueName(), this.name(), (SBAuthorizationRuleInner)((Object)this.innerModel())).map(inner -> {
            this.setInner(inner);
            return self;
        });
    }

    @Override
    protected Mono<AccessKeysInner> getKeysInnerAsync() {
        return ((ServiceBusManagementClient)((ServiceBusManager)((Object)this.manager())).serviceClient()).getQueues().listKeysAsync(this.resourceGroupName(), this.namespaceName(), this.queueName(), this.name());
    }

    @Override
    protected Mono<AccessKeysInner> regenerateKeysInnerAsync(RegenerateAccessKeyParameters regenerateAccessKeyParameters) {
        return ((ServiceBusManagementClient)((ServiceBusManager)((Object)this.manager())).serviceClient()).getQueues().regenerateKeysAsync(this.resourceGroupName(), this.namespaceName(), this.queueName(), this.name(), regenerateAccessKeyParameters);
    }
}

