/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.registry.api;

import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.IStoppable;
import org.apache.dolphinscheduler.common.model.AlertServerHeartBeat;
import org.apache.dolphinscheduler.common.model.MasterHeartBeat;
import org.apache.dolphinscheduler.common.model.Server;
import org.apache.dolphinscheduler.common.model.WorkerHeartBeat;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.registry.api.ConnectionListener;
import org.apache.dolphinscheduler.registry.api.Registry;
import org.apache.dolphinscheduler.registry.api.RegistryException;
import org.apache.dolphinscheduler.registry.api.SubscribeListener;
import org.apache.dolphinscheduler.registry.api.enums.RegistryNodeType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class RegistryClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RegistryClient.class);
    private static final String EMPTY = "";
    private IStoppable stoppable;
    private final Registry registry;

    public RegistryClient(Registry registry) {
        this.registry = registry;
        if (!registry.exists(RegistryNodeType.MASTER.getRegistryPath())) {
            registry.put(RegistryNodeType.MASTER.getRegistryPath(), EMPTY, false);
        }
        if (!registry.exists(RegistryNodeType.WORKER.getRegistryPath())) {
            registry.put(RegistryNodeType.WORKER.getRegistryPath(), EMPTY, false);
        }
        if (!registry.exists(RegistryNodeType.ALERT_SERVER.getRegistryPath())) {
            registry.put(RegistryNodeType.ALERT_SERVER.getRegistryPath(), EMPTY, false);
        }
        if (!registry.exists(RegistryNodeType.FAILOVER_FINISH_NODES.getRegistryPath())) {
            registry.put(RegistryNodeType.FAILOVER_FINISH_NODES.getRegistryPath(), EMPTY, false);
        }
    }

    public boolean isConnected() {
        return this.registry.isConnected();
    }

    public void connectUntilTimeout(@NonNull Duration duration) throws RegistryException {
        if (duration == null) {
            throw new NullPointerException("duration is marked non-null but is null");
        }
        this.registry.connectUntilTimeout(duration);
    }

    public List<Server> getServerList(RegistryNodeType registryNodeType) {
        Map<String, String> serverMaps = this.getServerMaps(registryNodeType);
        ArrayList<Server> serverList = new ArrayList<Server>();
        for (Map.Entry<String, String> entry : serverMaps.entrySet()) {
            String serverPath = entry.getKey();
            String heartBeatJson = entry.getValue();
            if (StringUtils.isEmpty((CharSequence)heartBeatJson)) {
                log.error("The heartBeatJson is empty, serverPath: {}", (Object)serverPath);
                continue;
            }
            Server server = new Server();
            switch (registryNodeType) {
                case MASTER: {
                    MasterHeartBeat masterHeartBeat = (MasterHeartBeat)JSONUtils.parseObject((String)heartBeatJson, MasterHeartBeat.class);
                    server.setCreateTime(new Date(masterHeartBeat.getStartupTime()));
                    server.setLastHeartbeatTime(new Date(masterHeartBeat.getReportTime()));
                    server.setId(masterHeartBeat.getProcessId());
                    server.setHost(masterHeartBeat.getHost());
                    server.setPort(masterHeartBeat.getPort());
                    break;
                }
                case WORKER: {
                    WorkerHeartBeat workerHeartBeat = (WorkerHeartBeat)JSONUtils.parseObject((String)heartBeatJson, WorkerHeartBeat.class);
                    server.setCreateTime(new Date(workerHeartBeat.getStartupTime()));
                    server.setLastHeartbeatTime(new Date(workerHeartBeat.getReportTime()));
                    server.setId(workerHeartBeat.getProcessId());
                    server.setHost(workerHeartBeat.getHost());
                    server.setPort(workerHeartBeat.getPort());
                    break;
                }
                case ALERT_SERVER: {
                    AlertServerHeartBeat alertServerHeartBeat = (AlertServerHeartBeat)JSONUtils.parseObject((String)heartBeatJson, AlertServerHeartBeat.class);
                    server.setCreateTime(new Date(alertServerHeartBeat.getStartupTime()));
                    server.setLastHeartbeatTime(new Date(alertServerHeartBeat.getReportTime()));
                    server.setId(alertServerHeartBeat.getProcessId());
                    server.setHost(alertServerHeartBeat.getHost());
                    server.setPort(alertServerHeartBeat.getPort());
                    break;
                }
                default: {
                    log.warn("unknown registry node type: {}", (Object)registryNodeType);
                }
            }
            server.setHeartBeatInfo(heartBeatJson);
            server.setServerDirectory(registryNodeType.getRegistryPath() + "/" + serverPath);
            serverList.add(server);
        }
        return serverList;
    }

    public Optional<Server> getRandomServer(RegistryNodeType registryNodeType) {
        List<Server> serverList = this.getServerList(registryNodeType);
        if (CollectionUtils.isEmpty(serverList)) {
            return Optional.empty();
        }
        Server server = serverList.get(RandomUtils.nextInt((int)0, (int)serverList.size()));
        return Optional.ofNullable(server);
    }

    public Map<String, String> getServerMaps(RegistryNodeType nodeType) {
        HashMap<String, String> serverMap = new HashMap<String, String>();
        try {
            Collection<String> serverList = this.getServerNodes(nodeType);
            for (String server : serverList) {
                serverMap.putIfAbsent(server, this.get(nodeType.getRegistryPath() + "/" + server));
            }
        }
        catch (Exception e) {
            log.error("get server list failed", (Throwable)e);
        }
        return serverMap;
    }

    public boolean checkNodeExists(String host, RegistryNodeType nodeType) {
        return this.getServerMaps(nodeType).keySet().stream().anyMatch(it -> it.contains(host));
    }

    public void close() throws IOException {
        this.registry.close();
    }

    public void persistEphemeral(String key, String value) {
        this.registry.put(key, value, true);
    }

    public void persist(String key, String value) {
        log.info("persist key: {}, value: {}", (Object)key, (Object)value);
        this.registry.put(key, value, false);
    }

    public void remove(String key) {
        this.registry.delete(key);
    }

    public String get(String key) {
        return this.registry.get(key);
    }

    public void subscribe(String path, SubscribeListener listener) {
        this.registry.subscribe(path, listener);
    }

    public void addConnectionStateListener(ConnectionListener listener) {
        this.registry.addConnectionStateListener(listener);
    }

    public boolean exists(String key) {
        return this.registry.exists(key);
    }

    public boolean getLock(String key) {
        if (!this.registry.isConnected()) {
            throw new IllegalStateException("The registry is not connected");
        }
        return this.registry.acquireLock(key);
    }

    public boolean releaseLock(String key) {
        return this.registry.releaseLock(key);
    }

    public void setStoppable(IStoppable stoppable) {
        this.stoppable = stoppable;
    }

    public IStoppable getStoppable() {
        return this.stoppable;
    }

    public Collection<String> getChildrenKeys(String key) {
        return this.registry.children(key);
    }

    public Set<String> getServerNodeSet(RegistryNodeType nodeType) {
        try {
            return new HashSet<String>(this.getServerNodes(nodeType));
        }
        catch (Exception e) {
            throw new RegistryException("Failed to get server node: " + (Object)((Object)nodeType), e);
        }
    }

    private Collection<String> getServerNodes(RegistryNodeType nodeType) {
        return this.getChildrenKeys(nodeType.getRegistryPath());
    }
}

