/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.monitor.models.ScaleDirection;
import com.azure.resourcemanager.monitor.models.ScaleType;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Duration;

public final class ScaleAction {
    @JsonProperty(value="direction", required=true)
    private ScaleDirection direction;
    @JsonProperty(value="type", required=true)
    private ScaleType type;
    @JsonProperty(value="value")
    private String value;
    @JsonProperty(value="cooldown", required=true)
    private Duration cooldown;
    private static final ClientLogger LOGGER = new ClientLogger(ScaleAction.class);

    public ScaleDirection direction() {
        return this.direction;
    }

    public ScaleAction withDirection(ScaleDirection direction) {
        this.direction = direction;
        return this;
    }

    public ScaleType type() {
        return this.type;
    }

    public ScaleAction withType(ScaleType type) {
        this.type = type;
        return this;
    }

    public String value() {
        return this.value;
    }

    public ScaleAction withValue(String value) {
        this.value = value;
        return this;
    }

    public Duration cooldown() {
        return this.cooldown;
    }

    public ScaleAction withCooldown(Duration cooldown) {
        this.cooldown = cooldown;
        return this;
    }

    public void validate() {
        if (this.direction() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property direction in model ScaleAction"));
        }
        if (this.type() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property type in model ScaleAction"));
        }
        if (this.cooldown() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property cooldown in model ScaleAction"));
        }
    }
}

