/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.model;

import com.qcloud.cos.model.CannedAccessControlList;
import com.qcloud.cos.model.Grant;
import com.qcloud.cos.model.Grantee;
import com.qcloud.cos.model.GroupGrantee;
import com.qcloud.cos.model.Owner;
import com.qcloud.cos.model.Permission;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class AccessControlList
implements Serializable {
    private static final long serialVersionUID = 8095040648034788376L;
    private Set<Grant> grantSet;
    private List<Grant> grantList;
    private Owner owner = null;
    private boolean existDefaultAcl;

    public Owner getOwner() {
        return this.owner;
    }

    public void setOwner(Owner owner) {
        this.owner = owner;
    }

    public void grantPermission(Grantee grantee, Permission permission) {
        this.getGrantsAsList().add(new Grant(grantee, permission));
    }

    public void grantAllPermissions(Grant ... grantsVarArg) {
        for (Grant gap : grantsVarArg) {
            this.grantPermission(gap.getGrantee(), gap.getPermission());
        }
    }

    public void revokeAllPermissions(Grantee grantee) {
        ArrayList<Grant> grantsToRemove = new ArrayList<Grant>();
        List<Grant> existingGrants = this.getGrantsAsList();
        for (Grant gap : existingGrants) {
            if (!gap.getGrantee().equals(grantee)) continue;
            grantsToRemove.add(gap);
        }
        this.grantList.removeAll(grantsToRemove);
    }

    @Deprecated
    public Set<Grant> getGrants() {
        this.checkState();
        if (this.grantSet == null) {
            if (this.grantList == null) {
                this.grantSet = new HashSet<Grant>();
            } else {
                this.grantSet = new HashSet<Grant>(this.grantList);
                this.grantList = null;
            }
        }
        return this.grantSet;
    }

    private void checkState() {
        if (this.grantList != null && this.grantSet != null) {
            throw new IllegalStateException("Both grant set and grant list cannot be null");
        }
    }

    public List<Grant> getGrantsAsList() {
        this.checkState();
        if (this.grantList == null) {
            if (this.grantSet == null) {
                this.grantList = new LinkedList<Grant>();
            } else {
                this.grantList = new LinkedList<Grant>(this.grantSet);
                this.grantSet = null;
            }
        }
        return this.grantList;
    }

    public String toString() {
        return "AccessControlList [owner=" + this.owner + ", grants=" + this.getGrantsAsList() + "]";
    }

    private boolean isAllUsersGrantee(Grantee grantee) {
        String identifier = grantee.getIdentifier();
        return grantee.equals(GroupGrantee.AllUsers) || identifier != null && identifier.equals("qcs::cam::anyone:anyone");
    }

    public CannedAccessControlList getCannedAccessControl() {
        if (this.grantList == null) {
            return null;
        }
        if (this.existDefaultAcl) {
            return CannedAccessControlList.Default;
        }
        boolean allUsersRead = false;
        boolean allUsersWrite = false;
        for (Grant grant : this.grantList) {
            Grantee grantee = grant.getGrantee();
            Permission permission = grant.getPermission();
            if (grantee == null || permission == null || !this.isAllUsersGrantee(grantee)) continue;
            if (permission.equals((Object)Permission.Read)) {
                allUsersRead = true;
            }
            if (!permission.equals((Object)Permission.Write)) continue;
            allUsersWrite = true;
        }
        if (allUsersRead && allUsersWrite) {
            return CannedAccessControlList.PublicReadWrite;
        }
        if (allUsersRead) {
            return CannedAccessControlList.PublicRead;
        }
        return CannedAccessControlList.Private;
    }

    public boolean isExistDefaultAcl() {
        return this.existDefaultAcl;
    }

    public void setExistDefaultAcl(boolean existDefaultAcl) {
        this.existDefaultAcl = existDefaultAcl;
    }
}

